/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.client.gui.calculators;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import sonar.calculator.mod.common.containers.ContainerInfoCalculator;
import sonar.calculator.mod.guide.IItemInfo;
import sonar.calculator.mod.guide.InfoRegistry;
import sonar.core.helpers.FontHelper;

public class GuiInfoCalculator
extends GuiContainer {
    public static final ResourceLocation list = new ResourceLocation("Calculator:textures/gui/info_calculator.png");
    public static final ResourceLocation info = new ResourceLocation("Calculator:textures/gui/info_calculator_item.png");
    public EntityPlayer player;
    private GuiTextField search;
    public float currentScroll;
    private boolean isScrolling;
    private boolean wasClicking;
    public int scrollerLeft;
    public int scrollerStart;
    public int scrollerEnd;
    public int scrollerWidth;
    public IItemInfo.Category currentCategory = IItemInfo.Category.All;
    public ArrayList<IItemInfo> infoList = new ArrayList();
    public HashMap<Integer, ArrayList<String[]>> itemInfo = new HashMap();
    public int currentPos = -1;
    public int lastPos = -1;
    public int pageNum = 0;
    public GuiState currentState = GuiState.LIST;
    public String bulletPoint = "\u2022";
    public final int maxPerPage = 12;

    public GuiInfoCalculator(EntityPlayer player) {
        super((Container)new ContainerInfoCalculator(player));
        this.player = player;
        this.resetInfoList();
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        block5: {
            block4: {
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                Minecraft.func_71410_x().func_110434_K().func_110577_a(this.currentState.getBackground());
                this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
                if (this.currentState != GuiState.LIST) break block4;
                this.func_73729_b(this.scrollerLeft, this.scrollerStart + (int)((float)(this.scrollerEnd - this.scrollerStart - 17) * this.currentScroll), 119, 166, 8, 15);
                int offsetTop = 29;
                if (this.getViewableSize() == 7) {
                    ++offsetTop;
                }
                for (int i = 0; i < this.getViewableSize(); ++i) {
                    this.drawSelectionBackground(offsetTop, i, -1);
                }
                int pos = 0;
                this.prepareItemRender();
                for (IItemInfo.Category cat : IItemInfo.Category.values()) {
                    if (cat == IItemInfo.Category.All) continue;
                    Minecraft.func_71410_x().func_110434_K().func_110577_a(this.currentState.getBackground());
                    this.func_73729_b(this.field_147003_i + 136, this.field_147009_r + 2 + pos * 18, cat == this.currentCategory ? 154 : 136, 2, 18, 18);
                    this.renderItem(cat.stack, this.field_147003_i + 137, this.field_147009_r + 4 + pos * 18);
                    ++pos;
                }
                break block5;
            }
            if (this.currentPos >= this.infoList.size()) break block5;
            IItemInfo info = this.infoList.get(this.currentPos);
            int pos = 0;
            this.prepareItemRender();
            for (ItemStack stack : info.getRelatedItems()) {
                if (stack == null) continue;
                Minecraft.func_71410_x().func_110434_K().func_110577_a(list);
                this.func_73729_b(this.field_147003_i + 136, this.field_147009_r + 2 + pos * 18, 136, 2, 18, 18);
                this.renderItem(stack, this.field_147003_i + 137, this.field_147009_r + 4 + pos * 18);
                ++pos;
            }
        }
    }

    public void prepareItemRender() {
        GlStateManager.func_179145_e();
        GlStateManager.func_179126_j();
        RenderHelper.func_74520_c();
    }

    public void renderItem(ItemStack item, int x, int y) {
        if (item == null) {
            return;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)32.0f);
        this.field_146296_j.func_180450_b(item, x, y);
        this.field_146296_j.func_180453_a(this.field_146289_q, item, x, y, "");
        GlStateManager.func_179121_F();
    }

    public void resetPosition() {
        this.lastPos = -1;
        this.currentPos = -1;
        this.pageNum = 0;
        this.currentScroll = 0.0f;
    }

    public void resetInfo() {
        this.field_146292_n.clear();
        if (this.currentPos != -1 && this.currentPos < this.infoList.size()) {
            this.changeItemInfo(this.infoList.get(this.currentPos));
        }
        this.func_73866_w_();
    }

    public String getSearch() {
        if (this.search == null || this.search.func_146179_b() == null) {
            return "";
        }
        return this.search.func_146179_b();
    }

    public void resetInfoList() {
        ArrayList<IItemInfo> newInfo = InfoRegistry.getInfo(this.currentCategory);
        String search = this.getSearch();
        if (!search.isEmpty() && search != null) {
            newInfo = new ArrayList();
            for (IItemInfo item : InfoRegistry.getInfo(this.currentCategory)) {
                if (item == null || !item.getItem().func_82833_r().toLowerCase().contains(search.toLowerCase())) continue;
                newInfo.add(item);
            }
        }
        this.infoList = newInfo;
        this.currentScroll = 0.0f;
    }

    public void changeItemInfo(IItemInfo info) {
        HashMap itemInfo = new HashMap();
        String[] strings = FontHelper.translate((String)info.getItemInfo()).split("-");
        int pageNum = 0;
        int pageSize = 0;
        for (int i = 0; i < strings.length; ++i) {
            String name = this.bulletPoint + " " + strings[i];
            List lineInfo = this.field_146289_q.func_78271_c(name, (int)((double)this.field_146999_f * 1.25) - 6);
            if (pageSize + lineInfo.size() < 12) {
                pageSize += lineInfo.size();
            } else {
                pageSize = lineInfo.size();
                ++pageNum;
            }
            itemInfo.putIfAbsent(pageNum, new ArrayList());
            ((ArrayList)itemInfo.get(pageNum)).add((String[])lineInfo.toArray());
        }
        this.itemInfo = itemInfo;
    }

    public void func_73866_w_() {
        Keyboard.enableRepeatEvents((boolean)true);
        this.field_146292_n.clear();
        this.field_146297_k.field_71439_g.field_71070_bA = this.field_147002_h;
        this.field_146999_f = 136;
        this.field_147000_g = 166;
        this.field_147003_i = (this.field_146294_l - this.field_146999_f) / 2;
        this.field_147009_r = (this.field_146295_m - this.field_147000_g) / 2;
        if (this.currentState == GuiState.LIST) {
            this.scrollerLeft = this.field_147003_i + 136 - 12;
            this.scrollerStart = this.field_147009_r + 30;
            this.scrollerEnd = this.scrollerStart + 128;
            this.scrollerWidth = 10;
            int offsetTop = 29;
            if (this.getViewableSize() == 7) {
                offsetTop += 2;
            }
            if (this.search == null) {
                this.search = new GuiTextField(0, this.field_146289_q, 5, 16, 125, 12);
                this.search.func_146203_f(16);
            }
            int pos = 0;
            for (IItemInfo.Category cat : IItemInfo.Category.values()) {
                if (cat == IItemInfo.Category.All) continue;
                this.field_146292_n.add(new GuiButton(pos + 1, this.field_147003_i + 136, this.field_147009_r + 2 + pos * 18, 18, 18, "" + pos){

                    public void func_146112_a(Minecraft mc, int mouseX, int mouseY) {
                        if (this.field_146125_m) {
                            this.field_146123_n = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
                            int i = this.func_146114_a(this.field_146123_n);
                            if (this.func_146115_a()) {
                                GuiInfoCalculator.this.func_146279_a("" + (Object)((Object)IItemInfo.Category.values()[this.field_146127_k]), mouseX, mouseY);
                            }
                        }
                    }

                    public void func_146111_b(int x, int y) {
                        GuiInfoCalculator.this.func_146279_a("" + (Object)((Object)IItemInfo.Category.values()[this.field_146127_k]), x, y);
                    }
                });
                ++pos;
            }
        } else {
            IItemInfo info = this.infoList.get(this.currentPos);
            if (info != null) {
                for (int pos = 0; pos != 10; ++pos) {
                    this.field_146292_n.add(new GuiButton(10 + pos, this.field_147003_i + 136, this.field_147009_r + 2 + pos * 18, 18, 18, ""){

                        public void func_146112_a(Minecraft mc, int mouseX, int mouseY) {
                            if (this.field_146125_m) {
                                IItemInfo info;
                                this.field_146123_n = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
                                int i = this.func_146114_a(this.field_146123_n);
                                if (this.func_146115_a() && (info = GuiInfoCalculator.this.infoList.get(GuiInfoCalculator.this.currentPos)) != null && info.getRelatedItems() != null && this.field_146127_k - 10 < info.getRelatedItems().length) {
                                    GuiInfoCalculator.this.func_146279_a("" + info.getRelatedItems()[this.field_146127_k - 10].func_82833_r(), mouseX, mouseY);
                                }
                                RenderHelper.func_74520_c();
                            }
                        }
                    });
                }
            }
            this.field_146292_n.add(new GuiButton(0, this.field_147003_i + 6, this.field_147009_r + 140, 20, 20, "<<"));
            this.field_146292_n.add(new GuiButton(1, this.field_147003_i + 110, this.field_147009_r + 140, 20, 20, ">>"));
            this.field_146292_n.add(new GuiButton(2, this.field_147003_i + 26, this.field_147009_r + 140, 20, 20, "<"));
            this.field_146292_n.add(new GuiButton(3, this.field_147003_i + 90, this.field_147009_r + 140, 20, 20, ">"));
        }
    }

    public void func_146284_a(GuiButton button) throws IOException {
        super.func_146284_a(button);
        if (button == null) {
            return;
        }
        if (this.currentState == GuiState.LIST) {
            this.currentCategory = IItemInfo.Category.values()[button.field_146127_k];
            this.resetInfoList();
        } else if (this.currentState == GuiState.INFO) {
            if (button.field_146127_k >= 10) {
                IItemInfo info = this.infoList.get(this.currentPos);
                if (info == null || button.field_146127_k - 10 >= info.getRelatedItems().length) {
                    return;
                }
                ItemStack stack = info.getRelatedItems()[button.field_146127_k - 10];
                if (stack == null) {
                    return;
                }
                int pos = 0;
                boolean found = false;
                for (IItemInfo itemInfo : InfoRegistry.getInfo(IItemInfo.Category.All)) {
                    if (!found && ItemStack.func_179545_c((ItemStack)itemInfo.getItem(), (ItemStack)stack)) {
                        this.currentPos = pos;
                        this.pageNum = 0;
                        this.currentCategory = IItemInfo.Category.All;
                        this.resetInfoList();
                        this.changeItemInfo(itemInfo);
                        found = true;
                    }
                    if (itemInfo == info) {
                        this.lastPos = pos;
                    }
                    ++pos;
                }
            } else {
                this.buttonPressed(button.field_146127_k);
            }
        }
    }

    public void buttonPressed(int id) {
        switch (id) {
            case 0: {
                this.currentPos = this.currentPos != 0 ? --this.currentPos : this.infoList.size() - 1;
                this.lastPos = -1;
                this.pageNum = 0;
                this.changeItemInfo(this.infoList.get(this.currentPos));
                break;
            }
            case 1: {
                this.currentPos = this.currentPos + 1 < this.infoList.size() ? ++this.currentPos : 0;
                this.lastPos = -1;
                this.pageNum = 0;
                this.changeItemInfo(this.infoList.get(this.currentPos));
                break;
            }
            case 2: {
                if (this.pageNum != 0) {
                    --this.pageNum;
                    break;
                }
                this.buttonPressed(0);
                break;
            }
            case 3: {
                if (this.pageNum + 1 < this.itemInfo.size()) {
                    ++this.pageNum;
                    break;
                }
                this.buttonPressed(1);
            }
        }
    }

    public void func_146979_b(int x, int y) {
        super.func_146979_b(x, y);
        if (this.currentState == GuiState.LIST) {
            FontHelper.textCentre((String)FontHelper.translate((String)"item.InfoCalculator.name"), (int)this.field_146999_f, (int)6, (int)0);
            this.prepareItemRender();
            if (this.infoList != null) {
                int start = (int)((float)this.infoList.size() * this.currentScroll);
                int finish = Math.min(start + this.getViewableSize(), this.infoList.size());
                for (int i = start; i < finish; ++i) {
                    IItemInfo info = this.infoList.get(i);
                    ItemStack item = info.getItem();
                    if (item != null) {
                        this.renderItem(item, 5, 31 + (i - start) * 18);
                        GlStateManager.func_179094_E();
                        GlStateManager.func_179139_a((double)0.8, (double)0.8, (double)0.8);
                        String name = item.func_82833_r();
                        if (this.field_146289_q.func_78256_a(name) > 120) {
                            name = this.field_146289_q.func_78269_a(name, 114) + "...";
                        }
                        FontHelper.text((String)name, (int)33, (int)((int)(45.0 + (double)(i - start) * 18.0 * 1.25)), (int)-1);
                        GlStateManager.func_179121_F();
                        continue;
                    }
                    FontHelper.text((String)"Opps: error", (int)28, (int)(35 + (i - start) * 18), (int)-1);
                }
            }
            this.search.func_146194_f();
        } else {
            this.prepareItemRender();
            IItemInfo info = this.infoList.get(this.currentPos);
            ItemStack item = info.getItem();
            if (item != null) {
                this.renderItem(item, 5, 5);
                GlStateManager.func_179094_E();
                GlStateManager.func_179139_a((double)0.8, (double)0.8, (double)0.8);
                FontHelper.text((String)(TextFormatting.UNDERLINE + item.func_82833_r()), (int)35, (int)12, (int)1);
                GlStateManager.func_179121_F();
            }
            GlStateManager.func_179094_E();
            GlStateManager.func_179140_f();
            GlStateManager.func_179139_a((double)0.8, (double)0.8, (double)0.8);
            int size = 28;
            for (String[] ss : this.itemInfo.get(this.pageNum)) {
                int pos = 0;
                for (String s : ss) {
                    int X = 6;
                    FontHelper.text((String)s, (int)X, (int)size, (int)0);
                    size = pos == ss.length - 1 ? (size += 16) : (size += 11);
                    ++pos;
                }
            }
            GlStateManager.func_179121_F();
            FontHelper.textCentre((String)(this.currentPos + 1 + " / " + this.infoList.size()), (int)this.field_146999_f, (int)152, (int)0);
            FontHelper.textCentre((String)(this.pageNum + 1 + " / " + this.itemInfo.size()), (int)this.field_146999_f, (int)142, (int)0);
        }
    }

    public void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        if (this.currentState == GuiState.LIST) {
            int x = mouseX - this.field_147003_i;
            int y = mouseY - this.field_147009_r;
            this.search.func_146192_a(x, y, mouseButton);
            if (x > 3 && x < 124) {
                int start = (int)((float)this.infoList.size() * this.currentScroll);
                int finish = Math.min(start + this.getViewableSize(), this.infoList.size());
                for (int i = start; i < finish; ++i) {
                    if (i >= this.infoList.size() || y <= 29 + (i - start) * 18 || y >= 29 + (i - start) * 18 + 18) continue;
                    IItemInfo info = this.infoList.get(i);
                    if (info != null) {
                        this.resetPosition();
                        this.currentPos = i;
                        this.changeItemInfo(this.infoList.get(this.currentPos));
                        this.currentState = GuiState.INFO;
                        this.resetInfo();
                        continue;
                    }
                    this.currentPos = -1;
                }
            }
        }
    }

    protected void func_73869_a(char c, int i) throws IOException {
        if (this.currentState == GuiState.LIST && this.search.func_146206_l()) {
            if (c == '\r' || c == '\u001b') {
                this.search.func_146195_b(false);
            } else {
                this.search.func_146201_a(c, i);
                this.resetInfoList();
            }
        } else {
            if (i == 1 || i == this.field_146297_k.field_71474_y.field_151445_Q.func_151463_i()) {
                if (this.currentState == GuiState.INFO && this.lastPos != -1) {
                    int last = this.lastPos;
                    this.resetPosition();
                    this.currentPos = last;
                    this.currentCategory = IItemInfo.Category.All;
                    this.resetInfo();
                    return;
                }
                if (this.currentState == GuiState.INFO || this.currentCategory != IItemInfo.Category.All) {
                    this.resetPosition();
                    if (this.currentState == GuiState.LIST) {
                        this.currentCategory = IItemInfo.Category.All;
                    }
                    this.currentState = GuiState.LIST;
                    this.resetInfoList();
                    this.resetInfo();
                    return;
                }
            }
            super.func_73869_a(c, i);
        }
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        if (this.currentState == GuiState.LIST) {
            float lastScroll = this.currentScroll;
            int i = Mouse.getEventDWheel();
            if (i != 0 && this.needsScrollBars()) {
                int j = this.infoList.size() + 1;
                if (i > 0) {
                    i = 1;
                }
                if (i < 0) {
                    i = -1;
                }
                this.currentScroll = (float)((double)this.currentScroll - (double)i / (double)j);
                if (this.currentScroll < 0.0f) {
                    this.currentScroll = 0.0f;
                }
                if (this.currentScroll > 1.0f) {
                    this.currentScroll = 1.0f;
                }
            }
        }
    }

    public void func_73863_a(int x, int y, float var) {
        super.func_73863_a(x, y, var);
        if (this.currentState == GuiState.LIST) {
            float lastScroll = this.currentScroll;
            boolean flag = Mouse.isButtonDown((int)0);
            if (!this.wasClicking && flag && x >= this.scrollerLeft && y >= this.scrollerStart && x < this.scrollerLeft + this.scrollerWidth && y < this.scrollerEnd) {
                this.isScrolling = this.needsScrollBars();
            }
            if (!flag) {
                this.isScrolling = false;
            }
            this.wasClicking = flag;
            if (this.isScrolling) {
                this.currentScroll = ((float)(y - this.scrollerStart) - 7.5f) / ((float)(this.scrollerEnd - this.scrollerStart) - 1.0f);
                if (this.currentScroll < 0.0f) {
                    this.currentScroll = 0.0f;
                }
                if (this.currentScroll > 1.0f) {
                    this.currentScroll = 1.0f;
                }
            }
        }
    }

    public void drawSelectionBackground(int offsetTop, int i, int pos) {
        this.func_73729_b(this.field_147003_i + 4, this.field_147009_r + offsetTop + this.getSelectionHeight() * i, 0, i == pos ? 166 + this.getSelectionHeight() : 166, 119, this.getSelectionHeight());
    }

    public int getViewableSize() {
        return 7;
    }

    public int getSelectionHeight() {
        return 18;
    }

    private boolean needsScrollBars() {
        return this.infoList.size() > this.getViewableSize();
    }

    public static enum GuiState {
        LIST,
        INFO;


        public ResourceLocation getBackground() {
            switch (this) {
                case LIST: {
                    return list;
                }
                case INFO: {
                    return info;
                }
            }
            return null;
        }
    }
}

