/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.client.gui.misc;

import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import sonar.calculator.mod.Calculator;
import sonar.calculator.mod.api.items.IFlawlessCalculator;
import sonar.calculator.mod.api.modules.IModule;
import sonar.calculator.mod.common.containers.ContainerModuleSelector;
import sonar.calculator.mod.common.item.calculators.modules.EmptyModule;
import sonar.calculator.mod.network.packets.PacketModuleSelection;
import sonar.core.helpers.FontHelper;

public class GuiModuleSelector
extends GuiContainer {
    public static final ResourceLocation bground = new ResourceLocation("Calculator:textures/gui/module_selection.png");
    public ItemStack calc;
    public EntityPlayer player;
    public float currentScroll;
    private boolean isScrolling;
    private boolean wasClicking;
    public int scrollerLeft;
    public int scrollerStart;
    public int scrollerEnd;
    public int scrollerWidth;
    public ArrayList<IModule> modules = new ArrayList();
    public IModule current = EmptyModule.EMPTY;
    public int currentSlot = -1;

    public GuiModuleSelector(EntityPlayer player, ItemStack calc) {
        super((Container)new ContainerModuleSelector(player, calc));
        this.calc = calc;
        this.player = player;
        Item item = calc.func_77973_b();
        if (item instanceof IFlawlessCalculator) {
            this.modules = ((IFlawlessCalculator)item).getModules(calc);
            this.current = ((IFlawlessCalculator)item).getCurrentModule(calc);
            this.currentSlot = ((IFlawlessCalculator)item).getCurrentSlot(calc);
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(bground);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        this.func_73729_b(this.scrollerLeft, this.scrollerStart + (int)((float)(this.scrollerEnd - this.scrollerStart - 17) * this.currentScroll), 136, 0, 8, 15);
        int pos = this.getDataPosition();
        int offsetTop = 29;
        if (this.getViewableSize() == 7) {
            ++offsetTop;
        }
        for (int i = 0; i < this.getViewableSize(); ++i) {
            this.drawSelectionBackground(offsetTop, i, pos);
        }
    }

    public void func_73866_w_() {
        Keyboard.enableRepeatEvents((boolean)true);
        this.field_146297_k.field_71439_g.field_71070_bA = this.field_147002_h;
        this.field_146999_f = 136;
        this.field_147000_g = 166;
        this.field_147003_i = (this.field_146294_l - this.field_146999_f) / 2;
        this.field_147009_r = (this.field_146295_m - this.field_147000_g) / 2;
        this.scrollerLeft = this.field_147003_i + 136 - 12;
        this.scrollerStart = this.field_147009_r + 30;
        this.scrollerEnd = this.scrollerStart + 128;
        this.scrollerWidth = 10;
        int offsetTop = 29;
        if (this.getViewableSize() == 7) {
            offsetTop += 2;
        }
    }

    public int getDataPosition() {
        if (this.modules == null) {
            return -1;
        }
        if (this.current == EmptyModule.EMPTY) {
            return -1;
        }
        int start = (int)((float)this.modules.size() * this.currentScroll);
        int finish = Math.min(start + this.getViewableSize(), this.modules.size());
        for (int i = start; i < finish; ++i) {
            IModule module = this.modules.get(i);
            if (module == null || module == EmptyModule.EMPTY || !module.getName().equals(this.current.getName()) || i != this.currentSlot) continue;
            return i - start;
        }
        return -1;
    }

    public void func_146979_b(int x, int y) {
        super.func_146979_b(x, y);
        FontHelper.textCentre((String)FontHelper.translate((String)"item.FlawlessCalculator.name"), (int)this.field_146999_f, (int)10, (int)0);
        if (this.modules != null) {
            int start = (int)((float)this.modules.size() * this.currentScroll);
            int finish = Math.min(start + this.getViewableSize(), this.modules.size());
            int pos = this.getDataPosition();
            for (int i = start; i < finish; ++i) {
                IModule module = this.modules.get(i);
                if (module != null && module != EmptyModule.EMPTY) {
                    Item item = (Item)Calculator.moduleItems.getPrimaryObject(module.getName());
                    if (item != null) {
                        this.field_146296_j.func_175042_a(new ItemStack(item, 1), 5, 31 + (i - start) * 18);
                    }
                    FontHelper.text((String)module.getClientName(), (int)28, (int)(35 + (i - start) * 18), (int)-1);
                    continue;
                }
                FontHelper.text((String)"-empty-", (int)28, (int)(35 + (i - start) * 18), (int)-1);
            }
        }
    }

    public void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        int x = mouseX - this.field_147003_i;
        int y = mouseY - this.field_147009_r;
        if (x > 3 && x < 124) {
            int start = (int)((float)this.modules.size() * this.currentScroll);
            int finish = Math.min(start + this.getViewableSize(), this.modules.size());
            for (int i = start; i < finish; ++i) {
                IModule module;
                if (i >= this.modules.size() || y <= 29 + (i - start) * 18 || y >= 29 + (i - start) * 18 + 18 || (module = this.modules.get(i)) == null || module == EmptyModule.EMPTY) continue;
                this.current = module;
                this.currentSlot = i;
                Calculator.network.sendToServer((IMessage)new PacketModuleSelection(this.current, this.currentSlot));
            }
        }
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        float lastScroll = this.currentScroll;
        int i = Mouse.getEventDWheel();
        if (i != 0 && this.needsScrollBars()) {
            int j = this.modules.size() + 1;
            if (i > 0) {
                i = 1;
            }
            if (i < 0) {
                i = -1;
            }
            this.currentScroll = (float)((double)this.currentScroll - (double)i / (double)j);
            if (this.currentScroll < 0.0f) {
                this.currentScroll = 0.0f;
            }
            if (this.currentScroll > 1.0f) {
                this.currentScroll = 1.0f;
            }
        }
    }

    public void func_73863_a(int x, int y, float var) {
        super.func_73863_a(x, y, var);
        float lastScroll = this.currentScroll;
        boolean flag = Mouse.isButtonDown((int)0);
        if (!this.wasClicking && flag && x >= this.scrollerLeft && y >= this.scrollerStart && x < this.scrollerLeft + this.scrollerWidth && y < this.scrollerEnd) {
            this.isScrolling = this.needsScrollBars();
        }
        if (!flag) {
            this.isScrolling = false;
        }
        this.wasClicking = flag;
        if (this.isScrolling) {
            this.currentScroll = ((float)(y - this.scrollerStart) - 7.5f) / ((float)(this.scrollerEnd - this.scrollerStart) - 1.0f);
            if (this.currentScroll < 0.0f) {
                this.currentScroll = 0.0f;
            }
            if (this.currentScroll > 1.0f) {
                this.currentScroll = 1.0f;
            }
        }
    }

    public void drawSelectionBackground(int offsetTop, int i, int pos) {
        this.func_73729_b(this.field_147003_i + 4, this.field_147009_r + offsetTop + this.getSelectionHeight() * i, 0, i == pos ? 166 + this.getSelectionHeight() : 166, 226, this.getSelectionHeight());
    }

    public int getViewableSize() {
        return 7;
    }

    public int getSelectionHeight() {
        return 18;
    }

    private boolean needsScrollBars() {
        return this.modules.size() > this.getViewableSize();
    }
}

