/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.client.gui.misc;

import java.awt.Color;
import java.io.IOException;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import sonar.calculator.mod.api.machines.TeleportLink;
import sonar.calculator.mod.common.tileentity.misc.TileEntityTeleporter;
import sonar.core.SonarCore;
import sonar.core.client.gui.GuiSonar;
import sonar.core.client.gui.SonarButtons;
import sonar.core.common.tileentity.TileEntitySonar;
import sonar.core.helpers.FontHelper;
import sonar.core.inventory.ContainerEmpty;
import sonar.core.network.PacketByteBuf;
import sonar.core.network.utils.ByteBufWritable;
import sonar.core.network.utils.IByteBufTile;
import sonar.core.utils.IWorldPosition;

public class GuiTeleporter
extends GuiSonar {
    public static ResourceLocation network = new ResourceLocation("Calculator:textures/gui/teleporter.png");
    public TileEntityTeleporter entity;
    private GuiTextField name;
    private GuiTextField password;
    private GuiTextField destinationPassword;
    private float currentScroll;
    private boolean isScrolling;
    private boolean wasClicking;
    private int currentID;
    public int scrollerLeft;
    public int scrollerStart;
    public int scrollerEnd;
    public int scrollerWidth;

    public GuiTeleporter(InventoryPlayer player, TileEntityTeleporter entity) {
        super((Container)new ContainerEmpty(player, (TileEntitySonar)entity), (IWorldPosition)entity);
        this.entity = entity;
    }

    public void func_146979_b(int x, int y) {
        super.func_146979_b(x, y);
        this.name.func_146194_f();
        this.password.func_146194_f();
        this.destinationPassword.func_146194_f();
        List<TeleportLink> links = this.entity.links;
        if (links != null) {
            int start = (int)((float)links.size() * this.currentScroll);
            int finish = Math.min(start + 4, links.size());
            for (int i = start; i < finish; ++i) {
                if (links.get(i) == null) continue;
                if (links.get((int)i).networkID == this.entity.linkID) {
                    FontHelper.text((String)links.get((int)i).networkName, (int)90, (int)(7 + 12 * i - 12 * start), (int)Color.GREEN.getRGB());
                    continue;
                }
                FontHelper.text((String)links.get((int)i).networkName, (int)90, (int)(7 + 12 * i - 12 * start), (int)2);
            }
        }
        FontHelper.text((String)"Teleporter", (int)16, (int)6, (int)0);
        GL11.glPushMatrix();
        GL11.glScaled((double)0.75, (double)0.75, (double)0.75);
        FontHelper.textOffsetCentre((String)("X: " + this.entity.func_174877_v().func_177958_n() + " Y: " + this.entity.func_174877_v().func_177956_o() + " Z: " + this.entity.func_174877_v().func_177952_p()), (int)57, (int)26, (int)0);
        FontHelper.textOffsetCentre((String)("Dimension: " + this.entity.getCoords().getDimension()), (int)57, (int)35, (int)0);
        GL11.glPopMatrix();
        FontHelper.text((String)"Password: ", (int)18, (int)56, (int)0);
        FontHelper.text((String)"Password: ", (int)97, (int)56, (int)Color.GREEN.getRGB());
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        Keyboard.enableRepeatEvents((boolean)true);
        this.name = new GuiTextField(0, this.field_146289_q, 8, 40, 70, 12);
        this.name.func_146203_f(10);
        this.name.func_146180_a(String.valueOf(this.entity.name));
        this.password = new GuiTextField(1, this.field_146289_q, 8, 66, 70, 12);
        this.password.func_146203_f(10);
        this.password.func_146180_a(String.valueOf(this.entity.password));
        this.destinationPassword = new GuiTextField(2, this.field_146289_q, 87, 66, 70, 12);
        this.destinationPassword.func_146203_f(10);
        this.destinationPassword.func_146180_a(String.valueOf(this.entity.linkPassword));
        this.currentID = this.entity.linkID;
        this.scrollerLeft = this.field_147003_i + 163;
        this.scrollerStart = this.field_147009_r + 32 - 26;
        this.scrollerEnd = this.scrollerStart + 48;
        this.scrollerWidth = 10;
        this.field_146292_n.add(new NetworkButton(10, this.field_147003_i + 86, this.field_147009_r + 19 + 12 - 26));
        this.field_146292_n.add(new NetworkButton(11, this.field_147003_i + 86, this.field_147009_r + 19 + 24 - 26));
        this.field_146292_n.add(new NetworkButton(12, this.field_147003_i + 86, this.field_147009_r + 19 + 36 - 26));
        this.field_146292_n.add(new NetworkButton(13, this.field_147003_i + 86, this.field_147009_r + 19 + 48 - 26));
    }

    public String passwordConversion(String string) {
        char[] dots = new char[string.length()];
        for (int i = 0; i < string.length(); ++i) {
            dots[i] = "*".charAt(0);
        }
        return dots.toString();
    }

    protected void func_73864_a(int i, int j, int k) {
        this.name.func_146192_a(i - this.field_147003_i, j - this.field_147009_r, k);
        this.password.func_146192_a(i - this.field_147003_i, j - this.field_147009_r, k);
        this.destinationPassword.func_146192_a(i - this.field_147003_i, j - this.field_147009_r, k);
    }

    public ResourceLocation getBackground() {
        return new ResourceLocation("Calculator:textures/gui/teleporter.png");
    }

    public void func_146274_d() {
        float lastScroll = this.currentScroll;
        int i = Mouse.getEventDWheel();
        if (i != 0 && this.needsScrollBars()) {
            int j = this.entity.links.size() + 1;
            if (i > 0) {
                i = 1;
            }
            if (i < 0) {
                i = -1;
            }
            this.currentScroll = (float)((double)this.currentScroll - (double)i / (double)j);
            if (this.currentScroll < 0.0f) {
                this.currentScroll = 0.0f;
            }
            if (this.currentScroll > 1.0f) {
                this.currentScroll = 1.0f;
            }
        }
    }

    public void func_73863_a(int x, int y, float var) {
        super.func_73863_a(x, y, var);
        float lastScroll = this.currentScroll;
        boolean flag = Mouse.isButtonDown((int)0);
        if (!this.wasClicking && flag && x >= this.scrollerLeft && y >= this.scrollerStart && x < this.scrollerLeft + this.scrollerWidth && y < this.scrollerEnd) {
            this.isScrolling = this.needsScrollBars();
        }
        if (!flag) {
            this.isScrolling = false;
        }
        this.wasClicking = flag;
        if (this.isScrolling) {
            this.currentScroll = ((float)(y - this.scrollerStart) - 7.5f) / ((float)(this.scrollerEnd - this.scrollerStart) - 15.0f);
            if (this.currentScroll < 0.0f) {
                this.currentScroll = 0.0f;
            }
            if (this.currentScroll > 1.0f) {
                this.currentScroll = 1.0f;
            }
        }
    }

    protected void func_73869_a(char c, int i) throws IOException {
        if (this.name.func_146206_l()) {
            if (c == '\r' || c == '\u001b') {
                this.name.func_146195_b(false);
            } else {
                this.name.func_146201_a(c, i);
                String text = this.name.func_146179_b();
                if (text.isEmpty() || text == "" || text == null) {
                    this.entity.name.setObject((Object)"");
                } else {
                    this.entity.name.setObject((Object)text);
                }
                if (text.isEmpty() || text == "" || text == null) {
                    SonarCore.network.sendToServer((IMessage)new PacketByteBuf((IByteBufTile)this.entity, this.entity.func_174877_v(), 1, new ByteBufWritable[0]));
                } else {
                    SonarCore.network.sendToServer((IMessage)new PacketByteBuf((IByteBufTile)this.entity, this.entity.func_174877_v(), 1, new ByteBufWritable[0]));
                }
            }
        } else if (this.password.func_146206_l()) {
            if (c == '\r' || c == '\u001b') {
                this.password.func_146195_b(false);
            } else {
                this.password.func_146201_a(c, i);
                String text = this.password.func_146179_b();
                if (text.isEmpty() || text == "" || text == null) {
                    this.entity.password.setObject((Object)"");
                } else {
                    this.entity.password.setObject((Object)text);
                }
                if (text.isEmpty() || text == "" || text == null) {
                    SonarCore.network.sendToServer((IMessage)new PacketByteBuf((IByteBufTile)this.entity, this.entity.func_174877_v(), 2, new ByteBufWritable[0]));
                } else {
                    SonarCore.network.sendToServer((IMessage)new PacketByteBuf((IByteBufTile)this.entity, this.entity.func_174877_v(), 2, new ByteBufWritable[0]));
                }
            }
        } else if (this.destinationPassword.func_146206_l()) {
            if (c == '\r' || c == '\u001b') {
                this.destinationPassword.func_146195_b(false);
            } else {
                this.destinationPassword.func_146201_a(c, i);
                String text = this.destinationPassword.func_146179_b();
                if (text.isEmpty() || text == "" || text == null) {
                    this.entity.linkPassword.setObject((Object)"");
                } else {
                    this.entity.linkPassword.setObject((Object)text);
                }
                if (text.isEmpty() || text == "" || text == null) {
                    SonarCore.network.sendToServer((IMessage)new PacketByteBuf((IByteBufTile)this.entity, this.entity.func_174877_v(), 3, new ByteBufWritable[0]));
                } else {
                    SonarCore.network.sendToServer((IMessage)new PacketByteBuf((IByteBufTile)this.entity, this.entity.func_174877_v(), 3, new ByteBufWritable[0]));
                }
            }
        } else {
            super.func_73869_a(c, i);
        }
    }

    private boolean needsScrollBars() {
        if (this.entity.links == null) {
            return false;
        }
        return this.entity.links.size() > 4;
    }

    protected void func_146284_a(GuiButton button) {
        int start;
        int network;
        if (button.field_146127_k >= 10 && this.entity.links != null && (network = (start = (int)((float)this.entity.links.size() * this.currentScroll)) + button.field_146127_k - 10) < this.entity.links.size()) {
            this.entity.linkID = this.entity.links.get((int)network).networkID;
            SonarCore.network.sendToServer((IMessage)new PacketByteBuf((IByteBufTile)this.entity, this.entity.func_174877_v(), 0, new ByteBufWritable[0]));
        }
    }

    public int getLinkPosition() {
        if (this.entity.linkID == 0) {
            return -1;
        }
        List<TeleportLink> links = this.entity.links;
        if (links == null) {
            return -1;
        }
        int start = (int)((float)links.size() * this.currentScroll);
        int finish = Math.min(start + 4, links.size());
        for (int i = start; i < finish; ++i) {
            if (links.get(i) == null || this.entity.linkID != links.get((int)i).networkID) continue;
            return i - start;
        }
        return -1;
    }

    protected void func_146976_a(float var1, int var2, int var3) {
        super.func_146976_a(var1, var2, var3);
        int pos = this.getLinkPosition();
        for (int i = 0; i < 4; ++i) {
            this.func_73729_b(this.field_147003_i + 86, this.field_147009_r + 19 + 12 - 26 + 12 * i, 0, i == pos ? 178 : 166, 154, 12);
        }
        this.func_73729_b(this.scrollerLeft, this.scrollerStart + (int)((float)(this.scrollerEnd - this.scrollerStart - 17) * this.currentScroll), 176, 0, 10, 15);
        if (this.entity.passwordMatch) {
            this.func_73729_b(this.field_147003_i + 162, this.field_147009_r + 65, 176, 15, 9, 14);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public class NetworkButton
    extends SonarButtons.ImageButton {
        public NetworkButton(int id, int x, int y) {
            super(id, x, y, network, 0, 190, 72, 11);
        }
    }
}

