/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.common.block.generators;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import sonar.calculator.mod.Calculator;
import sonar.calculator.mod.common.tileentity.generators.TileEntityConductorMast;
import sonar.core.api.utils.BlockInteraction;
import sonar.core.common.block.SonarBlock;
import sonar.core.common.block.SonarMaterials;
import sonar.core.helpers.SonarHelper;

public class InvisibleBlock
extends SonarBlock {
    public int type;

    public InvisibleBlock(int type) {
        super(SonarMaterials.machine, false, true);
        this.type = type;
        if (type == 2) {
            // empty if block
        }
        if (type == 0) {
            // empty if block
        }
    }

    public boolean operateBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, BlockInteraction interact) {
        if (player != null && !world.field_72995_K && this.type == 0) {
            for (int i = 1; i < 4; ++i) {
                BlockPos offset = pos.func_177967_a(EnumFacing.DOWN, i);
                if (world.func_180495_p(offset).func_177230_c() != Calculator.conductorMast) continue;
                player.openGui((Object)Calculator.instance, -2, world, offset.func_177958_n(), offset.func_177956_o(), offset.func_177952_p());
                break;
            }
        }
        return true;
    }

    public final boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        BlockPos offset;
        IBlockState transmitter;
        Block block;
        if (this.type == 0) {
            if (world.func_180495_p(pos.func_177967_a(EnumFacing.DOWN, 1)).func_177230_c() == Calculator.conductorMast) {
                TileEntityConductorMast mast = (TileEntityConductorMast)world.func_175625_s(pos.func_177967_a(EnumFacing.DOWN, 1));
                SonarHelper.dropTile((EntityPlayer)player, (Block)world.func_180495_p(pos.func_177967_a(EnumFacing.DOWN, 1)).func_177230_c(), (World)world, (BlockPos)pos.func_177967_a(EnumFacing.DOWN, 1));
            } else if (world.func_180495_p(pos.func_177967_a(EnumFacing.DOWN, 2)).func_177230_c() == Calculator.conductorMast) {
                TileEntityConductorMast mast = (TileEntityConductorMast)world.func_175625_s(pos.func_177967_a(EnumFacing.DOWN, 2));
                SonarHelper.dropTile((EntityPlayer)player, (Block)world.func_180495_p(pos.func_177967_a(EnumFacing.DOWN, 2)).func_177230_c(), (World)world, (BlockPos)pos.func_177967_a(EnumFacing.DOWN, 2));
            } else if (world.func_180495_p(pos.func_177967_a(EnumFacing.DOWN, 3)).func_177230_c() == Calculator.conductorMast) {
                TileEntityConductorMast mast = (TileEntityConductorMast)world.func_175625_s(pos.func_177967_a(EnumFacing.DOWN, 3));
                SonarHelper.dropTile((EntityPlayer)player, (Block)world.func_180495_p(pos.func_177967_a(EnumFacing.DOWN, 3)).func_177230_c(), (World)world, (BlockPos)pos.func_177967_a(EnumFacing.DOWN, 3));
            }
        } else if (this.type == 1) {
            for (int X = -1; X < 2; ++X) {
                for (int Z = -1; Z < 2; ++Z) {
                    IBlockState station = world.func_180495_p(pos.func_177982_a(X, -1, Z));
                    if (station.func_177230_c() != Calculator.weatherStation) continue;
                    TileEntity i = world.func_175625_s(pos.func_177982_a(X, -1, Z));
                    Block bi = world.func_180495_p(pos.func_177982_a(X, -1, Z)).func_177230_c();
                    bi.func_176226_b(world, pos.func_177982_a(X, -1, Z), state, 0);
                    world.func_175698_g(pos.func_177982_a(X, -1, Z));
                }
            }
        } else if (this.type == 2 && (block = (transmitter = world.func_180495_p(offset = pos.func_177972_a(EnumFacing.DOWN))).func_177230_c()) == Calculator.transmitter) {
            block.func_176226_b(world, offset, state, 0);
            world.func_175698_g(offset);
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        if (this.type == 0) {
            TileEntityConductorMast.setWeatherStationAngles(true, world, pos);
        }
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        switch (this.type) {
            case 0: {
                return new ItemStack(Calculator.conductorMast, 1);
            }
            case 1: {
                return new ItemStack(Calculator.weatherStation, 1);
            }
            case 2: {
                return new ItemStack(Calculator.transmitter, 1);
            }
        }
        return super.getPickBlock(state, target, world, pos, player);
    }

    public int func_149745_a(Random rand) {
        return 0;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149721_r(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.INVISIBLE;
    }

    public boolean dropStandard(IBlockAccess world, BlockPos pos) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public IBlockState getStateForEntityRender(IBlockState state) {
        return this.func_176223_P();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P();
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[0]);
    }
}

