/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.common.item.calculators;

import cofh.api.energy.IEnergyContainerItem;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import sonar.calculator.mod.api.modules.IModule;
import sonar.calculator.mod.common.item.calculators.SonarModule;
import sonar.core.api.energy.ISonarEnergyItem;
import sonar.core.api.utils.ActionType;
import sonar.core.helpers.FontHelper;

public class SonarUsageModule
extends SonarModule
implements ISonarEnergyItem,
IEnergyContainerItem {
    public int storage;

    public SonarUsageModule(IModule module, int storage) {
        super(module);
        this.storage = storage;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        list.add(FontHelper.translate((String)"energy.stored") + ": " + this.getEnergyLevel(stack) + " RF");
        super.func_77624_a(stack, player, list, par4);
    }

    public long addEnergy(ItemStack stack, long maxReceive, ActionType action) {
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        long energy = stack.func_77978_p().func_74763_f("Energy");
        long energyReceived = Math.min((long)this.getMaxEnergyStored(stack) - energy, Math.min((long)(this.storage / 10), maxReceive));
        if (!action.shouldSimulate()) {
            stack.func_77978_p().func_74772_a("Energy", energy += energyReceived);
        }
        return energyReceived;
    }

    public long removeEnergy(ItemStack stack, long maxExtract, ActionType action) {
        if (stack.func_77978_p() == null || !stack.func_77978_p().func_74764_b("Energy")) {
            return 0L;
        }
        long energy = stack.func_77978_p().func_74763_f("Energy");
        long energyExtracted = Math.min(energy, Math.min((long)(this.storage / 10), maxExtract));
        if (!action.shouldSimulate()) {
            stack.func_77978_p().func_74772_a("Energy", energy -= energyExtracted);
        }
        return energyExtracted;
    }

    public long getEnergyLevel(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return 0L;
        }
        return stack.func_77978_p().func_74763_f("Energy");
    }

    public long getFullCapacity(ItemStack stack) {
        return this.storage;
    }

    public int receiveEnergy(ItemStack stack, int maxReceive, boolean simulate) {
        return (int)this.addEnergy(stack, maxReceive, ActionType.getTypeForAction((boolean)simulate));
    }

    public int extractEnergy(ItemStack stack, int maxExtract, boolean simulate) {
        return (int)this.removeEnergy(stack, maxExtract, ActionType.getTypeForAction((boolean)simulate));
    }

    public int getEnergyStored(ItemStack stack) {
        return (int)this.getEnergyLevel(stack);
    }

    public int getMaxEnergyStored(ItemStack stack) {
        return (int)this.getFullCapacity(stack);
    }

    @Override
    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged || newStack.func_77973_b() != oldStack.func_77973_b() || newStack.func_77952_i() != oldStack.func_77952_i();
    }
}

