/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.common.item.modules;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import sonar.core.common.item.SonarEnergyItem;
import sonar.core.helpers.FontHelper;

public class BaseTerrainModule
extends SonarEnergyItem {
    public Block[] replacable;

    public BaseTerrainModule(int capacity, int maxReceive, int maxExtract) {
        super(capacity, maxReceive, maxExtract);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        super.func_77624_a(stack, player, list, par4);
        if (stack.func_77942_o()) {
            list.add(FontHelper.translate((String)"calc.mode") + ": " + this.currentBlockString(stack, player));
        }
    }

    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (player.field_71075_bZ.field_75098_d || this.getEnergyStored(stack) > 0) {
            if (!player.func_175151_a(pos, side, stack)) {
                return EnumActionResult.PASS;
            }
            if (player.func_70093_af()) {
                this.incrementMode(stack);
                FontHelper.sendMessage((String)this.currentBlockString(stack, player), (World)world, (EntityPlayer)player);
            } else if (this.canReplace(stack, world, pos)) {
                world.func_175656_a(pos, this.getCurrentBlock(stack).func_176203_a(stack.func_77960_j()));
                if (!player.field_71075_bZ.field_75098_d) {
                    int energy = this.getEnergyStored(stack);
                    stack.func_77978_p().func_74768_a("Energy", energy - 1);
                }
            }
        } else if (this.getEnergyStored(stack) == 0) {
            FontHelper.sendMessage((String)FontHelper.translate((String)"energy.noEnergy"), (World)world, (EntityPlayer)player);
        }
        return EnumActionResult.SUCCESS;
    }

    public String currentBlockString(ItemStack stack, EntityPlayer player) {
        return new ItemStack(this.getCurrentBlock(stack), 1).func_82833_r();
    }

    public Block getCurrentBlock(ItemStack stack) {
        return this.replacable[this.getCurrentMode(stack)];
    }

    public int getCurrentMode(ItemStack stack) {
        NBTTagCompound nbtData;
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if ((nbtData = stack.func_77978_p()) == null) {
            stack.func_77978_p().func_74768_a("Mode", 0);
        }
        return stack.func_77978_p().func_74762_e("Mode");
    }

    public void incrementMode(ItemStack stack) {
        int current = this.getCurrentMode(stack);
        if (current + 1 != this.replacable.length) {
            stack.func_77978_p().func_74768_a("Mode", current + 1);
        } else {
            stack.func_77978_p().func_74768_a("Mode", 0);
        }
    }

    public boolean canReplace(ItemStack stack, World world, BlockPos pos) {
        if (this.getCurrentBlock(stack) == world.func_180495_p(pos).func_177230_c()) {
            return false;
        }
        return this.replaceableBlock(world.func_180495_p(pos).func_177230_c());
    }

    public boolean replaceableBlock(Block block) {
        for (int s = 0; s < this.replacable.length; ++s) {
            if (this.replacable[s] == null || block != this.replacable[s]) continue;
            return true;
        }
        return false;
    }
}

