/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.common.recipes;

import gnu.trove.map.hash.THashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.oredict.OreDictionary;
import sonar.calculator.mod.Calculator;
import sonar.calculator.mod.CalculatorItems;
import sonar.calculator.mod.common.block.MaterialBlock;
import sonar.core.SonarCore;
import sonar.core.helpers.RecipeHelper;

public class RecipeRegistry {
    private static final Map<String, ArrayList<Object[]>> blocked = new THashMap();
    private static final List<Object[]> unblocked = new ArrayList<Object[]>();
    private static final List<Object[]> scientific = new ArrayList<Object[]>();
    private static final List<Object[]> atomic = new ArrayList<Object[]>();
    private static final List<Object[]> flawless = new ArrayList<Object[]>();
    private static final Map<String, List<Object[]>> machines = new THashMap();

    public static void clearRecipes() {
        blocked.clear();
        unblocked.clear();
        scientific.clear();
        atomic.clear();
        flawless.clear();
        machines.clear();
    }

    public static void registerRecipes() {
        RecipeRegistry.addStandardRecipes();
        RecipeRegistry.addScientificRecipes();
        RecipeRegistry.addAtomicRecipes();
        RecipeRegistry.addFlawlessRecipes();
    }

    public static void registerCalculatorRecipe(Object ... objects) {
        if (objects.length < 3) {
            Calculator.logger.warn("Calculator Recipes - Invalid Recipe Size!");
            return;
        }
        RecipeRegistry.rearrangeCalculatorRecipe(objects);
    }

    public static void registerScientificRecipe(Object ... objects) {
        if (objects.length != 3) {
            Calculator.logger.warn("Scientific Recipes - Invalid Recipe Size!");
            return;
        }
        scientific.add(objects);
    }

    public static void registerAtomicRecipe(Object ... objects) {
        if (objects.length != 4) {
            Calculator.logger.warn("Atomic Recipes - Invalid Recipe Size!");
            return;
        }
        atomic.add(objects);
    }

    public static void registerFlawlessRecipe(Object ... objects) {
        if (objects.length != 5) {
            FMLLog.warning((String)"Flawless Recipes - Invalid Recipe Size!", (Object[])new Object[0]);
            return;
        }
        flawless.add(objects);
    }

    private static void addStandardRecipes() {
        RecipeRegistry.registerCalculatorRecipe(Calculator.baby_grenade, Calculator.grenadecasing, Blocks.field_150335_W);
        RecipeRegistry.registerCalculatorRecipe(SonarCore.reinforcedStoneBlock, "cobblestone", "plankWood");
        RecipeRegistry.registerCalculatorRecipe(new ItemStack(SonarCore.reinforcedStoneBlock, 4), "cobblestone", "logWood");
        RecipeRegistry.registerCalculatorRecipe(Calculator.wrench, Calculator.reinforced_sword, Calculator.reinforced_pickaxe);
        RecipeRegistry.registerCalculatorRecipe(SonarCore.reinforcedDirtBlock, Blocks.field_150346_d, "plankWood");
        RecipeRegistry.registerCalculatorRecipe(new ItemStack(SonarCore.reinforcedDirtBlock, 4), Blocks.field_150346_d, "logWood");
        RecipeRegistry.registerCalculatorRecipe(new ItemStack(Calculator.enrichedGold, 4), "ingotGold", "dustRedstone");
        RecipeRegistry.registerCalculatorRecipe(Calculator.reinforcediron_ingot, "ingotIron", SonarCore.reinforcedStoneBlock);
        RecipeRegistry.registerCalculatorRecipe(Calculator.enriched_coal, Items.field_151044_h, "dustRedstone");
        RecipeRegistry.registerCalculatorRecipe(Calculator.broccoliSeeds, Items.field_151014_N, Items.field_151080_bb);
        RecipeRegistry.registerCalculatorRecipe(Calculator.sickle, Calculator.reinforced_shovel, Calculator.reinforced_axe);
        RecipeRegistry.registerCalculatorRecipe(Calculator.scarecrow, Blocks.field_150423_aK, Blocks.field_150407_cf);
        RecipeRegistry.registerCalculatorRecipe(Calculator.basic_lantern, Blocks.field_150478_aa, Calculator.reinforcediron_ingot);
        RecipeRegistry.registerCalculatorRecipe(Calculator.gas_lantern_off, Calculator.basic_lantern, Calculator.basic_lantern);
        RecipeRegistry.registerCalculatorRecipe(Calculator.prunaeSeeds, Calculator.enriched_coal, Items.field_151014_N);
        RecipeRegistry.registerCalculatorRecipe(Calculator.enriched_coal, Calculator.coal_dust, Calculator.coal_dust);
        RecipeRegistry.registerCalculatorRecipe(new ItemStack(SonarCore.reinforcedStoneBrick, 2), SonarCore.reinforcedStoneBlock, SonarCore.reinforcedStoneBlock);
        RecipeRegistry.registerCalculatorRecipe(new ItemStack(SonarCore.stableGlass, 2), "blockGlass", "blockGlass");
        RecipeRegistry.registerCalculatorRecipe(new ItemStack(SonarCore.stableStone[0], 2), SonarCore.reinforcedStoneBrick, SonarCore.reinforcedStoneBrick);
        RecipeRegistry.registerCalculatorRecipe(new ItemStack(SonarCore.reinforcedDirtBrick, 2), SonarCore.reinforcedDirtBlock, SonarCore.reinforcedDirtBlock);
        RecipeRegistry.registerCalculatorRecipe(Calculator.rainSensor, Blocks.field_150453_bW, Items.field_151133_ar);
    }

    private static void addScientificRecipes() {
        RecipeRegistry.registerScientificRecipe(Calculator.enriched_coal, Calculator.enrichedgold_ingot, Calculator.purified_coal);
        RecipeRegistry.registerScientificRecipe("ingotIron", "dustRedstone", Calculator.redstone_ingot);
        RecipeRegistry.registerScientificRecipe("gemDiamond", Calculator.reinforcediron_ingot, new ItemStack(Calculator.weakeneddiamond, 4));
        RecipeRegistry.registerScientificRecipe(Calculator.baby_grenade, Calculator.baby_grenade, Calculator.grenade);
        RecipeRegistry.registerScientificRecipe(Calculator.enriched_coal, Items.field_151129_at, Calculator.firecoal);
        RecipeRegistry.registerScientificRecipe(Calculator.large_amethyst, "treeSapling", Calculator.amethystSapling);
        RecipeRegistry.registerScientificRecipe(Calculator.amethystLog, Calculator.amethystLeaves, Calculator.amethystSapling);
        RecipeRegistry.registerScientificRecipe(Calculator.amethystLog, Calculator.small_amethyst, Calculator.amethystSapling);
        RecipeRegistry.registerScientificRecipe(Calculator.amethystLog, Calculator.amethystLog, Calculator.amethystSapling);
        RecipeRegistry.registerScientificRecipe(Calculator.itemCalculator, Calculator.redstone_ingot, Calculator.itemTerrainModule);
        RecipeRegistry.registerScientificRecipe(Calculator.itemEnergyModule, Calculator.small_amethyst, Calculator.starchextractor);
        RecipeRegistry.registerScientificRecipe(Calculator.powerCube, Calculator.purified_coal, Calculator.itemEnergyModule);
    }

    private static void addAtomicRecipes() {
        RecipeRegistry.registerAtomicRecipe("ingotIron", "dustRedstone", "ingotIron", Calculator.itemScientificCalculator);
        RecipeRegistry.registerAtomicRecipe("gemDiamond", Calculator.atomic_binder, "gemDiamond", Calculator.flawlessdiamond);
        RecipeRegistry.registerAtomicRecipe("gemDiamond", Items.field_151072_bj, "gemDiamond", Calculator.firediamond);
        RecipeRegistry.registerAtomicRecipe(Items.field_151072_bj, Calculator.flawlessdiamond, Items.field_151072_bj, Calculator.firediamond);
        RecipeRegistry.registerAtomicRecipe(Blocks.field_150377_bs, Calculator.electricDiamond, Blocks.field_150343_Z, Calculator.endDiamond);
        RecipeRegistry.registerAtomicRecipe(Calculator.amethystSapling, Blocks.field_150377_bs, Calculator.tanzaniteSapling, Calculator.pearSapling);
        RecipeRegistry.registerAtomicRecipe(Calculator.itemScientificCalculator, Calculator.atomic_binder, Calculator.redstone_ingot, Calculator.itemAdvancedTerrainModule);
        RecipeRegistry.registerAtomicRecipe(Calculator.tanzaniteLog, Calculator.atomic_binder, Calculator.tanzaniteLeaves, Calculator.tanzaniteSapling);
        RecipeRegistry.registerAtomicRecipe(Calculator.large_tanzanite, Calculator.atomic_binder, "treeSapling", Calculator.tanzaniteSapling);
        RecipeRegistry.registerAtomicRecipe(Calculator.healthProcessor, Calculator.itemEnergyModule, Calculator.hungerProcessor, Calculator.itemNutritionModule);
        RecipeRegistry.registerAtomicRecipe(new ItemStack(Calculator.circuitBoard, 1, 4), Calculator.atomic_binder, "dustEnrichedGold", new ItemStack(Calculator.speedUpgrade, 4));
        RecipeRegistry.registerAtomicRecipe(new ItemStack(Calculator.circuitBoard, 1, 5), Calculator.atomic_binder, "dustEnrichedGold", new ItemStack(Calculator.energyUpgrade, 4));
        RecipeRegistry.registerAtomicRecipe(new ItemStack(Calculator.circuitBoard, 1, 6), Calculator.atomic_binder, "dustEnrichedGold", Calculator.voidUpgrade);
        RecipeRegistry.registerAtomicRecipe(new ItemStack(Calculator.circuitBoard, 1, 7), Calculator.atomic_binder, "dustEnrichedGold", Calculator.transferUpgrade);
        RecipeRegistry.registerAtomicRecipe(new ItemStack(Calculator.circuitBoard, 1, 9), Calculator.redstoneextractor, Calculator.large_tanzanite, Calculator.glowstoneextractor);
        RecipeRegistry.registerAtomicRecipe(Calculator.redstone_ingot, Calculator.starchextractor, Calculator.redstone_ingot, Calculator.redstoneextractor);
        RecipeRegistry.registerAtomicRecipe(Calculator.itemEnergyModule, Calculator.firediamond, Calculator.itemEnergyModule, Calculator.conductorMast);
        RecipeRegistry.registerAtomicRecipe(new ItemStack(Calculator.material_block, 1, MaterialBlock.Variants.REINFORCED_IRON.getMeta()), Calculator.reinforcedChest, new ItemStack(Calculator.material_block, 1, MaterialBlock.Variants.REINFORCED_IRON.getMeta()), Calculator.storageChamber);
        RecipeRegistry.registerAtomicRecipe(Calculator.reassemblyChamber, Calculator.flawlessdiamond, Calculator.restorationChamber, Calculator.processingChamber);
        RecipeRegistry.registerAtomicRecipe(Calculator.reinforcediron_ingot, Blocks.field_150486_ae, Calculator.reinforcediron_ingot, Calculator.itemStorageModule);
        RecipeRegistry.registerAtomicRecipe(Calculator.reinforcediron_ingot, Calculator.electricDiamond, Calculator.reinforcediron_ingot, Calculator.transmitter);
        RecipeRegistry.registerAtomicRecipe(Calculator.reinforcediron_ingot, Calculator.firediamond, Calculator.reinforcediron_ingot, new ItemStack(Calculator.weatherStation, 4));
    }

    private static void addFlawlessRecipes() {
        RecipeRegistry.registerFlawlessRecipe(Calculator.pearSapling, Calculator.endDiamond, Calculator.endDiamond, Blocks.field_150377_bs, Calculator.diamondSapling);
        RecipeRegistry.registerFlawlessRecipe("ingotGold", "ingotGold", "ingotGold", "ingotGold", Items.field_151045_i);
        RecipeRegistry.registerFlawlessRecipe("gemDiamond", "gemDiamond", "gemDiamond", "gemDiamond", Items.field_151166_bC);
        RecipeRegistry.registerFlawlessRecipe("ingotIron", "ingotIron", "ingotIron", "ingotIron", Items.field_151079_bi);
        RecipeRegistry.registerFlawlessRecipe("logWood", "logWood", "logWood", "logWood", Blocks.field_150343_Z);
        RecipeRegistry.registerFlawlessRecipe(Blocks.field_150343_Z, Blocks.field_150343_Z, Blocks.field_150343_Z, Blocks.field_150343_Z, Calculator.purifiedObsidian);
        RecipeRegistry.registerFlawlessRecipe(Calculator.broccoli, Calculator.broccoli, Calculator.broccoli, Calculator.broccoli, Calculator.fiddledewFruit);
        RecipeRegistry.registerFlawlessRecipe(Calculator.itemEnergyModule, Calculator.itemCalculator, Calculator.itemCalculator, Calculator.itemEnergyModule, Calculator.itemLocatorModule);
        RecipeRegistry.registerFlawlessRecipe(Calculator.flawlessdiamond, "blockGlass", "blockGlass", Calculator.flawlessdiamond, new ItemStack(Calculator.flawlessGlass, 4));
        RecipeRegistry.registerFlawlessRecipe(Calculator.circuitBoard, Calculator.enriched_coal, Calculator.enriched_coal, Calculator.circuitBoard, new ItemStack(Calculator.controlled_Fuel, 4));
        RecipeRegistry.registerFlawlessRecipe(Calculator.gas_lantern_off, new ItemStack(Calculator.circuitBoard, 1, 8), new ItemStack(Calculator.circuitBoard, 1, 8), Calculator.gas_lantern_off, Calculator.CO2Generator);
        RecipeRegistry.registerFlawlessRecipe(Items.field_151065_br, Items.field_151065_br, Items.field_151065_br, Items.field_151065_br, Items.field_151072_bj);
        RecipeRegistry.registerFlawlessRecipe(Items.field_151072_bj, Items.field_151072_bj, Items.field_151072_bj, Items.field_151072_bj, Items.field_151073_bk);
    }

    private static void rearrangeCalculatorRecipe(Object ... objects) {
        if (objects.length == 4 && objects[3] != null && objects[3] instanceof RecipeType) {
            String recipeID = (String)objects[3];
            Object[] recipe = new Object[]{objects[1], objects[2], objects[0]};
            blocked.putIfAbsent(recipeID, new ArrayList());
            blocked.get(recipeID).add(recipe);
        } else {
            Object[] recipe = new Object[]{objects[1], objects[2], objects[0]};
            unblocked.add(recipe);
        }
    }

    public static int getBlockedSize() {
        return blocked.size();
    }

    public static int getUnblockedSize() {
        return unblocked.size();
    }

    public static int getScientificSize() {
        return scientific.size();
    }

    public static int getAtomicSize() {
        return atomic.size();
    }

    public static int getFlawlessSize() {
        return flawless.size();
    }

    public static class ConductorMastPowerRecipes
    extends RecipeHelper {
        private static final ConductorMastPowerRecipes INSTANCE = new ConductorMastPowerRecipes();

        public static ConductorMastPowerRecipes instance() {
            return INSTANCE;
        }

        ConductorMastPowerRecipes() {
            super(1, 1, true);
        }

        public void addRecipes() {
            this.addRecipe(new Object[]{new ItemStack(Calculator.electricDiamond), 10000});
            this.addRecipe(new Object[]{new ItemStack(Calculator.itemScientificCalculator), 2000});
            this.addRecipe(new Object[]{new ItemStack(Calculator.material_block, 1, CalculatorItems.ToolTypes.ElectricDiamond.getMeta()), 90000});
        }

        public int getPowercost(ItemStack input) {
            Object[] output = this.getOutputRaw(new ItemStack[]{input});
            if (output == null) {
                return 0;
            }
            return (Integer)output[0];
        }

        public String getRecipeID() {
            return "ConductorMastPower";
        }
    }

    public static class ConductorMastItemRecipes
    extends RecipeHelper {
        private static final ConductorMastItemRecipes INSTANCE = new ConductorMastItemRecipes();

        public static ConductorMastItemRecipes instance() {
            return INSTANCE;
        }

        public ConductorMastItemRecipes() {
            super(1, 1, true);
        }

        public void addRecipes() {
            this.addRecipe(new Object[]{Calculator.firediamond, new ItemStack(Calculator.electricDiamond)});
            this.addRecipe(new Object[]{Calculator.itemCalculator, new ItemStack(Calculator.itemScientificCalculator)});
            this.addRecipe(new Object[]{new ItemStack(Calculator.material_block, 1, MaterialBlock.Variants.FIRE_DIAMOND.getMeta()), new ItemStack(Calculator.material_block, 1, MaterialBlock.Variants.ELECTRIC_DIAMOND.getMeta())});
        }

        public Map<ItemStack, ItemStack> getRecipeStacks() {
            HashMap<ItemStack, ItemStack> map = new HashMap<ItemStack, ItemStack>();
            for (Map.Entry entry : this.recipeList.entrySet()) {
                map.put((ItemStack)((Object[])entry.getKey())[0], (ItemStack)((Object[])entry.getValue())[0]);
            }
            return map;
        }

        public String getRecipeID() {
            return "ConductorMastItem";
        }
    }

    public static class FlawlessRecipes
    extends RecipeHelper {
        private static final FlawlessRecipes recipes = new FlawlessRecipes();

        public static final RecipeHelper instance() {
            return recipes;
        }

        public FlawlessRecipes() {
            super(4, 1, true);
        }

        public void addRecipes() {
            for (int i = 0; i < flawless.size(); ++i) {
                this.addRecipe((Object[])flawless.get(i));
            }
        }

        public String getRecipeID() {
            return "Flawless";
        }
    }

    public static class AtomicRecipes
    extends RecipeHelper {
        private static final AtomicRecipes recipes = new AtomicRecipes();

        public static final RecipeHelper instance() {
            return recipes;
        }

        public AtomicRecipes() {
            super(3, 1, true);
        }

        public void addRecipes() {
            for (int i = 0; i < atomic.size(); ++i) {
                this.addRecipe((Object[])atomic.get(i));
            }
        }

        public String getRecipeID() {
            return "Atomic";
        }
    }

    public static class ScientificRecipes
    extends RecipeHelper {
        private static final ScientificRecipes recipes = new ScientificRecipes();

        public static final RecipeHelper instance() {
            return recipes;
        }

        public ScientificRecipes() {
            super(2, 1, true);
        }

        public void addRecipes() {
            for (int i = 0; i < scientific.size(); ++i) {
                this.addRecipe((Object[])scientific.get(i));
            }
        }

        public String getRecipeID() {
            return "Scientific";
        }
    }

    public static class CalculatorRecipes
    extends RecipeHelper {
        private static final CalculatorRecipes recipes = new CalculatorRecipes();
        public int currentRecipe = 0;

        public static final CalculatorRecipes instance() {
            return recipes;
        }

        public CalculatorRecipes() {
            super(2, 1, true);
        }

        public void addRecipes() {
            for (int i = 0; i < unblocked.size(); ++i) {
                this.addRecipe((Object[])unblocked.get(i));
            }
        }

        public String getRecipeID() {
            return "Calculator";
        }
    }

    public static enum RecipeType {
        REINFORCED_STONE(SonarCore.reinforcedStoneBlock, SonarCore.reinforcedDirtBlock, "reinforcedStone"),
        CROP(Items.field_151015_O, Items.field_151174_bG, Items.field_151172_bF, "cropWheat", "cropPotato", "cropCarrot"),
        SLIMEBALL(Items.field_151123_aH, "slimeball"),
        IRON(Blocks.field_150366_p, Items.field_151042_j, "oreIron", "blockIron", "ingotIron"),
        EMERALD("oreEmerald", "blockEmerald", "gemEmerald"),
        FLOWER(Blocks.field_150328_O, Blocks.field_150327_N),
        CACTUS(Blocks.field_150434_aF),
        NETHER(Blocks.field_150343_Z, Blocks.field_150424_aL, Blocks.field_150425_aM),
        END(Blocks.field_150377_bs, Items.field_151079_bi),
        SAND(Blocks.field_150354_m, "sand"),
        GRASS(Blocks.field_150349_c, "grass"),
        SANDSTONE(Blocks.field_150322_A, Blocks.field_150372_bz),
        DIRT(Blocks.field_150346_d, "dirt"),
        STONE(Blocks.field_150348_b, "stone"),
        GRAVEL(Blocks.field_150351_n, "gravel"),
        COBBLESTONE(Blocks.field_150347_e, "cobblestone"),
        WOOD(Blocks.field_150364_r, Blocks.field_150363_s, "logWood"),
        PLANKS(Blocks.field_150344_f, "plankWood", "stairWood"),
        LEAVES(Blocks.field_150362_t, Blocks.field_150361_u, "calculatorLeaves"),
        SAPLING(Blocks.field_150345_g, "treeSapling"),
        GLASS(Blocks.field_150359_w, "blockGlass"),
        GLASS_PANE(Blocks.field_150410_aZ, "paneGlass"),
        FURNACE(Blocks.field_150460_al),
        DYE(Items.field_151100_aR, "dye"),
        CARPET(Blocks.field_150404_cg, "carpet"),
        CLAY_BLOCK(Items.field_151119_aD, Blocks.field_150435_aG, Blocks.field_150405_ch, "clay"),
        FOLIAGE(Blocks.field_150398_cm, Blocks.field_150330_I, Blocks.field_150395_bd, Blocks.field_150392_bi),
        WOOL(Blocks.field_150325_L, "wool");

        public Object[] items;

        private RecipeType(Object ... items) {
            this.items = items;
        }

        public static ArrayList<RecipeType> getUnlocked(ItemStack stack) {
            ArrayList<RecipeType> unlocked = new ArrayList<RecipeType>();
            int[] ids = OreDictionary.getOreIDs((ItemStack)stack);
            block0: for (RecipeType type : RecipeType.values()) {
                block1: for (Object object : type.items) {
                    if (stack.func_77973_b() == object || Block.func_149634_a((Item)stack.func_77973_b()) == object) {
                        unlocked.add(type);
                        continue block0;
                    }
                    if (!(object instanceof String)) continue;
                    int oreID = OreDictionary.getOreID((String)((String)object));
                    for (int id : ids) {
                        if (id != oreID) continue;
                        unlocked.add(type);
                        continue block1;
                    }
                }
            }
            return unlocked;
        }
    }
}

