/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.common.tileentity;

import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import sonar.calculator.mod.common.tileentity.TileEntityMachine;
import sonar.core.SonarCore;
import sonar.core.api.SonarAPI;
import sonar.core.api.machines.IPausable;
import sonar.core.api.machines.IProcessMachine;
import sonar.core.api.upgrades.IUpgradableTile;
import sonar.core.common.tileentity.TileEntityEnergySidedInventory;
import sonar.core.helpers.FontHelper;
import sonar.core.helpers.NBTHelper;
import sonar.core.helpers.SonarHelper;
import sonar.core.inventory.IAdditionalInventory;
import sonar.core.network.sync.SyncTagType;
import sonar.core.network.utils.IByteBufTile;
import sonar.core.upgrades.UpgradeInventory;
import sonar.core.utils.MachineSideConfig;

public abstract class TileEntityProcess
extends TileEntityEnergySidedInventory
implements IUpgradableTile,
IPausable,
IAdditionalInventory,
IProcessMachine,
IByteBufTile {
    public float renderTicks;
    public double energyBuffer;
    public SyncTagType.BOOLEAN invertPaused = new SyncTagType.BOOLEAN(0);
    public SyncTagType.BOOLEAN paused = new SyncTagType.BOOLEAN(1);
    public SyncTagType.INT cookTime = (SyncTagType.INT)new SyncTagType.INT(2).removeSyncType(new NBTHelper.SyncType[]{NBTHelper.SyncType.DEFAULT_SYNC});
    public UpgradeInventory upgrades = new UpgradeInventory(16, new Object[]{"ENERGY", "SPEED", "TRANSFER"}).addMaxiumum("TRANSFER", 1);
    public boolean isActive = false;
    public static int lowestSpeed = 4;
    public static int lowestEnergy = 1000;
    public int currentSpeed;

    public TileEntityProcess() {
        this.syncParts.addAll(Lists.newArrayList((Object[])new SyncTagType[]{this.paused, this.invertPaused, this.cookTime}));
    }

    public abstract boolean canProcess();

    public abstract void finishProcess();

    public void func_73660_a() {
        super.func_73660_a();
        if (this.isServer()) {
            if (this.upgrades.getUpgradesInstalled("TRANSFER") > 0) {
                this.transferItems();
            }
            if (!this.isPaused()) {
                boolean forceUpdate = false;
                if (this.canProcess()) {
                    if ((Integer)this.cookTime.getObject() >= this.getProcessTime()) {
                        this.finishProcess();
                        this.cookTime.setObject((Object)0);
                        this.energyBuffer = 0.0;
                        forceUpdate = true;
                    } else if ((Integer)this.cookTime.getObject() > 0) {
                        this.cookTime.increaseBy(1);
                        this.modifyEnergy();
                    } else if ((Integer)this.cookTime.getObject() == 0) {
                        this.cookTime.increaseBy(1);
                        this.modifyEnergy();
                        forceUpdate = true;
                    }
                } else {
                    this.renderTicks = 0.0f;
                    if ((Integer)this.cookTime.getObject() != 0) {
                        this.cookTime.setObject((Object)0);
                        this.energyBuffer = 0.0;
                        SonarCore.sendPacketAround((TileEntity)this, (int)128, (int)2);
                        forceUpdate = true;
                    }
                }
                if (forceUpdate) {
                    this.isActive = this.isActive();
                    SonarCore.sendPacketAround((TileEntity)this, (int)128, (int)2);
                    this.field_145850_b.func_175641_c(this.field_174879_c, this.func_145838_q(), 1, 1);
                }
            }
        } else if (!this.isPaused()) {
            if (this.canProcess()) {
                this.renderTicks();
                this.cookTime.increaseBy(1);
            } else if ((Integer)this.cookTime.getObject() != 0) {
                this.renderTicks = 0.0f;
                this.cookTime.setObject((Object)0);
            }
        }
        this.func_70296_d();
    }

    public void transferItems() {
        ArrayList outputs = this.sides.getSidesWithConfig(MachineSideConfig.OUTPUT);
        for (EnumFacing side : outputs) {
            SonarAPI.getItemHelper().transferItems((TileEntity)this, SonarHelper.getAdjacentTileEntity((TileEntity)this, (EnumFacing)side), side, side.func_176734_d(), null);
        }
    }

    public void onFirstTick() {
        super.onFirstTick();
        if (!this.field_145850_b.field_72995_K) {
            this.isActive = this.isActive();
            SonarCore.sendPacketAround((TileEntity)this, (int)128, (int)2);
            this.field_145850_b.func_175641_c(this.field_174879_c, this.func_145838_q(), 1, 1);
        }
    }

    public void modifyEnergy() {
        this.energyBuffer += this.getEnergyUsage();
        int energyUsage = (int)Math.round(this.energyBuffer);
        this.energyBuffer = this.energyBuffer - (double)energyUsage < 0.0 ? 0.0 : (this.energyBuffer -= (double)energyUsage);
        this.storage.modifyEnergyStored(-energyUsage);
    }

    public void renderTicks() {
        this.renderTicks = this instanceof TileEntityMachine.PrecisionChamber || this instanceof TileEntityMachine.ExtractionChamber ? (this.renderTicks += (float)Math.max(1, this.upgrades.getUpgradesInstalled("SPEED")) / 50.0f) : (this.renderTicks += (float)Math.max(1, this.upgrades.getUpgradesInstalled("SPEED") * 8) / 1000.0f);
        if (this.renderTicks >= 2.0f) {
            this.renderTicks = 0.0f;
        }
    }

    public float getRenderPosition() {
        return this.renderTicks < 1.0f ? this.renderTicks : 1.0f - (this.renderTicks - 1.0f);
    }

    private int roundNumber(double i) {
        return (int)(Math.ceil(i / 10.0) * 10.0);
    }

    public int requiredEnergy() {
        int speed = this.upgrades.getUpgradesInstalled("SPEED");
        int energy = this.upgrades.getUpgradesInstalled("ENERGY");
        float i = (float)((double)speed / 17.0) * (float)this.getBaseEnergyUsage();
        float e = (float)((double)energy / 17.0) * (float)this.getBaseEnergyUsage();
        return (int)((float)this.getBaseEnergyUsage() + i - e);
    }

    public boolean func_145842_c(int action, int param) {
        if (action == 1) {
            this.markBlockForUpdate();
        }
        return true;
    }

    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.readData(nbt, type);
        if (type.isType(new NBTHelper.SyncType[]{NBTHelper.SyncType.DEFAULT_SYNC, NBTHelper.SyncType.SAVE})) {
            if (type.isType(new NBTHelper.SyncType[]{NBTHelper.SyncType.DEFAULT_SYNC})) {
                this.currentSpeed = nbt.func_74762_e("speed");
            }
            this.upgrades.readData(nbt, type);
        }
    }

    public NBTTagCompound writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        if (this.isServer() && this.forceSync) {
            SonarCore.sendPacketAround((TileEntity)this, (int)128, (int)2);
        }
        super.writeData(nbt, type);
        if (type.isType(new NBTHelper.SyncType[]{NBTHelper.SyncType.DEFAULT_SYNC, NBTHelper.SyncType.SAVE})) {
            if (type.isType(new NBTHelper.SyncType[]{NBTHelper.SyncType.DEFAULT_SYNC})) {
                nbt.func_74768_a("speed", this.getProcessTime());
            }
            this.upgrades.writeData(nbt, type);
        }
        return nbt;
    }

    public UpgradeInventory getUpgradeInventory() {
        return this.upgrades;
    }

    public boolean isActive() {
        if (this.field_145850_b.field_72995_K) {
            return this.isActive;
        }
        return !this.isPaused() && (Integer)this.cookTime.getObject() > 0;
    }

    public void onPause() {
        this.markBlockForUpdate();
        this.field_145850_b.func_175641_c(this.field_174879_c, this.field_145854_h, 1, 1);
    }

    public boolean isPaused() {
        return (Boolean)this.invertPaused.getObject();
    }

    public boolean canStack(ItemStack current, ItemStack stack) {
        if (current == null) {
            return true;
        }
        return current.field_77994_a != current.func_77976_d();
    }

    @SideOnly(value=Side.CLIENT)
    public List<String> getWailaInfo(List<String> currenttip, IBlockState state) {
        int speed = this.upgrades.getUpgradesInstalled("SPEED");
        int energy = this.upgrades.getUpgradesInstalled("ENERGY");
        if (speed != 0) {
            currenttip.add(FontHelper.translate((String)"circuit.speed") + ": " + speed);
        }
        if (energy != 0) {
            currenttip.add(FontHelper.translate((String)"circuit.energy") + ": " + energy);
        }
        return currenttip;
    }

    public ItemStack[] getAdditionalStacks() {
        ArrayList drops = this.upgrades.getDrops();
        if (drops == null || drops.isEmpty()) {
            return new ItemStack[]{null};
        }
        ItemStack[] toDrop = new ItemStack[drops.size()];
        int pos = 0;
        for (ItemStack drop : drops) {
            if (drop != null) {
                toDrop[pos] = drop;
            }
            ++pos;
        }
        return toDrop;
    }

    public abstract int getBaseEnergyUsage();

    public int getCurrentProcessTime() {
        return (Integer)this.cookTime.getObject();
    }

    public int getProcessTime() {
        int speed = this.upgrades.getUpgradesInstalled("SPEED");
        int energy = this.upgrades.getUpgradesInstalled("ENERGY");
        double i = (double)speed / 17.0 * (double)this.getBaseProcessTime();
        if (speed == 16) {
            return 8;
        }
        return (int)Math.max((double)this.getBaseProcessTime() - i, (double)lowestSpeed);
    }

    public double getEnergyUsage() {
        return (double)this.requiredEnergy() / (double)this.getProcessTime();
    }

    public void writePacket(ByteBuf buf, int id) {
        if (id == 0) {
            // empty if block
        }
        if (id == 1) {
            this.invertPaused.invert();
            this.invertPaused.writeToBuf(buf);
        }
        if (id == 2) {
            this.invertPaused.writeToBuf(buf);
            this.paused.writeToBuf(buf);
            this.cookTime.writeToBuf(buf);
            buf.writeBoolean(this.isActive());
        }
    }

    public void readPacket(ByteBuf buf, int id) {
        if (id == 0) {
            ItemStack[] upgrades = this.getAdditionalStacks();
            Random rand = new Random();
            for (ItemStack stack : upgrades) {
                if (stack == null) continue;
                float f = rand.nextFloat() * 0.8f + 0.1f;
                float f1 = rand.nextFloat() * 0.8f + 0.1f;
                float f2 = rand.nextFloat() * 0.8f + 0.1f;
                EntityItem dropStack = new EntityItem(this.func_145831_w(), (double)((float)this.field_174879_c.func_177958_n() + f), (double)((float)this.field_174879_c.func_177956_o() + f1), (double)((float)this.field_174879_c.func_177952_p() + f2), stack);
                this.func_145831_w().func_72838_d((Entity)dropStack);
            }
        }
        if (id == 1) {
            this.invertPaused.readFromBuf(buf);
        }
        if (id == 2) {
            this.invertPaused.readFromBuf(buf);
            this.paused.readFromBuf(buf);
            this.cookTime.readFromBuf(buf);
            this.isActive = buf.readBoolean();
        }
    }
}

