/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.common.tileentity.generators;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import sonar.calculator.mod.Calculator;
import sonar.calculator.mod.client.gui.generators.GuiCrankedGenerator;
import sonar.calculator.mod.common.containers.ContainerCrankedGenerator;
import sonar.calculator.mod.common.tileentity.generators.TileEntityCrankHandle;
import sonar.core.api.energy.EnergyMode;
import sonar.core.common.tileentity.TileEntityEnergy;
import sonar.core.helpers.FontHelper;
import sonar.core.helpers.NBTHelper;
import sonar.core.utils.IGuiTile;

public class TileEntityCrankedGenerator
extends TileEntityEnergy
implements IGuiTile {
    public boolean cranked;
    public int ticks;
    public int ticksforpower = 2;

    public TileEntityCrankedGenerator() {
        this.storage.setCapacity(1000).setMaxTransfer(200);
        this.maxTransfer = 32;
        this.energyMode = EnergyMode.SEND;
    }

    public void func_73660_a() {
        super.func_73660_a();
        if (this.cranked()) {
            TileEntityCrankHandle crank = (TileEntityCrankHandle)this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(EnumFacing.UP));
            if (crank.angle > 0) {
                if (this.ticks == 0) {
                    this.storage.modifyEnergyStored(8);
                }
                ++this.ticks;
                if (this.ticks == this.ticksforpower) {
                    this.ticks = 0;
                }
            }
        }
        this.addEnergy(EnumFacing.field_82609_l);
    }

    public boolean cranked() {
        Block crank = this.field_145850_b.func_180495_p(this.field_174879_c.func_177972_a(EnumFacing.UP)).func_177230_c();
        return crank != null && crank == Calculator.crankHandle;
    }

    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.readData(nbt, type);
        if (type.isType(new NBTHelper.SyncType[]{NBTHelper.SyncType.SAVE, NBTHelper.SyncType.DEFAULT_SYNC})) {
            this.cranked = nbt.func_74767_n("cranked");
            this.ticks = nbt.func_74762_e("ticks");
        }
    }

    public NBTTagCompound writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.writeData(nbt, type);
        if (type.isType(new NBTHelper.SyncType[]{NBTHelper.SyncType.SAVE, NBTHelper.SyncType.DEFAULT_SYNC})) {
            nbt.func_74757_a("cranked", this.cranked());
            nbt.func_74768_a("ticks", this.ticks);
        }
        return nbt;
    }

    public List<String> getWailaInfo(List<String> tooltip, IBlockState state) {
        tooltip.add(FontHelper.translate((String)"crank.cranked") + ": " + (this.cranked ? FontHelper.translate((String)"locator.true") : FontHelper.translate((String)"locator.false")));
        return tooltip;
    }

    public Object getGuiContainer(EntityPlayer player) {
        return new ContainerCrankedGenerator(player.field_71071_by, this);
    }

    public Object getGuiScreen(EntityPlayer player) {
        return new GuiCrankedGenerator(player.field_71071_by, this);
    }
}

