/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.common.tileentity.generators;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import sonar.calculator.mod.CalculatorConfig;
import sonar.calculator.mod.client.gui.generators.GuiExtractor;
import sonar.calculator.mod.common.containers.ContainerExtractor;
import sonar.calculator.mod.common.recipes.machines.GlowstoneExtractorRecipes;
import sonar.calculator.mod.common.recipes.machines.RedstoneExtractorRecipes;
import sonar.calculator.mod.common.recipes.machines.StarchExtractorRecipes;
import sonar.core.api.energy.EnergyMode;
import sonar.core.common.tileentity.TileEntityEnergyInventory;
import sonar.core.helpers.FontHelper;
import sonar.core.inventory.SonarInventory;
import sonar.core.network.sync.SyncTagType;
import sonar.core.utils.IGuiTile;

public abstract class TileEntityGenerator
extends TileEntityEnergyInventory
implements ISidedInventory,
IGuiTile {
    protected TileEntity[] handlers = new TileEntity[6];
    public SyncTagType.INT itemLevel = new SyncTagType.INT(0);
    public SyncTagType.INT burnTime = new SyncTagType.INT(1);
    public SyncTagType.INT maxBurnTime = new SyncTagType.INT(2);
    public int levelMax = 5000;
    public int requiredLevel = 400;
    public int energyMultiplier;
    private static final int[] slotsTop = new int[]{0};
    private static final int[] slotsBottom = new int[]{2, 1};
    private static final int[] slotsSides = new int[]{1};

    public TileEntityGenerator() {
        this.storage.setCapacity(1000000).setMaxTransfer(800);
        this.inv = new SonarInventory((TileEntity)this, 2);
        this.energyMode = EnergyMode.SEND;
        this.maxTransfer = 2000;
        this.syncParts.addAll(Lists.newArrayList((Object[])new SyncTagType.INT[]{this.itemLevel, this.burnTime, this.maxBurnTime}));
    }

    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K) {
            this.processItemLevel();
            this.generateEnergy();
            this.addEnergy(EnumFacing.field_82609_l);
        }
        this.func_70296_d();
    }

    public void generateEnergy() {
        int itemBurnTime;
        ItemStack stack = this.func_70301_a(0);
        if (stack != null && (Integer)this.burnTime.getObject() == 0 && TileEntityFurnace.func_145954_b((ItemStack)stack) && this.storage.getEnergyStored() != this.storage.getMaxEnergyStored() && (Integer)this.itemLevel.getObject() >= this.requiredLevel && (itemBurnTime = TileEntityFurnace.func_145952_a((ItemStack)stack)) != 0) {
            this.maxBurnTime.setObject((Object)itemBurnTime);
            this.burnTime.increaseBy(1);
            if (this.slots()[0] != null) {
                --this.slots()[0].field_77994_a;
                if (this.slots()[0].field_77994_a <= 0) {
                    this.slots()[0] = this.slots()[0].func_77973_b().getContainerItem(this.slots()[0]);
                }
            }
        }
        if ((Integer)this.burnTime.getObject() > 0 && (Integer)this.burnTime.getObject() < (Integer)this.maxBurnTime.getObject()) {
            this.storage.receiveEnergy(this.energyMultiplier, false);
            this.burnTime.increaseBy(1);
        }
        if ((Integer)this.maxBurnTime.getObject() != 0 && (Integer)this.burnTime.getObject() >= (Integer)this.maxBurnTime.getObject()) {
            this.storage.receiveEnergy(this.energyMultiplier, false);
            this.burnTime.setObject((Object)0);
            this.removeItem(this.requiredLevel);
        }
    }

    public void processItemLevel() {
        ItemStack stack = this.slots()[1];
        if (stack == null || this.getItemValue(stack) <= 0) {
            return;
        }
        if ((Integer)this.itemLevel.getObject() + this.getItemValue(stack) <= this.levelMax) {
            this.addItem(this.getItemValue(stack));
            --this.slots()[1].field_77994_a;
            if (this.slots()[1].field_77994_a <= 0) {
                this.slots()[1] = null;
            }
        }
    }

    public abstract int getItemValue(ItemStack var1);

    public void addItem(int add) {
        this.itemLevel.increaseBy(add);
    }

    public void removeItem(int remove) {
        this.itemLevel.increaseBy(-remove);
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        if (slot == 0 && TileEntityFurnace.func_145954_b((ItemStack)stack)) {
            return true;
        }
        return slot == 1 && this.getItemValue(stack) > 0;
    }

    public int[] func_180463_a(EnumFacing side) {
        return side == EnumFacing.DOWN ? slotsSides : (side == EnumFacing.UP ? slotsTop : slotsSides);
    }

    public boolean func_180462_a(int slot, ItemStack stack, EnumFacing direction) {
        return this.func_94041_b(slot, stack);
    }

    public boolean func_180461_b(int slot, ItemStack stack, EnumFacing direction) {
        return direction != EnumFacing.DOWN || slot != 1 || stack != null && stack.func_77973_b() == Items.field_151133_ar;
    }

    public Object getGuiContainer(EntityPlayer player) {
        return new ContainerExtractor(player.field_71071_by, this);
    }

    public static class GlowstoneExtractor
    extends TileEntityGenerator {
        public GlowstoneExtractor() {
            this.energyMultiplier = CalculatorConfig.getInteger("Glowstone Extractor");
        }

        @Override
        public int getItemValue(ItemStack stack) {
            return GlowstoneExtractorRecipes.instance().getOutput(stack);
        }

        @SideOnly(value=Side.CLIENT)
        public List<String> getWailaInfo(List<String> currenttip, IBlockState state) {
            currenttip.add(FontHelper.translate((String)"generator.glowstone") + ": " + (Integer)this.itemLevel.getObject() * 100 / 5000 + "%");
            return currenttip;
        }

        public Object getGuiScreen(EntityPlayer player) {
            return new GuiExtractor.Glowstone(player.field_71071_by, this);
        }
    }

    public static class RedstoneExtractor
    extends TileEntityGenerator {
        public RedstoneExtractor() {
            this.energyMultiplier = CalculatorConfig.getInteger("Redstone Extractor");
        }

        @Override
        public int getItemValue(ItemStack stack) {
            return RedstoneExtractorRecipes.instance().getOutput(stack);
        }

        @SideOnly(value=Side.CLIENT)
        public List<String> getWailaInfo(List<String> currenttip, IBlockState state) {
            currenttip.add(FontHelper.translate((String)"generator.redstone") + ": " + (Integer)this.itemLevel.getObject() * 100 / 5000 + "%");
            return currenttip;
        }

        public Object getGuiScreen(EntityPlayer player) {
            return new GuiExtractor.Redstone(player.field_71071_by, this);
        }
    }

    public static class StarchExtractor
    extends TileEntityGenerator {
        public StarchExtractor() {
            this.energyMultiplier = CalculatorConfig.getInteger("Starch Extractor");
        }

        @SideOnly(value=Side.CLIENT)
        public List<String> getWailaInfo(List<String> currenttip, IBlockState state) {
            currenttip.add(FontHelper.translate((String)"generator.starch") + ": " + (Integer)this.itemLevel.getObject() * 100 / 5000 + "%");
            return currenttip;
        }

        @Override
        public int getItemValue(ItemStack stack) {
            return StarchExtractorRecipes.instance().getOutput(stack);
        }

        public Object getGuiScreen(EntityPlayer player) {
            return new GuiExtractor.Starch(player.field_71071_by, this);
        }
    }
}

