/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.common.tileentity.machines;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import sonar.calculator.mod.Calculator;
import sonar.calculator.mod.api.items.IStability;
import sonar.calculator.mod.client.gui.machines.GuiAnalysingChamber;
import sonar.calculator.mod.common.containers.ContainerAnalysingChamber;
import sonar.calculator.mod.common.recipes.machines.AnalysingChamberRecipes;
import sonar.calculator.mod.common.tileentity.machines.TileEntityStorageChamber;
import sonar.core.api.SonarAPI;
import sonar.core.api.energy.EnergyMode;
import sonar.core.api.upgrades.IUpgradableTile;
import sonar.core.api.utils.BlockCoords;
import sonar.core.common.tileentity.TileEntityEnergySidedInventory;
import sonar.core.helpers.FontHelper;
import sonar.core.helpers.NBTHelper;
import sonar.core.helpers.SonarHelper;
import sonar.core.inventory.IAdditionalInventory;
import sonar.core.inventory.SonarInventory;
import sonar.core.network.sync.SyncTagType;
import sonar.core.upgrades.UpgradeInventory;
import sonar.core.utils.IGuiTile;
import sonar.core.utils.MachineSideConfig;

public class TileEntityAnalysingChamber
extends TileEntityEnergySidedInventory
implements IUpgradableTile,
IAdditionalInventory,
IGuiTile {
    public SyncTagType.INT stable = new SyncTagType.INT(0);
    public SyncTagType.INT analysed = new SyncTagType.INT(2);
    public int maxTransfer = 2000;
    public int transferTicks = 0;
    public final int transferTime = 20;
    public UpgradeInventory upgrades = new UpgradeInventory(1, new Object[]{"VOID", "TRANSFER"});

    public TileEntityAnalysingChamber() {
        this.input = new int[]{0};
        this.output = new int[]{2, 3, 4, 5, 6, 7};
        this.storage.setCapacity(100000).setMaxTransfer(64000);
        this.inv = new SonarInventory((TileEntity)this, 8){

            public void func_70299_a(int i, ItemStack itemstack) {
                super.func_70299_a(i, itemstack);
                if (i == 0) {
                    TileEntityAnalysingChamber.this.markBlockForUpdate();
                }
            }
        };
        ((TileEntityEnergySidedInventory)this).maxTransfer = 2000;
        this.energyMode = EnergyMode.SEND;
        this.syncParts.addAll(Lists.newArrayList((Object[])new SyncTagType.INT[]{this.stable, this.analysed}));
    }

    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.upgrades.getUpgradesInstalled("TRANSFER") > 0) {
            this.transferItems();
        }
        if ((Integer)this.analysed.getObject() == 1 && this.slots()[0] == null) {
            this.analysed.setObject((Object)0);
            this.stable.setObject((Object)0);
        }
        if (this.canAnalyse()) {
            this.analyse(0);
        }
        this.charge(1);
        this.stable.setObject((Object)this.stable(0));
        this.addEnergy(EnumFacing.field_82609_l);
        this.func_70296_d();
    }

    public void transferItems() {
        ArrayList outputs = this.sides.getSidesWithConfig(MachineSideConfig.OUTPUT);
        for (EnumFacing side : outputs) {
            SonarAPI.getItemHelper().transferItems((TileEntity)this, SonarHelper.getAdjacentTileEntity((TileEntity)this, (EnumFacing)side), side, side.func_176734_d(), null);
        }
        ArrayList inputs = this.sides.getSidesWithConfig(MachineSideConfig.INPUT);
        if (!inputs.isEmpty()) {
            ArrayList chambers = SonarHelper.getConnectedBlocks((Block)Calculator.storageChamber, (List)inputs, (World)this.field_145850_b, (BlockPos)this.field_174879_c, (int)256);
            for (BlockCoords chamber : chambers) {
                TileEntity tile = chamber.getTileEntity(this.field_145850_b);
                if (tile == null || !(tile instanceof TileEntityStorageChamber)) continue;
                SonarAPI.getItemHelper().transferItems((TileEntity)this, tile, (EnumFacing)inputs.get(0), ((EnumFacing)inputs.get(0)).func_176734_d(), null);
                if (this.slots()[0] != null) continue;
                return;
            }
        }
    }

    private void analyse(int slot) {
        NBTTagCompound tag;
        if (this.slots()[slot].func_77942_o() && !(tag = this.slots()[slot].func_77978_p()).func_74767_n("Analysed")) {
            int storedEnergy = TileEntityAnalysingChamber.itemEnergy(this.slots()[slot].func_77978_p().func_74762_e("Energy"));
            this.storage.receiveEnergy(storedEnergy, false);
            if (this.upgrades.getUpgradesInstalled("VOID") == 0) {
                ItemStack item1 = AnalysingChamberRecipes.instance().getResult(1, tag.func_74762_e("Item1"));
                ItemStack item2 = AnalysingChamberRecipes.instance().getResult(1, tag.func_74762_e("Item2"));
                if (item1 != null) {
                    this.add(item1, 2);
                }
                if (item2 == null) {
                    this.add(item2, 3);
                }
            }
            ItemStack item3 = AnalysingChamberRecipes.instance().getResult(2, tag.func_74762_e("Item3"));
            ItemStack item4 = AnalysingChamberRecipes.instance().getResult(3, tag.func_74762_e("Item4"));
            ItemStack item5 = AnalysingChamberRecipes.instance().getResult(4, tag.func_74762_e("Item5"));
            ItemStack item6 = AnalysingChamberRecipes.instance().getResult(5, tag.func_74762_e("Item6"));
            if (item3 != null) {
                this.add(item3, 4);
            }
            if (item4 != null) {
                this.add(item4, 5);
            }
            if (item5 != null) {
                this.add(item5, 6);
            }
            if (item6 != null) {
                this.add(item6, 7);
            }
            tag.func_82580_o("Item1");
            tag.func_82580_o("Item2");
            tag.func_82580_o("Item3");
            tag.func_82580_o("Item4");
            tag.func_82580_o("Item5");
            tag.func_82580_o("Item6");
            tag.func_82580_o("Energy");
            tag.func_74757_a("Analysed", true);
            this.analysed.setObject((Object)1);
        }
    }

    private void add(ItemStack item, int slotID) {
        if (item != null && this.canAnalyse()) {
            this.slots()[slotID] = new ItemStack(item.func_77973_b(), 1, item.func_77952_i());
        }
    }

    private boolean canAnalyse() {
        if (this.slots()[0] != null && this.slots()[0].func_77973_b() == Calculator.circuitBoard && this.slots()[2] == null && this.slots()[3] == null && this.slots()[4] == null && this.slots()[5] == null && this.slots()[6] == null && this.slots()[7] == null) {
            return true;
        }
        if (this.slots()[0] == null) {
            this.stable.setObject((Object)0);
            return false;
        }
        return false;
    }

    public static int itemEnergy(int n) {
        if (n == 0) {
            return 0;
        }
        if (n == 1) {
            return 1000;
        }
        if (n == 2) {
            return 500;
        }
        if (n == 3) {
            return 250;
        }
        if (n == 4) {
            return 10000;
        }
        if (n == 5) {
            return 5000;
        }
        if (n == 6) {
            return 100000;
        }
        if (n == 7) {
            return 100;
        }
        if (n == 8) {
            return 175;
        }
        if (n == 9) {
            return 400;
        }
        if (n == 10) {
            return 750;
        }
        if (n == 11) {
            return 800;
        }
        return 0;
    }

    private int stable(int par) {
        if (this.slots()[par] != null && this.slots()[par].func_77942_o() && this.slots()[par].func_77973_b() instanceof IStability) {
            IStability item = (IStability)this.slots()[par].func_77973_b();
            boolean stable = item.getStability(this.slots()[par]);
            if (!stable) {
                item.onFalse(this.slots()[par]);
            }
            return stable ? 1 : 0;
        }
        return 0;
    }

    public EnergyMode getModeForSide(EnumFacing side) {
        if (side == null) {
            return EnergyMode.SEND_RECIEVE;
        }
        if (side == EnumFacing.DOWN) {
            return EnergyMode.SEND;
        }
        return EnergyMode.BLOCKED;
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        if (slot == 0) {
            if (stack.func_77973_b() == Calculator.circuitBoard) {
                return true;
            }
            if (stack.func_77973_b() == Calculator.circuitBoard) {
                return true;
            }
        }
        return false;
    }

    public boolean func_180462_a(int slot, ItemStack stack, EnumFacing side) {
        return this.func_94041_b(slot, stack);
    }

    public boolean func_180461_b(int slot, ItemStack stack, EnumFacing side) {
        return slot != 1;
    }

    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.readData(nbt, type);
        if (type.isType(new NBTHelper.SyncType[]{NBTHelper.SyncType.DEFAULT_SYNC, NBTHelper.SyncType.SAVE})) {
            this.upgrades.readData(nbt, type);
        }
    }

    public NBTTagCompound writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.writeData(nbt, type);
        if (type.isType(new NBTHelper.SyncType[]{NBTHelper.SyncType.DEFAULT_SYNC, NBTHelper.SyncType.SAVE})) {
            this.upgrades.writeData(nbt, type);
        }
        return nbt;
    }

    @SideOnly(value=Side.CLIENT)
    public List<String> getWailaInfo(List<String> currenttip, IBlockState state) {
        int vUpgrades = this.upgrades.getUpgradesInstalled("VOID");
        if (vUpgrades != 0) {
            currenttip.add(FontHelper.translate((String)"circuit.void") + ": " + FontHelper.translate((String)"circuit.installed"));
        }
        return currenttip;
    }

    public ItemStack[] getAdditionalStacks() {
        ArrayList drops = this.upgrades.getDrops();
        if (drops == null || drops.isEmpty()) {
            return new ItemStack[]{null};
        }
        ItemStack[] toDrop = new ItemStack[drops.size()];
        int pos = 0;
        for (ItemStack drop : drops) {
            if (drop != null) {
                toDrop[pos] = drop;
            }
            ++pos;
        }
        return toDrop;
    }

    public Object getGuiContainer(EntityPlayer player) {
        return new ContainerAnalysingChamber(player.field_71071_by, this);
    }

    public Object getGuiScreen(EntityPlayer player) {
        return new GuiAnalysingChamber(player.field_71071_by, this);
    }

    public UpgradeInventory getUpgradeInventory() {
        return this.upgrades;
    }
}

