/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.common.tileentity.machines;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import sonar.calculator.mod.Calculator;
import sonar.calculator.mod.api.items.IStability;
import sonar.calculator.mod.client.gui.misc.GuiFabricationChamber;
import sonar.calculator.mod.common.containers.ContainerFabricationChamber;
import sonar.calculator.mod.common.item.misc.CircuitBoard;
import sonar.calculator.mod.common.recipes.machines.FabricationChamberRecipes;
import sonar.calculator.mod.common.tileentity.machines.TileEntityStorageChamber;
import sonar.core.api.SonarAPI;
import sonar.core.api.inventories.StoredItemStack;
import sonar.core.api.utils.ActionType;
import sonar.core.api.utils.BlockCoords;
import sonar.core.common.block.SonarBlock;
import sonar.core.common.tileentity.TileEntityInventory;
import sonar.core.helpers.ItemStackHelper;
import sonar.core.helpers.NBTHelper;
import sonar.core.helpers.SonarHelper;
import sonar.core.inventory.SonarInventory;
import sonar.core.network.utils.IByteBufTile;
import sonar.core.utils.IGuiTile;

public class TileEntityFabricationChamber
extends TileEntityInventory
implements IGuiTile,
IByteBufTile {
    public ItemStack selected = null;
    public int fabricateTime = 200;
    public int moveTime = 100;
    public boolean moved;
    public boolean canMove;
    public int currentFabricateTime = 0;
    public int currentMoveTime = 0;

    public TileEntityFabricationChamber() {
        this.inv = new SonarInventory((TileEntity)this, 1);
    }

    public void func_73660_a() {
        super.func_73660_a();
        if (this.canMove) {
            if (this.currentMoveTime != 50 && this.currentMoveTime != 0) {
                this.currentMoveTime = !this.moved ? ++this.currentMoveTime : --this.currentMoveTime;
                if (this.currentMoveTime == 0) {
                    this.canMove = false;
                }
            } else if (this.currentMoveTime == 50) {
                if (this.currentFabricateTime != this.fabricateTime) {
                    ++this.currentFabricateTime;
                    if (this.isClient() && (this.currentFabricateTime & 1) == 0 && (this.currentFabricateTime / 2 & 1) == 0) {
                        EnumFacing face = (EnumFacing)this.field_145850_b.func_180495_p(this.func_174877_v()).func_177229_b((IProperty)SonarBlock.FACING);
                        int fX = face.func_82601_c();
                        int n = face.func_82599_e();
                    }
                } else {
                    this.currentFabricateTime = 0;
                    --this.currentMoveTime;
                    this.moved = true;
                    this.fabricate();
                }
            } else if (this.currentMoveTime == 0) {
                this.moved = false;
                ++this.currentMoveTime;
            }
        }
    }

    public ArrayList<TileEntityStorageChamber> getChambers() {
        ArrayList<TileEntityStorageChamber> chambers = new ArrayList<TileEntityStorageChamber>();
        ArrayList connected = SonarHelper.getConnectedBlocks((Block)Calculator.storageChamber, Arrays.asList(EnumFacing.field_82609_l), (World)this.field_145850_b, (BlockPos)this.field_174879_c, (int)256);
        for (BlockCoords chamber : connected) {
            TileEntity tile = chamber.getTileEntity(this.field_145850_b);
            if (tile == null || !(tile instanceof TileEntityStorageChamber)) continue;
            chambers.add((TileEntityStorageChamber)tile);
        }
        return chambers;
    }

    public ArrayList<FabricationChamberRecipes.CircuitStack> getAvailableCircuits(ArrayList<TileEntityStorageChamber> chambers) {
        ArrayList<FabricationChamberRecipes.CircuitStack> circuits = new ArrayList<FabricationChamberRecipes.CircuitStack>();
        for (TileEntityStorageChamber chamber : chambers) {
            for (StoredItemStack storedstack : chamber.getTileInv().slots) {
                if (storedstack == null || storedstack.getItemStack().func_77973_b() != Calculator.circuitBoard) continue;
                FabricationChamberRecipes.CircuitStack storedStack = new FabricationChamberRecipes.CircuitStack(storedstack.getItemStack().func_77952_i(), storedstack.stored, ((IStability)storedstack.getItemStack().func_77973_b()).getStability(storedstack.getItemStack()));
                this.addCircuitToStack(circuits, storedStack);
            }
        }
        return circuits;
    }

    public void addCircuitToStack(ArrayList<FabricationChamberRecipes.CircuitStack> circuits, FabricationChamberRecipes.CircuitStack stack) {
        for (FabricationChamberRecipes.CircuitStack stored : circuits) {
            if (stored.stable != stack.stable || stored.meta != stack.meta) continue;
            stored.required += stack.required;
            return;
        }
        circuits.add(stack);
    }

    public void fabricate() {
        if (this.selected == null || this.isClient()) {
            return;
        }
        ItemStack selected = this.selected.func_77946_l();
        if (selected.field_77994_a == 0) {
            ++selected.field_77994_a;
        }
        ArrayList<TileEntityStorageChamber> chambers = this.getChambers();
        ArrayList<FabricationChamberRecipes.CircuitStack> available = this.getAvailableCircuits(chambers);
        FabricationChamberRecipes.CircuitStack[] requirements = (FabricationChamberRecipes.CircuitStack[])FabricationChamberRecipes.getInstance().getRequirements(selected).clone();
        if (requirements != null && FabricationChamberRecipes.canPerformRecipe(requirements, available)) {
            ItemStack current = this.slots()[0];
            boolean fabricated = false;
            if (current == null) {
                this.slots()[0] = selected.func_77946_l();
                fabricated = true;
            } else if (ItemStackHelper.equalStacksRegular((ItemStack)current, (ItemStack)selected) && current.field_77994_a + selected.field_77994_a <= this.func_70297_j_() && current.field_77994_a + selected.field_77994_a <= selected.func_77976_d()) {
                this.slots()[0].field_77994_a += selected.func_77946_l().field_77994_a;
                fabricated = true;
            }
            if (fabricated) {
                List<Object> used = Arrays.asList((Object[])requirements.clone());
                ArrayList stacks = new ArrayList();
                for (FabricationChamberRecipes.CircuitStack circuitStack : used) {
                    ItemStack item = new ItemStack(Calculator.circuitBoard, 1, circuitStack.meta);
                    NBTTagCompound tag = new NBTTagCompound();
                    if (((CircuitBoard)item.func_77973_b()).getStability(item)) {
                        tag.func_74768_a("Stable", 1);
                    } else {
                        tag.func_74768_a("Stable", 0);
                    }
                    tag.func_74757_a("Analysed", true);
                    item.func_77982_d(tag);
                    SonarAPI.getItemHelper().addStackToList(stacks, new StoredItemStack(item).setStackSize(circuitStack.required));
                }
                for (TileEntityStorageChamber tileEntityStorageChamber : chambers) {
                    if (stacks.isEmpty()) break;
                    for (StoredItemStack stack : stacks) {
                        if (stack.stored == 0L) continue;
                        StoredItemStack remove = SonarAPI.getItemHelper().removeItems((TileEntity)tileEntityStorageChamber, stack.copy(), EnumFacing.DOWN, ActionType.PERFORM, null);
                        stack.stored -= remove.stored;
                    }
                }
                this.func_70296_d();
            }
        }
    }

    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.readData(nbt, type);
        if (type.isType(new NBTHelper.SyncType[]{NBTHelper.SyncType.DEFAULT_SYNC, NBTHelper.SyncType.SAVE})) {
            this.selected = nbt.func_74764_b("selected") ? ItemStack.func_77949_a((NBTTagCompound)((NBTTagCompound)nbt.func_74781_a("selected"))) : null;
        }
    }

    public NBTTagCompound writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.writeData(nbt, type);
        if (type.isType(new NBTHelper.SyncType[]{NBTHelper.SyncType.DEFAULT_SYNC, NBTHelper.SyncType.SAVE}) && this.selected != null) {
            NBTTagCompound tag = new NBTTagCompound();
            this.selected.func_77955_b(tag);
            nbt.func_74782_a("selected", (NBTBase)tag);
        }
        return nbt;
    }

    public void writePacket(ByteBuf buf, int id) {
        switch (id) {
            case 0: {
                ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.selected);
                break;
            }
            case 1: {
                if (this.canMove) break;
                this.canMove = true;
            }
        }
    }

    public void readPacket(ByteBuf buf, int id) {
        switch (id) {
            case 0: {
                this.selected = ByteBufUtils.readItemStack((ByteBuf)buf);
                break;
            }
            case 1: {
                if (this.canMove) break;
                this.canMove = true;
            }
        }
    }

    public Object getGuiContainer(EntityPlayer player) {
        return new ContainerFabricationChamber(player.field_71071_by, this);
    }

    public Object getGuiScreen(EntityPlayer player) {
        return new GuiFabricationChamber(player.field_71071_by, this);
    }
}

