/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.common.tileentity.machines;

import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import sonar.calculator.mod.Calculator;
import sonar.calculator.mod.common.containers.ContainerFlawlessFurnace;
import sonar.calculator.mod.common.item.misc.CircuitBoard;
import sonar.calculator.mod.common.recipes.machines.AlgorithmSeparatorRecipes;
import sonar.core.api.machines.IPausable;
import sonar.core.common.tileentity.TileEntityEnergySidedInventory;
import sonar.core.helpers.NBTHelper;
import sonar.core.helpers.RecipeHelper;
import sonar.core.inventory.SonarInventory;
import sonar.core.network.sync.SyncTagType;
import sonar.core.utils.IGuiTile;

public class TileEntityFlawlessFurnace
extends TileEntityEnergySidedInventory
implements IPausable,
IGuiTile {
    public SyncTagType.INT[] cookTime = new SyncTagType.INT[9];
    public float renderTicks;
    public double energyBuffer;
    public boolean paused;
    public final int speed = 100;
    public final int size = 9;
    public int maxProcess;

    public TileEntityFlawlessFurnace() {
        this.inv = new SonarInventory((TileEntity)this, 28);
        this.storage.setCapacity(10000000).setMaxTransfer(64000);
    }

    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b.func_175640_z(this.field_174879_c)) {
            this.paused = true;
            return;
        }
        this.paused = false;
        this.discharge(27);
        if (!this.paused) {
            for (int i = 0; i < 9; ++i) {
                int energyUsage;
                if ((Integer)this.cookTime[i].getObject() > 0) {
                    this.cookTime[i].increaseBy(1);
                    if (!this.field_145850_b.field_72995_K) {
                        this.energyBuffer += this.energyUsage() / 100.0 * 8.0;
                        energyUsage = (int)Math.round(this.energyBuffer);
                        this.energyBuffer = this.energyBuffer - (double)energyUsage < 0.0 ? 0.0 : (this.energyBuffer -= (double)energyUsage);
                        this.storage.modifyEnergyStored(-energyUsage);
                    }
                }
                if (this.canProcess(i)) {
                    if (this.field_145850_b.field_72995_K) continue;
                    if ((Integer)this.cookTime[i].getObject() == 0) {
                        this.cookTime[i].increaseBy(1);
                        this.energyBuffer += this.energyUsage() / 100.0;
                        energyUsage = (int)Math.round(this.energyBuffer);
                        this.energyBuffer = this.energyBuffer - (double)energyUsage < 0.0 ? 0.0 : (this.energyBuffer -= (double)energyUsage);
                        this.storage.modifyEnergyStored(-energyUsage);
                    }
                    if ((Integer)this.cookTime[i].getObject() < this.currentSpeed()) continue;
                    for (int process = 0; process < 8; ++process) {
                        if (!this.canProcess(i)) continue;
                        this.finishProcess(i);
                    }
                    if (this.canProcess(i)) {
                        this.cookTime[i].increaseBy(1);
                    }
                    this.cookTime[i].setObject((Object)0);
                    this.energyBuffer = 0.0;
                    continue;
                }
                this.renderTicks = 0.0f;
                if ((Integer)this.cookTime[i].getObject() == 0) continue;
                this.cookTime[i].setObject((Object)0);
                this.energyBuffer = 0.0;
            }
        }
        this.func_70296_d();
    }

    public boolean canProcess(int slot) {
        ItemStack[] output;
        if (this.slots()[slot] == null) {
            return false;
        }
        if ((Integer)this.cookTime[slot].getObject() == 0) {
            // empty if block
        }
        if ((output = this.getOutput(true, this.slots()[slot])) == null || output.length == 0) {
            return false;
        }
        for (int o = 0; o < output.length; ++o) {
            if (output[o] == null) {
                return false;
            }
            if (this.slots()[slot + (o + 1) * 9] == null) continue;
            if (!this.slots()[slot + (o + 1) * 9].func_77969_a(output[o])) {
                return false;
            }
            if (this.slots()[slot + (o + 1) * 9].field_77994_a + output[o].field_77994_a <= this.slots()[slot + (o + 1) * 9].func_77976_d()) continue;
            return false;
        }
        return true;
    }

    public void finishProcess(int slot) {
        ItemStack[] output = this.getOutput(false, this.slots()[slot]);
        for (int o = 0; o < output.length; ++o) {
            if (output[o] == null) continue;
            if (this.slots()[slot + (o + 1) * 9] == null) {
                ItemStack outputStack = output[o].func_77946_l();
                if (output[o].func_77973_b() == Calculator.circuitBoard) {
                    CircuitBoard.setData(outputStack);
                }
                this.slots()[slot + (o + 1) * 9] = outputStack;
                continue;
            }
            if (!this.slots()[slot + (o + 1) * 9].func_77969_a(output[o])) continue;
            this.slots()[slot + (o + 1) * 9].field_77994_a += output[o].field_77994_a;
        }
        this.slots()[slot].field_77994_a = this.recipeHelper() != null ? (this.slots()[slot].field_77994_a -= this.recipeHelper().getInputSize(0, output)) : --this.slots()[slot].field_77994_a;
        if (this.slots()[slot].field_77994_a <= 0) {
            this.slots()[slot] = null;
        }
    }

    public RecipeHelper recipeHelper() {
        return AlgorithmSeparatorRecipes.instance();
    }

    public ItemStack[] getOutput(boolean simulate, ItemStack ... stacks) {
        return this.recipeHelper().getOutput(stacks);
    }

    public int currentSpeed() {
        return 100;
    }

    private int roundNumber(double i) {
        return (int)(Math.ceil(i / 10.0) * 10.0);
    }

    public double energyUsage() {
        return 5000.0;
    }

    public boolean func_145842_c(int action, int param) {
        if (action == 1) {
            this.markBlockForUpdate();
        }
        return true;
    }

    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.readData(nbt, type);
        if (type.isType(new NBTHelper.SyncType[]{NBTHelper.SyncType.DEFAULT_SYNC, NBTHelper.SyncType.SAVE})) {
            for (int i = 0; i < this.cookTime.length; ++i) {
                this.cookTime[i].readData(nbt, type);
            }
            this.paused = nbt.func_74767_n("pause");
        }
    }

    public NBTTagCompound writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.writeData(nbt, type);
        if (type.isType(new NBTHelper.SyncType[]{NBTHelper.SyncType.DEFAULT_SYNC, NBTHelper.SyncType.SAVE})) {
            for (int i = 0; i < this.cookTime.length; ++i) {
                this.cookTime[i].writeData(nbt, type);
            }
            nbt.func_74757_a("pause", this.paused);
        }
        return nbt;
    }

    public boolean isActive() {
        return !this.isPaused();
    }

    public void onPause() {
        this.paused = !this.paused;
        this.markBlockForUpdate();
        this.field_145850_b.func_175641_c(this.field_174879_c, this.field_145854_h, 1, 1);
    }

    public boolean isPaused() {
        return this.paused;
    }

    public boolean func_180461_b(int slot, ItemStack stack, EnumFacing dir) {
        return true;
    }

    public boolean canStack(ItemStack current, ItemStack stack) {
        if (current == null) {
            return true;
        }
        return current.field_77994_a != current.func_77976_d();
    }

    @SideOnly(value=Side.CLIENT)
    public List<String> getWailaInfo(List<String> currenttip, IBlockState state) {
        return currenttip;
    }

    public Object getGuiContainer(EntityPlayer player) {
        return null;
    }

    public Object getGuiScreen(EntityPlayer player) {
        return new ContainerFlawlessFurnace(player.field_71071_by, this);
    }
}

