/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.integration.minetweaker;

import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import minetweaker.api.liquid.ILiquidStack;
import minetweaker.api.minecraft.MineTweakerMC;
import minetweaker.api.oredict.IOreDictEntry;
import net.minecraft.item.ItemStack;
import sonar.calculator.mod.common.recipes.RecipeRegistry;
import sonar.core.helpers.RecipeHelper;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.calculator.conductorMast")
public class ConductorMastHandler {
    @ZenMethod
    public static void addRecipe(IIngredient input, int powercost, IItemStack output) {
        MineTweakerAPI.apply((IUndoableAction)new AddRecipeAction(input, powercost, MineTweakerMC.getItemStack((IItemStack)output)));
    }

    @ZenMethod
    public static void removeRecipe(IIngredient input) {
        MineTweakerAPI.apply((IUndoableAction)new RemoveRecipeAction(input));
    }

    private static class RemoveRecipeAction
    implements IUndoableAction {
        private Object input;
        private int powercost;
        private ItemStack output;

        public RemoveRecipeAction(Object input) {
            if (input instanceof IItemStack) {
                input = MineTweakerMC.getItemStack((IItemStack)((IItemStack)input));
            }
            if (input instanceof IOreDictEntry) {
                input = new RecipeHelper.OreStack(((IOreDictEntry)input).getName(), 1);
            }
            if (input instanceof ILiquidStack) {
                MineTweakerAPI.logError((String)"A liquid was passed intro a calculator recipe, calculators do not use liquids when crafting, aborting!");
                this.output = null;
                input = null;
            }
            this.input = input;
            ItemStack dummyInput = null;
            if (input instanceof ItemStack) {
                dummyInput = (ItemStack)input;
            }
            if (input instanceof RecipeHelper.OreStack) {
                dummyInput = (ItemStack)((RecipeHelper.OreStack)input).getStacks().get(0);
            }
            this.output = RecipeRegistry.ConductorMastItemRecipes.instance().getCraftingResult(new ItemStack[]{dummyInput});
            this.powercost = RecipeRegistry.ConductorMastPowerRecipes.instance().getPowercost(dummyInput);
        }

        public void apply() {
            if (this.input == null || this.output == null) {
                return;
            }
            RecipeRegistry.ConductorMastItemRecipes.instance().removeRecipe(new Object[]{this.input});
            RecipeRegistry.ConductorMastPowerRecipes.instance().removeRecipe(new Object[]{this.input});
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
            if (this.input == null || this.output == null) {
                return;
            }
            RecipeRegistry.ConductorMastItemRecipes.instance().addRecipe(new Object[]{this.input, this.output});
            RecipeRegistry.ConductorMastPowerRecipes.instance().addRecipe(new Object[]{this.input, this.powercost});
        }

        public String describe() {
            return String.format("Removing conductor mast recipe (%s => %s  *powercost: %d RF)", this.input, this.output, this.powercost);
        }

        public String describeUndo() {
            return String.format("Reverting /%s/", this.describe());
        }

        public Object getOverrideKey() {
            return null;
        }
    }

    private static class AddRecipeAction
    implements IUndoableAction {
        private Object input;
        private ItemStack output;
        private int powercost;

        public AddRecipeAction(Object input, int powercost, ItemStack output) {
            if (input instanceof IItemStack) {
                input = MineTweakerMC.getItemStack((IItemStack)((IItemStack)input));
            }
            if (input instanceof IOreDictEntry) {
                input = new RecipeHelper.OreStack(((IOreDictEntry)input).getName(), 1);
            }
            if (input instanceof ILiquidStack) {
                MineTweakerAPI.logError((String)"A liquid was passed intro a conductor mast recipe, calculators do not use liquids when crafting, aborting!");
                output = null;
                input = null;
            }
            this.input = input;
            this.output = output;
            this.powercost = powercost;
        }

        public void apply() {
            if (this.input == null || this.output == null) {
                return;
            }
            RecipeRegistry.ConductorMastItemRecipes.instance().addRecipe(new Object[]{this.input, this.output});
            RecipeRegistry.ConductorMastPowerRecipes.instance().addRecipe(new Object[]{this.input, this.powercost});
        }

        public void undo() {
            if (this.input == null || this.output == null) {
                return;
            }
            RecipeRegistry.ConductorMastItemRecipes.instance().removeRecipe(new Object[]{this.input});
            RecipeRegistry.ConductorMastItemRecipes.instance().removeRecipe(new Object[]{this.input});
        }

        public String describe() {
            return String.format("Adding conductor mast recipe (%s => %s  *powercost: %d RF)", this.input, this.output, this.powercost);
        }

        public String describeUndo() {
            return String.format("Reverting /%s/", this.describe());
        }

        public boolean canUndo() {
            return true;
        }

        public Object getOverrideKey() {
            return null;
        }
    }
}

