/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.research.types;

import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import sonar.calculator.mod.Calculator;
import sonar.calculator.mod.research.IResearch;
import sonar.calculator.mod.research.Research;
import sonar.calculator.mod.research.ResearchCategory;
import sonar.calculator.mod.research.types.ResearchTypes;
import sonar.core.helpers.NBTHelper;

public abstract class CalculatorResearch
extends Research {
    public long count;
    public long required;
    public String name;

    public CalculatorResearch(long required, ResearchTypes type, String clientName, Item logo) {
        super(type, clientName, logo);
        this.required = required;
    }

    @Override
    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.readData(nbt, type);
        this.count = nbt.func_74763_f("count");
    }

    @Override
    public NBTTagCompound writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.writeData(nbt, type);
        nbt.func_74772_a("count", this.count);
        return nbt;
    }

    @Override
    public String getHint() {
        return "Become a master of the " + this.name;
    }

    @Override
    public byte getProgress() {
        long current = this.count;
        if (current > this.required) {
            current = this.required;
        }
        return (byte)((double)(current / this.required) * 100.0);
    }

    @Override
    public ResearchCategory getResearchType() {
        return ResearchCategory.CALCULATORS;
    }

    public static class Flawless
    extends CalculatorResearch {
        public Flawless() {
            super(1000L, ResearchTypes.FLAWLESS, "item.FlawlessCalculator.name", Calculator.itemFlawlessCalculator);
        }

        @Override
        public IResearch getInstance() {
            return new Flawless();
        }
    }

    public static class Atomic
    extends CalculatorResearch {
        public Atomic() {
            super(2500L, ResearchTypes.ATOMIC, "tile.AtomicCalculator.name", Item.func_150898_a((Block)Calculator.atomicCalculator));
        }

        @Override
        public IResearch getInstance() {
            return new Scientific();
        }
    }

    public static class Scientific
    extends CalculatorResearch {
        public Scientific() {
            super(5000L, ResearchTypes.SCIENTIFIC, "item.ScientificCalculator.name", Calculator.itemScientificCalculator);
        }

        @Override
        public IResearch getInstance() {
            return new Scientific();
        }
    }

    public static class Basic
    extends CalculatorResearch {
        public Basic() {
            super(10000L, ResearchTypes.CALCULATOR, "item.Calculator.name", Calculator.itemCalculator);
        }

        @Override
        public IResearch getInstance() {
            return new Basic();
        }
    }
}

