/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.research.types;

import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import sonar.calculator.mod.Calculator;
import sonar.calculator.mod.common.recipes.RecipeRegistry;
import sonar.calculator.mod.research.IResearch;
import sonar.calculator.mod.research.RecipeReward;
import sonar.calculator.mod.research.Research;
import sonar.calculator.mod.research.ResearchCategory;
import sonar.calculator.mod.research.types.ResearchTypes;
import sonar.core.helpers.NBTHelper;

public class RecipeResearch
extends Research {
    public ArrayList<String> recipes = new ArrayList();

    public RecipeResearch() {
        super(ResearchTypes.RECIPES, "tile.ResearchChamber.name", Item.func_150898_a((Block)Calculator.researchChamber));
    }

    @Override
    public String getHint() {
        return "Discover new recipes for the Calculator!";
    }

    @Override
    public ArrayList<RecipeReward> getUnlockedRecipes() {
        ArrayList<RecipeReward> unlocked = new ArrayList<RecipeReward>();
        unlocked.add(new RecipeReward("Calculator", this.recipes));
        return unlocked;
    }

    public void addRecipes(ArrayList<RecipeRegistry.RecipeType> types) {
        for (RecipeRegistry.RecipeType type : types) {
            if (this.recipes.contains(type.name())) continue;
            this.recipes.add(type.name());
        }
    }

    @Override
    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.readData(nbt, type);
        NBTTagCompound recipeList = (NBTTagCompound)nbt.func_74781_a("recipeList");
        this.recipes = new ArrayList();
        for (String recipeID : recipeList.func_150296_c()) {
            this.recipes.add(recipeID);
        }
    }

    @Override
    public NBTTagCompound writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.writeData(nbt, type);
        NBTTagCompound recipeList = new NBTTagCompound();
        for (String id : this.recipes) {
            recipeList.func_74757_a(id, true);
        }
        nbt.func_74782_a("recipeList", (NBTBase)recipeList);
        return nbt;
    }

    @Override
    public byte getProgress() {
        return (byte)(this.recipes.size() * 100 / RecipeRegistry.RecipeType.values().length);
    }

    @Override
    public ResearchCategory getResearchType() {
        return ResearchCategory.RECIPES;
    }

    @Override
    public IResearch getInstance() {
        return new RecipeResearch();
    }
}

