/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.utils.helpers;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraftforge.common.IPlantable;
import sonar.calculator.mod.common.block.CalculatorLeaves;
import sonar.calculator.mod.common.block.CalculatorLogs;
import sonar.calculator.mod.common.block.CalculatorSaplings;

public class CalculatorTreeBuilder
extends WorldGenAbstractTree {
    private final int minTreeHeight;
    private final boolean vinesGrow;
    private final int metaWood;
    private final int metaLeaves;
    private CalculatorSaplings sapling;
    private CalculatorLeaves blockLeaves;
    private CalculatorLogs blockLog;
    private static Random rand = new Random();

    public CalculatorTreeBuilder(boolean par1, Block sapling, Block blockLeaves, Block blockLog) {
        this(par1, 4 + rand.nextInt(2), 3, 3, false, (CalculatorSaplings)sapling, (CalculatorLeaves)blockLeaves, (CalculatorLogs)blockLog);
    }

    public CalculatorTreeBuilder(boolean par1, int height, int wood, int leaves, boolean vines, CalculatorSaplings sapling, CalculatorLeaves blockLeaves, CalculatorLogs blockLog) {
        super(par1);
        this.minTreeHeight = height;
        this.metaWood = wood;
        this.metaLeaves = leaves;
        this.vinesGrow = vines;
        this.sapling = sapling;
        this.blockLeaves = blockLeaves;
        this.blockLog = blockLog;
    }

    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        int l = rand.nextInt(3) + this.minTreeHeight;
        boolean flag = true;
        if (pos.func_177956_o() >= 1 && pos.func_177956_o() + l + 1 <= 256) {
            Block block;
            int k1;
            int b0;
            for (int i1 = pos.func_177956_o(); i1 <= pos.func_177956_o() + 1 + l; ++i1) {
                b0 = 1;
                if (i1 == pos.func_177956_o()) {
                    b0 = 0;
                }
                if (i1 >= pos.func_177956_o() + 1 + l - 2) {
                    b0 = 2;
                }
                for (int j1 = pos.func_177958_n() - b0; j1 <= pos.func_177958_n() + b0 && flag; ++j1) {
                    for (k1 = pos.func_177952_p() - b0; k1 <= pos.func_177952_p() + b0 && flag; ++k1) {
                        if (i1 >= 0 && i1 < 256) {
                            block = world.func_180495_p(new BlockPos(j1, i1, k1)).func_177230_c();
                            if (this.isReplaceable(world, new BlockPos(j1, i1, k1))) continue;
                            flag = false;
                            continue;
                        }
                        flag = false;
                    }
                }
            }
            if (!flag) {
                return false;
            }
            IBlockState state2 = world.func_180495_p(pos.func_177972_a(EnumFacing.DOWN));
            Block block2 = state2.func_177230_c();
            boolean isSoil = block2.canSustainPlant(state2, (IBlockAccess)world, pos.func_177972_a(EnumFacing.DOWN), EnumFacing.UP, (IPlantable)this.sapling);
            if (isSoil && pos.func_177956_o() < 256 - l - 1) {
                block2.onPlantGrow(state2, world, pos.func_177972_a(EnumFacing.DOWN), pos);
                b0 = 3;
                int b1 = 0;
                for (k1 = pos.func_177956_o() - b0 + l; k1 <= pos.func_177956_o() + l; ++k1) {
                    int i3 = k1 - (pos.func_177956_o() + l);
                    int l1 = b1 + 1 - i3 / 2;
                    for (int i2 = pos.func_177958_n() - l1; i2 <= pos.func_177958_n() + l1; ++i2) {
                        int j2 = i2 - pos.func_177958_n();
                        for (int k2 = pos.func_177952_p() - l1; k2 <= pos.func_177952_p() + l1; ++k2) {
                            IBlockState state1;
                            Block block1;
                            int l2 = k2 - pos.func_177952_p();
                            if (Math.abs(j2) == l1 && Math.abs(l2) == l1 && (rand.nextInt(2) == 0 || i3 == 0) || !(block1 = (state1 = world.func_180495_p(new BlockPos(i2, k1, k2))).func_177230_c()).isAir(state1, (IBlockAccess)world, new BlockPos(i2, k1, k2)) && !block1.isLeaves(state1, (IBlockAccess)world, new BlockPos(i2, k1, k2))) continue;
                            world.func_175656_a(new BlockPos(i2, k1, k2), this.blockLeaves.func_176223_P());
                        }
                    }
                }
                for (k1 = 0; k1 < l; ++k1) {
                    IBlockState offset = world.func_180495_p(pos.func_177982_a(0, k1, 0));
                    block = offset.func_177230_c();
                    if (!block.isAir(offset, (IBlockAccess)world, pos.func_177982_a(0, k1, 0)) && !block.isLeaves(offset, (IBlockAccess)world, pos.func_177982_a(0, k1, 0))) continue;
                    world.func_175656_a(pos.func_177982_a(0, k1, 0), this.blockLog.func_176223_P());
                }
                if (this.sapling.type == 3) {
                    world.func_175656_a(pos.func_177972_a(EnumFacing.DOWN), Blocks.field_150349_c.func_176223_P());
                }
                return true;
            }
            return false;
        }
        return false;
    }
}

