/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.enderRift.aggregation;

import gigaherz.enderRift.EnderRiftMod;
import gigaherz.enderRift.aggregation.BlockAggragator;
import gigaherz.enderRift.aggregation.TileAggregator;
import gigaherz.enderRift.aggregation.TileProxy;
import gigaherz.enderRift.automation.AutomationHelper;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockProxy
extends BlockAggragator<TileProxy> {
    public static final PropertyBool NORTH = PropertyBool.func_177716_a((String)"north");
    public static final PropertyBool SOUTH = PropertyBool.func_177716_a((String)"south");
    public static final PropertyBool WEST = PropertyBool.func_177716_a((String)"west");
    public static final PropertyBool EAST = PropertyBool.func_177716_a((String)"east");
    public static final PropertyBool UP = PropertyBool.func_177716_a((String)"up");
    public static final PropertyBool DOWN = PropertyBool.func_177716_a((String)"down");

    public BlockProxy(String name) {
        super(name, Material.field_151573_f, MapColor.field_151670_w);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149663_c("enderrift.blockProxy");
        this.func_149647_a(EnderRiftMod.tabEnderRift);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)UP, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DOWN, (Comparable)Boolean.valueOf(false)));
        this.func_149711_c(3.0f);
        this.func_149752_b(8.0f);
    }

    @Override
    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Override
    public TileProxy createTileEntity(World world, IBlockState state) {
        return new TileProxy();
    }

    @Deprecated
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    @Deprecated
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P();
    }

    @Deprecated
    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return state.func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(this.isConnectable(worldIn, pos, EnumFacing.NORTH))).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(this.isConnectable(worldIn, pos, EnumFacing.SOUTH))).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(this.isConnectable(worldIn, pos, EnumFacing.WEST))).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(this.isConnectable(worldIn, pos, EnumFacing.EAST))).func_177226_a((IProperty)UP, (Comparable)Boolean.valueOf(this.isConnectable(worldIn, pos, EnumFacing.UP))).func_177226_a((IProperty)DOWN, (Comparable)Boolean.valueOf(this.isConnectable(worldIn, pos, EnumFacing.DOWN)));
    }

    private boolean isConnectable(IBlockAccess worldIn, BlockPos pos, EnumFacing facing) {
        TileEntity te = worldIn.func_175625_s(pos.func_177972_a(facing));
        if (te instanceof TileAggregator) {
            return true;
        }
        return AutomationHelper.isAutomatable(te, facing.func_176734_d());
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{NORTH, SOUTH, WEST, EAST, UP, DOWN});
    }

    @Override
    @Deprecated
    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn) {
        super.func_189540_a(state, worldIn, pos, blockIn);
        TileEntity te = worldIn.func_175625_s(pos);
        if (te != null) {
            te.func_70296_d();
        }
    }

    @Override
    public void onNeighborChange(IBlockAccess world, BlockPos pos, BlockPos neighbor) {
        super.onNeighborChange(world, pos, neighbor);
        if (this.isUpdateSource(world, pos, this.fromNeighbour(pos, neighbor))) {
            ((TileProxy)world.func_175625_s(pos)).broadcastDirty();
        }
    }

    private boolean isUpdateSource(IBlockAccess worldIn, BlockPos pos, EnumFacing facing) {
        TileEntity te = worldIn.func_175625_s(pos.func_177972_a(facing));
        return AutomationHelper.isAutomatable(te, facing.func_176734_d());
    }

    private EnumFacing fromNeighbour(BlockPos a, BlockPos b) {
        BlockPos diff = b.func_177973_b((Vec3i)a);
        return EnumFacing.func_176737_a((float)diff.func_177958_n(), (float)diff.func_177956_o(), (float)diff.func_177952_p());
    }
}

