/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.enderRift.aggregation;

import com.google.common.collect.Lists;
import gigaherz.enderRift.automation.AutomationAggregator;
import gigaherz.enderRift.automation.AutomationHelper;
import gigaherz.enderRift.automation.IInventoryAutomation;
import gigaherz.graph.api.Graph;
import gigaherz.graph.api.GraphObject;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class TileAggregator
extends TileEntity
implements ITickable,
GraphObject {
    private Graph graph;
    private boolean firstUpdate = true;
    private final List<IInventoryAutomation> connectedInventories = Lists.newArrayList();

    @Override
    public Graph getGraph() {
        return this.graph;
    }

    @Override
    public void setGraph(Graph graph) {
        this.graph = graph;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    public void func_145829_t() {
        super.func_145829_t();
        if (!this.firstUpdate) {
            this.init();
        }
    }

    public void func_73660_a() {
        if (this.firstUpdate) {
            this.firstUpdate = false;
            this.init();
        }
    }

    private void init() {
        Graph.integrate(this, this.getNeighbours());
        this.updateConnectedInventories();
    }

    public void func_145843_s() {
        super.func_145843_s();
        Graph graph = this.getGraph();
        if (graph != null) {
            graph.remove(this);
        }
    }

    private List<GraphObject> getNeighbours() {
        ArrayList neighbours = Lists.newArrayList();
        for (EnumFacing f : EnumFacing.field_82609_l) {
            TileAggregator thingOther;
            TileEntity teOther = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(f));
            if (!(teOther instanceof TileAggregator) || (thingOther = (TileAggregator)teOther).getGraph() == null) continue;
            neighbours.add(thingOther);
        }
        return neighbours;
    }

    public void updateNeighbours() {
        Graph graph = this.getGraph();
        if (graph != null) {
            graph.addNeighours(this, this.getNeighbours());
        }
        this.updateConnectedInventories();
    }

    private void updateConnectedInventories() {
        this.connectedInventories.clear();
        for (EnumFacing f : EnumFacing.field_82609_l) {
            IInventoryAutomation auto;
            TileEntity teOther;
            if (!this.canConnectSide(f) || (teOther = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(f))) instanceof TileAggregator || !AutomationHelper.isAutomatable(teOther, f.func_176734_d()) || (auto = AutomationHelper.get(teOther, f.func_176734_d())) == null) continue;
            this.connectedInventories.add(auto);
        }
    }

    protected abstract boolean canConnectSide(EnumFacing var1);

    protected IInventoryAutomation getAutomation(Block selfBlock) {
        AutomationAggregator aggregator = new AutomationAggregator();
        IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        if (state.func_177230_c() != selfBlock) {
            return aggregator;
        }
        if (this.getGraph() == null) {
            return aggregator;
        }
        for (GraphObject object : this.getGraph().getObjects()) {
            if (!(object instanceof TileAggregator)) continue;
            TileAggregator proxy = (TileAggregator)object;
            aggregator.addAll(proxy.getConnectedInventories());
        }
        return aggregator;
    }

    public Iterable<IInventoryAutomation> getConnectedInventories() {
        return this.connectedInventories;
    }

    public void broadcastDirty() {
        if (this.getGraph() == null) {
            return;
        }
        for (GraphObject object : this.getGraph().getObjects()) {
            TileAggregator proxy;
            if (!(object instanceof TileAggregator) || (proxy = (TileAggregator)object).func_145837_r()) continue;
            proxy.func_70296_d();
        }
    }
}

