/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.enderRift.aggregation;

import gigaherz.enderRift.EnderRiftMod;
import gigaherz.enderRift.aggregation.BlockInterface;
import gigaherz.enderRift.aggregation.TileAggregator;
import gigaherz.enderRift.automation.IInventoryAutomation;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public class TileInterface
extends TileAggregator {
    static final int FilterCount = 9;
    FilterInventory filters = new FilterInventory(9);
    ItemStackHandler outputs = new ItemStackHandler(9){

        protected void onContentsChanged(int slot) {
            TileInterface.this.func_70296_d();
        }
    };
    EnumFacing facing = null;

    public EnumFacing getFacing() {
        IBlockState state;
        if (this.facing == null && this.field_145850_b != null && (state = this.field_145850_b.func_180495_p(this.field_174879_c)).func_177230_c() == EnderRiftMod.riftInterface) {
            this.facing = ((EnumFacing)state.func_177229_b((IProperty)BlockInterface.FACING)).func_176734_d();
        }
        return this.facing;
    }

    public IItemHandler inventoryOutputs() {
        return this.outputs;
    }

    public IItemHandler inventoryFilter() {
        return this.filters;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (facing == this.getFacing() && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (facing == this.getFacing() && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.outputs);
        }
        return (T)super.getCapability(capability, facing);
    }

    public IInventoryAutomation getAutomation() {
        return super.getAutomation(EnderRiftMod.riftInterface);
    }

    public void func_70296_d() {
        super.func_70296_d();
        this.facing = null;
    }

    @Override
    protected boolean canConnectSide(EnumFacing side) {
        return side == this.getFacing().func_176734_d();
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.getAutomation() == null) {
            return;
        }
        boolean anyChanged = false;
        for (int i = 0; i < 9; ++i) {
            int stackSize;
            ItemStack inFilter = this.filters.getStackInSlot(i);
            ItemStack inSlot = this.outputs.getStackInSlot(i);
            if (inFilter != null) {
                int free;
                if (inSlot == null) {
                    free = 64;
                    inSlot = this.getAutomation().extractItems(inFilter, free, false);
                    this.outputs.setStackInSlot(i, inSlot);
                    if (inSlot == null) continue;
                    anyChanged = true;
                    continue;
                }
                if (inSlot.func_77969_a(inFilter)) {
                    ItemStack extracted;
                    free = inSlot.func_77976_d() - inSlot.field_77994_a;
                    if (free <= 0 || (extracted = this.getAutomation().extractItems(inFilter, free, false)) == null) continue;
                    inSlot.field_77994_a += extracted.field_77994_a;
                    anyChanged = true;
                    continue;
                }
                stackSize = inSlot.field_77994_a;
                inSlot = this.getAutomation().insertItems(inSlot);
                this.outputs.setStackInSlot(i, inSlot);
                if (inSlot != null && stackSize == inSlot.field_77994_a) continue;
                anyChanged = true;
                continue;
            }
            if (inSlot == null) continue;
            stackSize = inSlot.field_77994_a;
            inSlot = this.getAutomation().insertItems(inSlot);
            this.outputs.setStackInSlot(i, inSlot);
            if (inSlot != null && stackSize == inSlot.field_77994_a) continue;
            anyChanged = true;
        }
        if (anyChanged) {
            this.func_70296_d();
        }
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        NBTTagList _filters = compound.func_150295_c("Filters", 10);
        for (int i = 0; i < _filters.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound = _filters.func_150305_b(i);
            int j = nbttagcompound.func_74771_c("Slot") & 0xFF;
            if (j < 0 || j >= this.filters.getSlots()) continue;
            this.filters.setStackInSlot(j, ItemStack.func_77949_a((NBTTagCompound)nbttagcompound));
        }
        NBTTagList _outputs = compound.func_150295_c("Outputs", 10);
        for (int i = 0; i < _outputs.func_74745_c(); ++i) {
            NBTTagCompound slot = _outputs.func_150305_b(i);
            int j = slot.func_74771_c("Slot") & 0xFF;
            if (j < 0 || j >= this.outputs.getSlots()) continue;
            this.outputs.setStackInSlot(j, ItemStack.func_77949_a((NBTTagCompound)slot));
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound = super.func_189515_b(compound);
        NBTTagList _filters = new NBTTagList();
        for (int i = 0; i < this.filters.getSlots(); ++i) {
            ItemStack stack = this.filters.getStackInSlot(i);
            if (stack == null) continue;
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74774_a("Slot", (byte)i);
            stack.func_77955_b(nbttagcompound);
            _filters.func_74742_a((NBTBase)nbttagcompound);
        }
        compound.func_74782_a("Filters", (NBTBase)_filters);
        NBTTagList _outputs = new NBTTagList();
        for (int i = 0; i < this.outputs.getSlots(); ++i) {
            ItemStack stack = this.outputs.getStackInSlot(i);
            if (stack == null) continue;
            NBTTagCompound slot = new NBTTagCompound();
            slot.func_74774_a("Slot", (byte)i);
            stack.func_77955_b(slot);
            _outputs.func_74742_a((NBTBase)slot);
        }
        compound.func_74782_a("Outputs", (NBTBase)_outputs);
        return compound;
    }

    public boolean isUseableByPlayer(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) == this && player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    class FilterInventory
    implements IItemHandlerModifiable {
        final ItemStack[] filters;

        public FilterInventory(int slotCount) {
            this.filters = new ItemStack[slotCount];
        }

        public int getSlots() {
            return 9;
        }

        public ItemStack getStackInSlot(int slot) {
            if (slot < 0 || slot >= this.filters.length) {
                return null;
            }
            return this.filters[slot];
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (slot < 0 || slot >= this.filters.length) {
                return stack;
            }
            if (!simulate) {
                this.filters[slot] = stack.func_77946_l();
                this.filters[slot].field_77994_a = 1;
            }
            return stack;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return null;
        }

        public void setStackInSlot(int index, ItemStack stack) {
            this.filters[index] = stack;
            if (stack != null && stack.field_77994_a > this.getInventoryStackLimit()) {
                stack.field_77994_a = this.getInventoryStackLimit();
            }
            TileInterface.this.func_70296_d();
        }

        public int getInventoryStackLimit() {
            return 1;
        }

        public void clear() {
            for (int i = 0; i < this.filters.length; ++i) {
                this.filters[i] = null;
            }
        }
    }
}

