/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.enderRift.automation;

import com.google.common.collect.Lists;
import gigaherz.enderRift.ConfigValues;
import gigaherz.enderRift.automation.IInventoryAutomation;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;

public class AutomationAggregator
implements IInventoryAutomation {
    final List<IInventoryAutomation> aggregated = Lists.newArrayList();

    public void addAll(Iterable<IInventoryAutomation> inventorySet) {
        for (IInventoryAutomation value : inventorySet) {
            this.add(value);
        }
    }

    public void add(IInventoryAutomation inv) {
        this.aggregated.add(inv);
    }

    @Override
    public int getSlots() {
        int sum = 0;
        for (IInventoryAutomation inv : this.aggregated) {
            sum += inv.getSlots();
        }
        return sum;
    }

    @Override
    public ItemStack getStackInSlot(int index) {
        for (IInventoryAutomation inv : this.aggregated) {
            int size = inv.getSlots();
            if (index < size) {
                return inv.getStackInSlot(index);
            }
            index -= size;
        }
        return null;
    }

    @Override
    public ItemStack insertItems(@Nonnull ItemStack stack) {
        IInventoryAutomation inv;
        int i;
        ItemStack remaining = stack.func_77946_l();
        if (ConfigValues.PreferContainersWithExistingStacks) {
            for (i = 0; i < this.aggregated.size(); ++i) {
                inv = this.aggregated.get(i);
                for (int j = 0; j < inv.getSlots(); ++j) {
                    ItemStack existing = inv.getStackInSlot(j);
                    if (!ItemStack.func_179545_c((ItemStack)stack, (ItemStack)existing) || !ItemStack.func_77970_a((ItemStack)stack, (ItemStack)existing)) continue;
                    remaining = inv.insertItems(remaining);
                    break;
                }
                if (remaining != null) continue;
                return null;
            }
        }
        for (i = 0; i < this.aggregated.size(); ++i) {
            inv = this.aggregated.get(i);
            remaining = inv.insertItems(remaining);
            if (remaining != null) continue;
            return null;
        }
        return remaining;
    }

    @Override
    public ItemStack extractItems(@Nonnull ItemStack stack, int wanted, boolean simulate) {
        wanted = Math.min(wanted, stack.func_77976_d());
        ItemStack extracted = null;
        for (int i = 0; i < this.aggregated.size(); ++i) {
            IInventoryAutomation inv = this.aggregated.get(i);
            ItemStack obtained = inv.extractItems(stack, wanted, simulate);
            if (obtained == null) continue;
            if (extracted == null) {
                extracted = obtained.func_77946_l();
            } else {
                extracted.field_77994_a += obtained.field_77994_a;
            }
            if ((wanted -= obtained.field_77994_a) <= 0) break;
        }
        return extracted;
    }
}

