/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.enderRift.automation;

import gigaherz.enderRift.EnderRiftMod;
import gigaherz.enderRift.automation.CapabilityAutomation;
import gigaherz.enderRift.automation.IInventoryAutomation;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public abstract class AutomationHelper
implements IInventoryAutomation {
    public static IInventoryAutomation get(Object object, EnumFacing facing) {
        if (!(object instanceof ICapabilityProvider)) {
            return null;
        }
        ICapabilityProvider cap = (ICapabilityProvider)object;
        if (cap.hasCapability(CapabilityAutomation.INSTANCE, facing)) {
            return (IInventoryAutomation)cap.getCapability(CapabilityAutomation.INSTANCE, facing);
        }
        if (cap.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing)) {
            return new ItemHandlerWrapper((IItemHandler)cap.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing));
        }
        return null;
    }

    public static boolean isAutomatable(Object object, EnumFacing facing) {
        if (!(object instanceof ICapabilityProvider)) {
            return false;
        }
        ICapabilityProvider cap = (ICapabilityProvider)object;
        return cap.hasCapability(CapabilityAutomation.INSTANCE, facing) || cap.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing);
    }

    private static class ItemHandlerWrapper
    extends AutomationHelper {
        IItemHandler parent;

        private ItemHandlerWrapper(IItemHandler parent) {
            this.parent = parent;
        }

        @Override
        public int getSlots() {
            return this.parent.getSlots();
        }

        @Override
        public ItemStack getStackInSlot(int index) {
            return this.parent.getStackInSlot(index);
        }

        @Override
        public ItemStack insertItems(@Nonnull ItemStack stack) {
            ItemStack remaining = stack.func_77946_l();
            for (int i = 0; i < this.parent.getSlots() && (remaining = this.parent.insertItem(i, remaining, false)) != null && remaining.field_77994_a > 0; ++i) {
            }
            if (remaining != null && remaining.field_77994_a > 0) {
                return remaining;
            }
            return null;
        }

        @Override
        public ItemStack extractItems(@Nonnull ItemStack stack, int wanted, boolean simulate) {
            if (stack.field_77994_a <= 0 || wanted <= 0) {
                return null;
            }
            ItemStack extracted = stack.func_77946_l();
            extracted.field_77994_a = 0;
            for (int i = 0; i < this.parent.getSlots(); ++i) {
                int requested;
                ItemStack slot = this.parent.getStackInSlot(i);
                if (slot == null || (requested = Math.min(wanted, slot.field_77994_a)) <= 0 || !ItemStack.func_179545_c((ItemStack)slot, (ItemStack)stack) || !ItemStack.func_77970_a((ItemStack)slot, (ItemStack)stack)) continue;
                ItemStack obtained = this.parent.extractItem(i, requested, simulate);
                if (obtained != null && !simulate) {
                    int remaining = slot.field_77994_a - obtained.field_77994_a;
                    int found = 0;
                    slot = this.parent.getStackInSlot(i);
                    if (slot != null) {
                        found = slot.field_77994_a;
                    }
                    if (found != remaining) {
                        EnderRiftMod.logger.warn("DAFUQ, Found an incorrect number of items in the slot " + i + " after extraction! Found: " + found + " expected " + remaining);
                    }
                }
                int returned = obtained != null ? obtained.field_77994_a : 0;
                extracted.field_77994_a += returned;
                if ((wanted -= returned) <= 0) break;
            }
            if (extracted.field_77994_a <= 0) {
                return null;
            }
            return extracted;
        }
    }
}

