/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.enderRift.client;

import com.google.common.base.Function;
import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.crash.CrashReport;
import net.minecraft.util.ReportedException;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.pipeline.LightUtil;

public class RenderingStuffs {
    static Map<String, IBakedModel> loadedModels = Maps.newHashMap();

    public static void init() {
        IResourceManager rm = Minecraft.func_71410_x().func_110442_L();
        if (rm instanceof IReloadableResourceManager) {
            ((IReloadableResourceManager)rm).func_110542_a(new IResourceManagerReloadListener(){

                public void func_110549_a(IResourceManager ignored) {
                    loadedModels.clear();
                }
            });
        }
    }

    public static void renderModel(IBakedModel model, int color) {
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_176599_b);
        for (BakedQuad bakedquad : model.func_188616_a(null, null, 0L)) {
            LightUtil.renderQuadColor((VertexBuffer)buffer, (BakedQuad)bakedquad, (int)color);
        }
        tessellator.func_78381_a();
    }

    public static IBakedModel loadModel(String resourceName) {
        IBakedModel model = loadedModels.get(resourceName);
        if (model != null) {
            return model;
        }
        try {
            final TextureMap textures = Minecraft.func_71410_x().func_147117_R();
            IModel mod = ModelLoaderRegistry.getModel((ResourceLocation)new ResourceLocation(resourceName));
            model = mod.bake(mod.getDefaultState(), DefaultVertexFormats.field_176599_b, (Function)new Function<ResourceLocation, TextureAtlasSprite>(){

                @Nullable
                public TextureAtlasSprite apply(@Nullable ResourceLocation location) {
                    if (location == null) {
                        return null;
                    }
                    return textures.func_110572_b(location.toString());
                }
            });
            return model;
        }
        catch (Exception e) {
            throw new ReportedException(new CrashReport("Error loading custom model " + resourceName, (Throwable)e));
        }
    }
}

