/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.enderRift.generator;

import gigaherz.capabilities.api.energy.CapabilityEnergy;
import gigaherz.capabilities.api.energy.EnergyBuffer;
import gigaherz.capabilities.api.energy.IEnergyHandler;
import gigaherz.enderRift.compatibility.tesla.TeslaControllerBase;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileGenerator
extends TileEntity
implements ITickable {
    public static final int SlotCount = 1;
    public static final int PowerLimit = 100000;
    public static final int MinHeat = 100;
    public static final int MaxHeat = 1000;
    public static final int PowerGenMin = 20;
    public static final int PowerGenMax = 200;
    public static final int HeatInterval = 20;
    public static final int PowerTransferMax = 800;
    final ItemStackHandler fuelSlot = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            TileGenerator.this.func_70296_d();
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (TileEntityFurnace.func_145952_a((ItemStack)stack) <= 0) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }
    };
    int heatLevel;
    int burnTimeRemaining;
    int currentItemBurnTime;
    int timeInterval;
    EnergyBuffer energyCapability = new EnergyBuffer(100000);
    private Capability teslaProducerCap = TeslaControllerBase.PRODUCER.getCapability();
    private Object teslaProducerInstance = TeslaControllerBase.PRODUCER.createInstance(this.energyCapability);
    private Capability teslaHolderCap = TeslaControllerBase.HOLDER.getCapability();
    private Object teslaHolderInstance = TeslaControllerBase.HOLDER.createInstance(this.energyCapability);

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY_HANDLER_CAPABILITY) {
            return true;
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        if (this.teslaProducerCap != null && capability == this.teslaProducerCap) {
            return true;
        }
        if (this.teslaHolderCap != null && capability == this.teslaHolderCap) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY_HANDLER_CAPABILITY) {
            return (T)CapabilityEnergy.ENERGY_HANDLER_CAPABILITY.cast((Object)this.energyCapability);
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.fuelSlot);
        }
        if (this.teslaProducerCap != null && capability == this.teslaProducerCap) {
            return (T)this.teslaProducerInstance;
        }
        if (this.teslaHolderCap != null && capability == this.teslaHolderCap) {
            return (T)this.teslaHolderInstance;
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        boolean anyChanged = this.updateGeneration();
        if (anyChanged |= this.transferPower()) {
            this.func_70296_d();
        }
    }

    private boolean updateGeneration() {
        ItemStack stack;
        boolean anyChanged = false;
        int minHeatLevel = 0;
        int heatInterval = 20;
        if (this.field_145850_b.func_180495_p(this.field_174879_c.func_177977_b()).func_177230_c() == Blocks.field_150353_l && this.heatLevel < (minHeatLevel = 99)) {
            heatInterval = Math.max(1, heatInterval / 2);
        }
        if (this.timeInterval < 20) {
            ++this.timeInterval;
        }
        if (this.burnTimeRemaining > 0) {
            this.burnTimeRemaining -= Math.max(1, this.heatLevel / 100);
            if (this.burnTimeRemaining <= 0) {
                this.timeInterval = 0;
            }
            if (this.timeInterval >= heatInterval && this.heatLevel < 1000) {
                this.timeInterval = 0;
                ++this.heatLevel;
                anyChanged = true;
            }
        } else if (this.heatLevel > minHeatLevel) {
            if (this.timeInterval >= 20) {
                this.timeInterval = 0;
                --this.heatLevel;
                anyChanged = true;
            }
        } else if (minHeatLevel > 0 && this.heatLevel < minHeatLevel && this.timeInterval >= 20) {
            this.timeInterval = 0;
            ++this.heatLevel;
            anyChanged = true;
        }
        if (this.heatLevel >= 100 && this.energyCapability.getEnergy() < 100000) {
            int powerGen = this.getGenerationPower();
            this.energyCapability.setEnergy(Math.min(this.energyCapability.getEnergy() + powerGen, 100000));
            anyChanged = true;
        }
        if (this.burnTimeRemaining <= 0 && this.energyCapability.getEnergy() < 100000 && (stack = this.fuelSlot.getStackInSlot(0)) != null) {
            this.currentItemBurnTime = this.burnTimeRemaining = TileEntityFurnace.func_145952_a((ItemStack)this.fuelSlot.getStackInSlot(0));
            this.timeInterval = 0;
            --stack.field_77994_a;
            if (stack.field_77994_a <= 0) {
                this.fuelSlot.setStackInSlot(0, stack.func_77973_b().getContainerItem(stack));
            }
            anyChanged = true;
        }
        return anyChanged;
    }

    private boolean transferPower() {
        boolean anyChanged = false;
        int sendPower = Math.min(800, this.energyCapability.getEnergy());
        if (sendPower > 0) {
            IEnergyHandler[] handlers = new IEnergyHandler[6];
            int[] wantedSide = new int[6];
            int accepted = 0;
            for (EnumFacing neighbor : EnumFacing.field_82609_l) {
                int wanted;
                IEnergyHandler handler;
                TileEntity e = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(neighbor));
                EnumFacing from = neighbor.func_176734_d();
                if (e == null || (handler = e.hasCapability(CapabilityEnergy.ENERGY_HANDLER_CAPABILITY, from) ? (IEnergyHandler)e.getCapability(CapabilityEnergy.ENERGY_HANDLER_CAPABILITY, from) : TeslaControllerBase.CONSUMER.wrapReverse(e, from)) == null) continue;
                handlers[from.ordinal()] = handler;
                wantedSide[from.ordinal()] = wanted = handler.insertEnergy(sendPower, true);
                accepted += wanted;
            }
            if (accepted > 0) {
                for (EnumFacing from : EnumFacing.field_82609_l) {
                    IEnergyHandler handler = handlers[from.ordinal()];
                    int wanted = wantedSide[from.ordinal()];
                    if (handler == null || wanted == 0) continue;
                    int given = Math.min(Math.min(this.energyCapability.getEnergy(), wanted), wanted * accepted / sendPower);
                    int received = Math.min(given, handler.insertEnergy(given, false));
                    this.energyCapability.setEnergy(this.energyCapability.getEnergy() - received);
                    if (this.energyCapability.getEnergy() <= 0) break;
                }
                anyChanged = true;
            }
        }
        return anyChanged;
    }

    public String getName() {
        return "container.enderrift.generator";
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.heatLevel = compound.func_74762_e("heatLevel");
        this.burnTimeRemaining = compound.func_74762_e("burnTimeRemaining");
        this.currentItemBurnTime = compound.func_74762_e("currentItemBurnTime");
        this.timeInterval = compound.func_74762_e("timeInterval");
        CapabilityEnergy.ENERGY_HANDLER_CAPABILITY.readNBT((Object)this.energyCapability, null, (NBTBase)compound.func_74775_l("storedEnergy"));
        CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.readNBT((Object)this.fuelSlot, null, (NBTBase)compound.func_150295_c("fuelSlot", 10));
        if (compound.func_150297_b("powerLevel", 3)) {
            this.energyCapability.insertEnergy(compound.func_74762_e("powerLevel"), false);
        }
        if (compound.func_150297_b("Items", 9)) {
            NBTTagList _outputs = compound.func_150295_c("Items", 10);
            for (int i = 0; i < _outputs.func_74745_c(); ++i) {
                NBTTagCompound nbttagcompound = _outputs.func_150305_b(i);
                int j = nbttagcompound.func_74771_c("Slot") & 0xFF;
                if (j < 0 || j >= this.fuelSlot.getSlots()) continue;
                this.fuelSlot.setStackInSlot(j, ItemStack.func_77949_a((NBTTagCompound)nbttagcompound));
            }
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound = super.func_189515_b(compound);
        compound.func_74768_a("heatLevel", this.heatLevel);
        compound.func_74768_a("burnTimeRemaining", this.burnTimeRemaining);
        compound.func_74768_a("currentItemBurnTime", this.currentItemBurnTime);
        compound.func_74768_a("timeInterval", this.timeInterval);
        compound.func_74782_a("storedEnergy", CapabilityEnergy.ENERGY_HANDLER_CAPABILITY.writeNBT((Object)this.energyCapability, null));
        compound.func_74782_a("fuelSlot", CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.writeNBT((Object)this.fuelSlot, null));
        return compound;
    }

    public boolean isUseableByPlayer(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) == this && player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public int[] getFields() {
        return new int[]{this.burnTimeRemaining, this.currentItemBurnTime, this.energyCapability.getEnergy(), this.heatLevel};
    }

    public void setFields(int[] values) {
        this.burnTimeRemaining = values[0];
        this.currentItemBurnTime = values[1];
        this.energyCapability.setEnergy(values[2]);
        this.heatLevel = values[3];
        this.func_70296_d();
    }

    public boolean isBurning() {
        return this.burnTimeRemaining > 0;
    }

    public int getHeatValue() {
        return this.heatLevel;
    }

    public int getGenerationPower() {
        if (this.heatLevel < 100) {
            return 0;
        }
        return Math.max(0, Math.round(20.0f + (float)(180 * (this.heatLevel - 100)) / 900.0f));
    }

    public int getContainedEnergy() {
        return this.energyCapability.getEnergy();
    }

    public IItemHandler inventory() {
        return this.fuelSlot;
    }

    public int getCurrentItemBurnTime() {
        return this.currentItemBurnTime;
    }

    public int getBurnTimeRemaining() {
        return this.burnTimeRemaining;
    }
}

