/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.enderRift.gui;

import com.google.common.collect.Lists;
import gigaherz.enderRift.EnderRiftMod;
import gigaherz.enderRift.aggregation.TileBrowser;
import gigaherz.enderRift.automation.IInventoryAutomation;
import gigaherz.enderRift.gui.slots.SlotFake;
import gigaherz.enderRift.misc.SortMode;
import gigaherz.enderRift.network.SendSlotChanges;
import gigaherz.enderRift.network.SetVisibleSlots;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketSetSlot;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.apache.commons.lang3.StringUtils;

public class ContainerBrowser
extends Container {
    public final FakeInventoryClient fakeInventoryClient;
    public final FakeInventoryServer fakeInventoryServer;
    protected TileBrowser tile;
    private int prevChangeCount;
    public int scroll;
    public SortMode sortMode = SortMode.StackSize;
    private String filterText = "";
    private ItemStack stackInCursor;
    private EntityPlayer player;
    private ItemStack[] currentStacks = new ItemStack[0];
    protected static final int Left = 8;
    protected static final int Top = 18;
    protected static final int SlotWidth = 18;
    protected static final int SlotHeight = 18;
    protected static final int FakeRows = 3;
    protected static final int FakeColumns = 9;
    protected static final int FakeSlots = 27;
    protected static final int PlayerRows = 4;
    protected static final int PlayerColumns = 9;
    protected static final int PlayerSlots = 36;

    public ContainerBrowser(TileBrowser tileEntity, EntityPlayer player, boolean isClient) {
        Object fake;
        this.tile = tileEntity;
        this.player = player;
        if (isClient) {
            this.fakeInventoryClient = new FakeInventoryClient();
            this.fakeInventoryServer = null;
            fake = this.fakeInventoryClient;
        } else {
            this.fakeInventoryClient = null;
            this.fakeInventoryServer = new FakeInventoryServer();
            fake = this.fakeInventoryServer;
        }
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.func_75146_a((Slot)new SlotFake((IItemHandler)fake, x + y * 9, 8 + x * 18, 18 + y * 18));
            }
        }
        this.bindPlayerInventory(player.field_71071_by);
    }

    protected void bindPlayerInventory(InventoryPlayer playerInventory) {
        this.bindPlayerInventory(playerInventory, 86);
    }

    protected void bindPlayerInventory(InventoryPlayer playerInventory, int top) {
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.func_75146_a(new Slot((IInventory)playerInventory, x + y * 9 + 9, 8 + x * 18, top + y * 18));
            }
        }
        top += 58;
        for (int x = 0; x < 9; ++x) {
            this.func_75146_a(new Slot((IInventory)playerInventory, x, 8 + x * 18, top));
        }
    }

    public boolean func_75145_c(EntityPlayer player) {
        return true;
    }

    public void func_75142_b() {
        int i;
        if (this.tile.func_145831_w().field_72995_K) {
            return;
        }
        if (this.prevChangeCount != this.tile.getChangeCount()) {
            this.fakeInventoryServer.refresh();
            this.prevChangeCount = this.tile.getChangeCount();
        }
        int oldLength = this.currentStacks.length;
        ArrayList indicesChanged = Lists.newArrayList();
        ArrayList stacksChanged = Lists.newArrayList();
        FakeInventoryServer serverInv = this.fakeInventoryServer;
        int newLength = serverInv.getRealSizeInventory();
        if (newLength != oldLength) {
            this.currentStacks = Arrays.copyOf(this.currentStacks, newLength);
        }
        for (i = 0; i < newLength; ++i) {
            ItemStack current = this.currentStacks[i];
            ItemStack newStack = serverInv.getStack(i);
            if (ItemStack.func_77989_b((ItemStack)current, (ItemStack)newStack)) continue;
            this.currentStacks[i] = current = newStack == null ? null : newStack.func_77946_l();
            indicesChanged.add(i);
            stacksChanged.add(current);
        }
        for (i = 27; i < this.field_75151_b.size(); ++i) {
            ItemStack inSlot = ((Slot)this.field_75151_b.get(i)).func_75211_c();
            ItemStack inCache = (ItemStack)this.field_75153_a.get(i);
            if (ItemStack.func_77989_b((ItemStack)inCache, (ItemStack)inSlot)) continue;
            inCache = inSlot == null ? null : inSlot.func_77946_l();
            this.field_75153_a.set(i, inCache);
            for (IContainerListener crafter : this.field_75149_d) {
                crafter.func_71111_a((Container)this, i, inCache);
            }
        }
        for (IContainerListener crafter : this.field_75149_d) {
            if (!(crafter instanceof EntityPlayerMP)) continue;
            if (newLength != oldLength || indicesChanged.size() > 0) {
                EnderRiftMod.channel.sendTo((IMessage)new SendSlotChanges(this.field_75152_c, newLength, indicesChanged, stacksChanged), (EntityPlayerMP)crafter);
            }
            EntityPlayerMP player = (EntityPlayerMP)crafter;
            ItemStack newStack = player.field_71071_by.func_70445_o();
            if (ItemStack.func_77989_b((ItemStack)this.stackInCursor, (ItemStack)newStack)) continue;
            this.sendStackInCursor(player, newStack);
        }
    }

    private void sendStackInCursor(EntityPlayerMP player, ItemStack newStack) {
        this.stackInCursor = newStack == null ? null : newStack.func_77946_l();
        player.field_71135_a.func_147359_a((Packet)new SPacketSetSlot(-1, -1, newStack));
    }

    public void slotsChanged(int slotCount, List<Integer> indices, List<ItemStack> stacks) {
        if (slotCount != this.currentStacks.length) {
            this.currentStacks = Arrays.copyOf(this.currentStacks, slotCount);
        }
        for (int i = 0; i < indices.size(); ++i) {
            ItemStack stack;
            int slot = indices.get(i);
            this.currentStacks[slot] = stack = stacks.get(i);
        }
        this.fakeInventoryClient.setArray(this.currentStacks);
        this.setVisibleSlots(this.fakeInventoryClient.getIndices());
    }

    public void func_75131_a(ItemStack[] p_75131_1_) {
    }

    public void setVisibleSlots(int[] visible) {
        if (this.tile.func_145831_w().field_72995_K) {
            EnderRiftMod.channel.sendToServer((IMessage)new SetVisibleSlots(this.field_75152_c, visible));
        } else {
            this.fakeInventoryServer.setVisible(visible);
        }
    }

    public void setScrollPos(int scroll) {
        this.scroll = scroll;
        this.setVisibleSlots(this.fakeInventoryClient.getIndices());
    }

    public void setSortMode(SortMode sortMode) {
        this.sortMode = sortMode;
        this.scroll = 0;
        this.fakeInventoryClient.setArray(this.currentStacks);
        this.setVisibleSlots(this.fakeInventoryClient.getIndices());
    }

    public void setFilterText(String text) {
        this.filterText = text.toLowerCase();
        this.scroll = 0;
        this.fakeInventoryClient.setArray(this.currentStacks);
        this.setVisibleSlots(this.fakeInventoryClient.getIndices());
    }

    public void func_75141_a(int slotID, ItemStack stack) {
        super.func_75141_a(slotID, stack);
    }

    public ItemStack func_184996_a(int slotId, int clickedButton, ClickType mode, EntityPlayer playerIn) {
        InventoryPlayer inventoryPlayer = playerIn.field_71071_by;
        if (slotId >= 0 && slotId < 27) {
            IInventoryAutomation parent = this.tile.getAutomation();
            if (parent == null) {
                return null;
            }
            Slot slot = (Slot)this.field_75151_b.get(slotId);
            ItemStack existing = slot.func_75211_c();
            if (mode == ClickType.PICKUP) {
                ItemStack dropping = inventoryPlayer.func_70445_o();
                if (dropping != null) {
                    if (clickedButton == 0) {
                        ItemStack remaining = parent.insertItems(dropping);
                        if (remaining != null) {
                            if (dropping.field_77994_a != remaining.field_77994_a) {
                                this.tile.func_70296_d();
                            }
                            for (IContainerListener crafter : this.field_75149_d) {
                                if (!(crafter instanceof EntityPlayerMP)) continue;
                                this.sendStackInCursor((EntityPlayerMP)crafter, remaining);
                            }
                        } else {
                            this.tile.func_70296_d();
                        }
                        inventoryPlayer.func_70437_b(remaining);
                    } else {
                        int amount = 1;
                        ItemStack push = dropping.func_77946_l();
                        push.field_77994_a = amount;
                        ItemStack remaining = parent.insertItems(push);
                        dropping.field_77994_a -= push.field_77994_a;
                        if (remaining != null) {
                            if (push.field_77994_a != remaining.field_77994_a) {
                                this.tile.func_70296_d();
                            }
                            dropping.field_77994_a += remaining.field_77994_a;
                            for (IContainerListener crafter : this.field_75149_d) {
                                if (!(crafter instanceof EntityPlayerMP)) continue;
                                this.sendStackInCursor((EntityPlayerMP)crafter, remaining);
                            }
                        } else {
                            this.tile.func_70296_d();
                        }
                        if (dropping.field_77994_a <= 0) {
                            dropping = null;
                        }
                        inventoryPlayer.func_70437_b(dropping);
                    }
                } else if (existing != null) {
                    int amount = clickedButton == 0 ? existing.func_77976_d() : existing.func_77976_d() / 2;
                    ItemStack extracted = parent.extractItems(existing, amount, false);
                    if (extracted != null) {
                        this.tile.func_70296_d();
                    } else {
                        for (IContainerListener crafter : this.field_75149_d) {
                            if (!(crafter instanceof EntityPlayerMP)) continue;
                            this.sendStackInCursor((EntityPlayerMP)crafter, extracted);
                        }
                    }
                    inventoryPlayer.func_70437_b(extracted);
                }
                this.func_75142_b();
                return slot.func_75211_c();
            }
            if (mode == ClickType.QUICK_MOVE && existing != null) {
                ItemStack finalExtract;
                int amount = existing.func_77976_d();
                if (clickedButton != 0 && amount > 1) {
                    amount /= 2;
                }
                if (amount == 0) {
                    return null;
                }
                ItemStack remaining = this.simulateAddToPlayer(existing, amount);
                if (remaining != null) {
                    amount -= remaining.field_77994_a;
                }
                if (amount > 0 && (finalExtract = parent.extractItems(existing, amount, false)) != null) {
                    this.addToPlayer(finalExtract);
                    this.tile.func_70296_d();
                    this.func_75142_b();
                }
            }
            if (mode != ClickType.CLONE) {
                return null;
            }
        }
        return super.func_184996_a(slotId, clickedButton, mode, playerIn);
    }

    public ItemStack simulateAddToPlayer(ItemStack stack, int amount) {
        int startIndex = 27;
        int endIndex = startIndex + 36;
        ItemStack stackCopy = stack.func_77946_l();
        stackCopy.field_77994_a = amount;
        if (!this.simulateInsertStack(stackCopy, startIndex, endIndex)) {
            return stackCopy;
        }
        if (stackCopy.field_77994_a <= 0) {
            return null;
        }
        return stackCopy;
    }

    protected boolean simulateInsertStack(ItemStack stack, int startIndex, int endIndex) {
        ItemStack stackInSlot;
        Slot slot;
        int i;
        boolean canInsert = false;
        if (stack.func_77985_e()) {
            for (i = startIndex; stack.field_77994_a > 0 && i < endIndex; ++i) {
                slot = (Slot)this.field_75151_b.get(i);
                stackInSlot = slot.func_75211_c();
                if (stackInSlot == null || stackInSlot.field_77994_a >= stackInSlot.func_77976_d() || !ItemStack.func_179545_c((ItemStack)stackInSlot, (ItemStack)stack) || !ItemStack.func_77970_a((ItemStack)stack, (ItemStack)stackInSlot)) continue;
                int j = stackInSlot.field_77994_a + stack.field_77994_a;
                if (j <= stack.func_77976_d()) {
                    stack.field_77994_a = 0;
                    canInsert = true;
                    continue;
                }
                stack.field_77994_a -= stack.func_77976_d() - stackInSlot.field_77994_a;
                canInsert = true;
            }
        }
        if (stack.field_77994_a > 0) {
            for (i = startIndex; i < endIndex; ++i) {
                slot = (Slot)this.field_75151_b.get(i);
                stackInSlot = slot.func_75211_c();
                if (stackInSlot != null || !slot.func_75214_a(stack)) continue;
                stack.field_77994_a = 0;
                canInsert = true;
                break;
            }
        }
        return canInsert;
    }

    public ItemStack addToPlayer(ItemStack stack) {
        int startIndex = 27;
        int endIndex = startIndex + 36;
        ItemStack stackCopy = stack.func_77946_l();
        if (!this.func_75135_a(stackCopy, startIndex, endIndex, false)) {
            return stackCopy;
        }
        if (stackCopy.field_77994_a <= 0) {
            return null;
        }
        return stackCopy;
    }

    public ItemStack func_82846_b(EntityPlayer player, int slotIndex) {
        Slot slot = (Slot)this.field_75151_b.get(slotIndex);
        if (slot == null || !slot.func_75216_d()) {
            return null;
        }
        if (slotIndex < 27) {
            return null;
        }
        IInventoryAutomation parent = this.tile.getAutomation();
        if (parent == null) {
            return null;
        }
        ItemStack stack = slot.func_75211_c();
        ItemStack stackCopy = stack.func_77946_l();
        ItemStack remaining = parent.insertItems(stack);
        if (remaining != null) {
            if (remaining.field_77994_a == stackCopy.field_77994_a) {
                return null;
            }
            this.tile.func_70296_d();
            stack.field_77994_a = remaining.field_77994_a;
            slot.func_75218_e();
        } else {
            this.tile.func_70296_d();
            stack.field_77994_a = 0;
            slot.func_75215_d(null);
        }
        slot.func_82870_a(player, stack);
        return stackCopy;
    }

    public int getActualSlotCount() {
        return this.fakeInventoryClient.getSlots();
    }

    public class FakeInventoryClient
    implements IItemHandlerModifiable {
        private int[] indices;
        private ItemStack[] stacks;

        public void setArray(ItemStack[] stacks) {
            this.stacks = stacks;
            ArrayList indices = Lists.newArrayList();
            ArrayList itemData = Lists.newArrayList();
            int indexx = 0;
            for (ItemStack invStack : stacks) {
                ItemStack stack = invStack.func_77946_l();
                boolean matchesSearch = true;
                if (ContainerBrowser.this.filterText != null && ContainerBrowser.this.filterText.length() > 0) {
                    itemData.clear();
                    Item item = invStack.func_77973_b();
                    itemData.add(stack.func_82833_r());
                    itemData.add(((ResourceLocation)Item.field_150901_e.func_177774_c((Object)item)).toString());
                    item.func_77624_a(stack, ContainerBrowser.this.player, (List)itemData, false);
                    matchesSearch = false;
                    for (String s : itemData) {
                        if (!StringUtils.containsIgnoreCase((CharSequence)s, (CharSequence)ContainerBrowser.this.filterText)) continue;
                        matchesSearch = true;
                        break;
                    }
                }
                if (matchesSearch) {
                    indices.add(indexx);
                }
                ++indexx;
            }
            if (ContainerBrowser.this.sortMode != null) {
                switch (ContainerBrowser.this.sortMode) {
                    case Alphabetic: {
                        indices.sort((ia, ib) -> {
                            ItemStack a = stacks[ia];
                            ItemStack b = stacks[ib];
                            return a.func_82833_r().compareToIgnoreCase(b.func_82833_r());
                        });
                        break;
                    }
                    case StackSize: {
                        indices.sort((ia, ib) -> {
                            ItemStack a = stacks[ia];
                            ItemStack b = stacks[ib];
                            int diff = a.field_77994_a - b.field_77994_a;
                            if (diff > 0) {
                                return -1;
                            }
                            if (diff < 0) {
                                return 1;
                            }
                            return a.func_82833_r().compareToIgnoreCase(b.func_82833_r());
                        });
                    }
                }
            }
            this.indices = new int[indices.size()];
            for (int i = 0; i < this.indices.length; ++i) {
                this.indices[i] = (Integer)indices.get(i);
            }
        }

        public int getSlots() {
            return this.indices.length;
        }

        public ItemStack getStackInSlot(int slot) {
            if (slot + ContainerBrowser.this.scroll >= this.indices.length) {
                return null;
            }
            ItemStack stack = this.stacks[this.indices[slot + ContainerBrowser.this.scroll]];
            if (stack != null) {
                stack = stack.func_77946_l();
                stack.field_77994_a = 1;
            }
            return stack;
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            return null;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return null;
        }

        public void setStackInSlot(int slot, ItemStack stack) {
            if (slot + ContainerBrowser.this.scroll < this.indices.length) {
                this.stacks[this.indices[slot + ContainerBrowser.this.scroll]] = stack;
            }
        }

        public int getStackSizeForSlot(int slot) {
            if (slot + ContainerBrowser.this.scroll >= this.indices.length) {
                return 0;
            }
            return this.stacks[this.indices[slot + ContainerBrowser.this.scroll]].field_77994_a;
        }

        public int[] getIndices() {
            int from = Math.max(0, Math.min(ContainerBrowser.this.scroll, this.indices.length - 1));
            int to = Math.min(from + 27, this.indices.length);
            return Arrays.copyOfRange(this.indices, from, to);
        }
    }

    public class FakeInventoryServer
    implements IItemHandlerModifiable {
        final List<ItemStack> slots = Lists.newArrayList();
        private int[] visible = new int[0];

        public void setVisible(int[] visible) {
            this.visible = visible;
        }

        public void refresh() {
            IInventoryAutomation inv = ContainerBrowser.this.tile.getAutomation();
            ArrayList slotsSeen = Lists.newArrayList();
            this.slots.clear();
            this.visible = new int[0];
            if (inv == null) {
                return;
            }
            int invSlots = inv.getSlots();
            for (int j = 0; j < invSlots; ++j) {
                ItemStack invStack = inv.getStackInSlot(j);
                if (invStack == null) continue;
                boolean found = false;
                for (ItemStack cachedStack : slotsSeen) {
                    if (!ItemStack.func_179545_c((ItemStack)cachedStack, (ItemStack)invStack) || !ItemStack.func_77970_a((ItemStack)cachedStack, (ItemStack)invStack)) continue;
                    cachedStack.field_77994_a += invStack.field_77994_a;
                    found = true;
                    break;
                }
                if (found) continue;
                ItemStack stack = invStack.func_77946_l();
                slotsSeen.add(stack);
                this.slots.add(stack);
            }
        }

        public int getRealSizeInventory() {
            return this.slots.size();
        }

        public int getSlots() {
            return this.visible.length;
        }

        public ItemStack getStackInSlot(int index) {
            if (index >= this.visible.length) {
                return null;
            }
            return this.slots.get(this.visible[index]);
        }

        public ItemStack getStack(int index) {
            return this.slots.get(index);
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            return null;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return null;
        }

        public void setStackInSlot(int slot, ItemStack stack) {
        }
    }
}

