/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.enderRift.gui;

import gigaherz.enderRift.aggregation.TileBrowser;
import gigaherz.enderRift.gui.ContainerBrowser;
import gigaherz.enderRift.misc.SortMode;
import java.io.IOException;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class GuiBrowser
extends GuiContainer {
    private static final ResourceLocation backgroundTexture = new ResourceLocation("enderrift", "textures/gui/browser.png");
    private static final ResourceLocation tabsTexture = new ResourceLocation("minecraft:textures/gui/container/creative_inventory/tabs.png");
    private static final String textBrowser = "container.enderrift.browser";
    protected InventoryPlayer player;
    private boolean isDragging;
    private int scrollY;
    private float scrollAcc = 0.0f;
    private GuiTextField searchField;

    protected GuiBrowser(Container container) {
        super(container);
    }

    public GuiBrowser(EntityPlayer player, TileBrowser tileEntity) {
        super((Container)new ContainerBrowser(tileEntity, player, true));
        this.player = player.field_71071_by;
        this.field_146999_f = 194;
        this.field_147000_g = 168;
    }

    protected ResourceLocation getBackgroundTexture() {
        return backgroundTexture;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        GuiButton btn = new GuiButton(1, this.field_147003_i - 22, this.field_147009_r + 12, 20, 20, "");
        this.field_146292_n.add(btn);
        Keyboard.enableRepeatEvents((boolean)true);
        this.searchField = new GuiTextField(2, this.field_146289_q, this.field_147003_i + 114, this.field_147009_r + 6, 71, this.field_146289_q.field_78288_b){

            public void func_146192_a(int mouseX, int mouseY, int mouseButton) {
                if (mouseButton == 1 && this.func_146179_b() != null && this.func_146179_b().length() > 0) {
                    this.func_146180_a("");
                    GuiBrowser.this.updateSearchFilter();
                }
                super.func_146192_a(mouseX, mouseY, mouseButton);
            }
        };
        this.searchField.func_146203_f(15);
        this.searchField.func_146185_a(false);
        this.searchField.func_146189_e(true);
        this.searchField.func_146193_g(0xFFFFFF);
        this.searchField.func_146205_d(false);
        this.searchField.func_146195_b(true);
        this.searchField.func_146180_a("");
        this.changeSorting(btn, SortMode.StackSize);
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (!this.func_146983_a(keyCode)) {
            if (this.searchField.func_146201_a(typedChar, keyCode)) {
                this.updateSearchFilter();
            } else {
                super.func_73869_a(typedChar, keyCode);
            }
        }
    }

    private void updateSearchFilter() {
        ((ContainerBrowser)this.field_147002_h).setFilterText(this.searchField.func_146179_b());
    }

    protected void func_146284_a(GuiButton guibutton) {
        if (guibutton.field_146127_k == 1) {
            SortMode mode = ((ContainerBrowser)this.field_147002_h).sortMode;
            switch (mode) {
                case Alphabetic: {
                    mode = SortMode.StackSize;
                    break;
                }
                case StackSize: {
                    mode = SortMode.Alphabetic;
                }
            }
            this.changeSorting(guibutton, mode);
        }
    }

    private void changeSorting(GuiButton guibutton, SortMode mode) {
        switch (mode) {
            case Alphabetic: {
                guibutton.field_146126_j = "Az";
                break;
            }
            case StackSize: {
                guibutton.field_146126_j = "#";
            }
        }
        ((ContainerBrowser)this.field_147002_h).setSortMode(mode);
    }

    protected void func_146976_a(float partialTicks, int xMouse, int yMouse) {
        this.field_146297_k.field_71446_o.func_110577_a(this.getBackgroundTexture());
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        this.func_73729_b(this.field_147003_i - 27, this.field_147009_r + 8, 194, 0, 27, 28);
        this.field_146297_k.field_71446_o.func_110577_a(tabsTexture);
        boolean isEnabled = this.needsScrollBar();
        if (isEnabled) {
            this.func_73729_b(this.field_147003_i + 174, this.field_147009_r + 18 + this.scrollY, 232, 0, 12, 15);
        } else {
            this.func_73729_b(this.field_147003_i + 174, this.field_147009_r + 18, 244, 0, 12, 15);
        }
        this.searchField.func_146194_f();
    }

    protected void func_146979_b(int xMouse, int yMouse) {
        RenderHelper.func_74520_c();
        this.drawCustomSlotTexts();
        RenderHelper.func_74518_a();
        String name = I18n.func_135052_a((String)textBrowser, (Object[])new Object[0]);
        this.field_146297_k.field_71466_p.func_78276_b(name, 8, 6, 0x404040);
        this.field_146297_k.field_71466_p.func_78276_b(I18n.func_135052_a((String)this.player.func_70005_c_(), (Object[])new Object[0]), 8, this.field_147000_g - 96 + 2, 0x404040);
    }

    private void drawCustomSlotTexts() {
        for (int i = 0; i < 27; ++i) {
            Slot slot = (Slot)this.field_147002_h.field_75151_b.get(i);
            this.drawSlotText(slot);
        }
    }

    private void drawSlotText(Slot slotIn) {
        int count;
        this.field_73735_i = 100.0f;
        this.field_146296_j.field_77023_b = 100.0f;
        int xPosition = slotIn.field_75223_e;
        int yPosition = slotIn.field_75221_f;
        ItemStack stack = slotIn.func_75211_c();
        if (stack != null && (count = ((ContainerBrowser)this.field_147002_h).fakeInventoryClient.getStackSizeForSlot(slotIn.field_75222_d)) != 1) {
            String s = count >= 1000000000 ? count / 1000000000 + "B" : (count >= 900000000 ? ".9B" : (count >= 1000000 ? count / 1000000 + "M" : (count >= 900000 ? ".9M" : (count >= 1000 ? count / 1000 + "k" : (count >= 900 ? ".9k" : String.valueOf(count))))));
            GlStateManager.func_179140_f();
            GlStateManager.func_179097_i();
            GlStateManager.func_179084_k();
            this.field_146289_q.func_175063_a(s, (float)(xPosition + 19 - 2 - this.field_146289_q.func_78256_a(s)), (float)(yPosition + 6 + 3), 0xFFFFFF);
            GlStateManager.func_179145_e();
            GlStateManager.func_179126_j();
        }
        this.field_146296_j.field_77023_b = 0.0f;
        this.field_73735_i = 0.0f;
    }

    private boolean needsScrollBar() {
        int actualSlotCount = ((ContainerBrowser)this.field_147002_h).getActualSlotCount();
        return actualSlotCount > 27;
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        this.scrollAcc += (float)Mouse.getEventDWheel();
        ContainerBrowser container = (ContainerBrowser)this.field_147002_h;
        int h = 62;
        int bitHeight = 15;
        int actualSlotCount = container.getActualSlotCount();
        int rows = (int)Math.ceil((double)actualSlotCount / 9.0);
        if (rows > 3) {
            int scrollRows = rows - 3;
            int row = container.scroll / 9;
            while (this.scrollAcc >= 120.0f) {
                --row;
                this.scrollAcc -= 120.0f;
            }
            while (this.scrollAcc <= -120.0f) {
                ++row;
                this.scrollAcc += 120.0f;
            }
            row = Math.max(0, Math.min(scrollRows, row));
            this.scrollY = row * 47 / scrollRows;
            container.setScrollPos(row * 9);
        } else {
            this.scrollAcc = 0.0f;
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        int w = 12;
        int h = 62;
        int mx = mouseX - 174 - this.field_147003_i;
        int my = mouseY - 18 - this.field_147009_r;
        if (mx >= 0 && mx < 12 && my >= 0 && my < 62) {
            this.updateScrollPos(my);
            this.isDragging = true;
            return;
        }
        w = this.searchField.field_146218_h;
        h = this.searchField.field_146219_i;
        mx = mouseX - this.searchField.field_146209_f;
        my = mouseY - this.searchField.field_146210_g;
        if (mx >= 0 && mx < w && my >= 0 && my < h) {
            this.searchField.func_146192_a(mx, my, mouseButton);
            return;
        }
        super.func_73864_a(mouseX, mouseY, mouseButton);
    }

    private void updateScrollPos(int my) {
        boolean isEnabled;
        int h = 62;
        int bitHeight = 15;
        int actualSlotCount = ((ContainerBrowser)this.field_147002_h).getActualSlotCount();
        int rows = (int)Math.ceil((double)actualSlotCount / 9.0);
        int scrollRows = rows - 3;
        boolean bl = isEnabled = scrollRows > 0;
        if (isEnabled) {
            double offset = ((double)my - 7.5) * (double)scrollRows / 47.0;
            int row = Math.round(Math.max(0, Math.min(scrollRows, (int)offset)));
            this.scrollY = row * 47 / scrollRows;
            ContainerBrowser container = (ContainerBrowser)this.field_147002_h;
            container.setScrollPos(row * 9);
        }
    }

    protected void func_146273_a(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        int my = mouseY - 18 - this.field_147009_r;
        if (this.isDragging) {
            this.updateScrollPos(my);
            return;
        }
        super.func_146273_a(mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
    }

    protected void func_146286_b(int mouseX, int mouseY, int state) {
        int my = mouseY - 18 - this.field_147009_r;
        if (this.isDragging) {
            this.updateScrollPos(my);
            this.isDragging = false;
            return;
        }
        super.func_146286_b(mouseX, mouseY, state);
    }
}

