/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.enderRift.integration;

import gigaherz.enderRift.EnderRiftMod;
import gigaherz.enderRift.generator.TileGenerator;
import gigaherz.enderRift.rift.BlockStructure;
import gigaherz.enderRift.rift.TileEnderRift;
import gigaherz.enderRift.rift.TileEnderRiftCorner;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.IWailaRegistrar;
import net.minecraft.block.Block;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;

public class WailaProviders {
    private static final String CONFIG_GENERATOR = "enderrift.generator";
    private static final String CONFIG_RIFT = "enderrift.rift";
    private static final String CONFIG_RF = "enderrift.rf";

    public static void callbackRegister(IWailaRegistrar registrar) {
        registrar.addConfig("Ender-Rift", CONFIG_GENERATOR);
        registrar.addConfig("Ender-Rift", CONFIG_RIFT);
        registrar.addConfig("Ender-Rift", CONFIG_RF);
        Object instance = new RiftTooltipProvider();
        registrar.registerBodyProvider((IWailaDataProvider)instance, TileEnderRift.class);
        registrar.registerNBTProvider((IWailaDataProvider)instance, TileEnderRift.class);
        registrar.registerStackProvider((IWailaDataProvider)instance, TileEnderRiftCorner.class);
        registrar.registerBodyProvider((IWailaDataProvider)instance, TileEnderRiftCorner.class);
        registrar.registerNBTProvider((IWailaDataProvider)instance, TileEnderRiftCorner.class);
        instance = new StructureTooltipProvider();
        registrar.registerStackProvider((IWailaDataProvider)instance, BlockStructure.class);
        instance = new GeneratorTooltipProvider();
        registrar.registerBodyProvider((IWailaDataProvider)instance, TileGenerator.class);
        registrar.registerNBTProvider((IWailaDataProvider)instance, TileGenerator.class);
    }

    @Optional.Interface(modid="Waila", iface="mcp.mobius.waila.api.IWailaDataProvider")
    public static class RiftTooltipProvider
    implements IWailaDataProvider {
        public ItemStack getWailaStack(IWailaDataAccessor accessor, IWailaConfigHandler config) {
            return new ItemStack((Block)EnderRiftMod.structure);
        }

        public List<String> getWailaHead(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
            return currenttip;
        }

        public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
            if (config.getConfig(WailaProviders.CONFIG_RIFT)) {
                NBTTagCompound tag = accessor.getNBTData();
                if (tag != null && tag.func_74764_b("isFormed")) {
                    currenttip.add(I18n.func_135052_a((String)"text.enderrift.rift.isFormed", (Object[])new Object[]{tag.func_74767_n("isFormed")}));
                    if (tag.func_74767_n("isFormed")) {
                        currenttip.add(I18n.func_135052_a((String)"text.enderrift.rift.riftId", (Object[])new Object[]{tag.func_74762_e("riftId")}));
                        if (config.getConfig(WailaProviders.CONFIG_RF)) {
                            currenttip.add(I18n.func_135052_a((String)"text.enderrift.rift.rf", (Object[])new Object[]{tag.func_74762_e("energy"), tag.func_74762_e("energyTotal")}));
                        }
                    }
                    currenttip.add(I18n.func_135052_a((String)"text.enderrift.rift.usedSlots", (Object[])new Object[]{tag.func_74762_e("usedSlots")}));
                    currenttip.add(I18n.func_135052_a((String)"text.enderrift.rift.energyUsageInsert", (Object[])new Object[]{tag.func_74762_e("energyInsert")}));
                    currenttip.add(I18n.func_135052_a((String)"text.enderrift.rift.energyUsageExtract", (Object[])new Object[]{tag.func_74762_e("energyExtract")}));
                } else {
                    currenttip.add(I18n.func_135052_a((String)"text.enderrift.rift.waila.isFormed", (Object[])new Object[]{false}));
                }
            }
            return currenttip;
        }

        public List<String> getWailaTail(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
            return currenttip;
        }

        public NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity te, NBTTagCompound tag, World world, BlockPos pos) {
            TileEnderRift rift = te instanceof TileEnderRiftCorner ? (TileEnderRift)((Object)((TileEnderRiftCorner)te).getParent()) : (TileEnderRift)te;
            tag.func_74768_a("usedSlots", rift.countInventoryStacks());
            tag.func_74768_a("energyInsert", (int)Math.ceil(rift.getEnergyInsert()));
            tag.func_74768_a("energyExtract", (int)Math.ceil(rift.getEnergyExtract()));
            tag.func_74757_a("isFormed", rift.func_145832_p() != 0);
            tag.func_74768_a("riftId", rift.getRiftId());
            tag.func_74768_a("energy", rift.getEnergyBuffer().getEnergy());
            tag.func_74768_a("energyTotal", rift.getEnergyBuffer().getCapacity());
            return tag;
        }
    }

    @Optional.Interface(modid="Waila", iface="mcp.mobius.waila.api.IWailaDataProvider")
    public static class StructureTooltipProvider
    implements IWailaDataProvider {
        public ItemStack getWailaStack(IWailaDataAccessor accessor, IWailaConfigHandler config) {
            return new ItemStack((Block)EnderRiftMod.rift);
        }

        public List<String> getWailaHead(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
            return currenttip;
        }

        public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
            return currenttip;
        }

        public List<String> getWailaTail(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
            return currenttip;
        }

        public NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity te, NBTTagCompound tag, World world, BlockPos pos) {
            return tag;
        }
    }

    @Optional.Interface(modid="Waila", iface="mcp.mobius.waila.api.IWailaDataProvider")
    public static class GeneratorTooltipProvider
    implements IWailaDataProvider {
        public ItemStack getWailaStack(IWailaDataAccessor accessor, IWailaConfigHandler config) {
            return null;
        }

        public List<String> getWailaHead(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
            return currenttip;
        }

        public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
            if (config.getConfig(WailaProviders.CONFIG_GENERATOR)) {
                NBTTagCompound tag = accessor.getNBTData();
                if (tag.func_74762_e("powerGen") > 0) {
                    currenttip.add(I18n.func_135052_a((String)"text.enderrift.generator.status.generating", (Object[])new Object[]{tag.func_74762_e("powerGen")}));
                } else if (tag.func_74767_n("isBurning")) {
                    currenttip.add(I18n.func_135052_a((String)"text.enderrift.generator.status.heating", (Object[])new Object[0]));
                } else {
                    currenttip.add(I18n.func_135052_a((String)"text.enderrift.generator.status.idle", (Object[])new Object[0]));
                }
                currenttip.add(I18n.func_135052_a((String)"text.enderrift.generator.heat", (Object[])new Object[]{tag.func_74762_e("heat")}));
                if (config.getConfig(WailaProviders.CONFIG_RF)) {
                    currenttip.add(I18n.func_135052_a((String)"text.enderrift.generator.energy", (Object[])new Object[]{tag.func_74762_e("energy"), 100000}));
                }
            }
            return currenttip;
        }

        public List<String> getWailaTail(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
            return currenttip;
        }

        public NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity te, NBTTagCompound tag, World world, BlockPos pos) {
            TileGenerator rift = (TileGenerator)te;
            tag.func_74757_a("isBurning", rift.isBurning());
            tag.func_74768_a("powerGen", rift.getGenerationPower());
            tag.func_74768_a("energy", rift.getContainedEnergy());
            tag.func_74768_a("heat", rift.getHeatValue());
            return tag;
        }
    }
}

