/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.enderRift.network;

import com.google.common.collect.Lists;
import gigaherz.enderRift.EnderRiftMod;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class SendSlotChanges
implements IMessage {
    public int windowId;
    public int slotCount;
    public List<Integer> indices;
    public List<ItemStack> stacks;

    public SendSlotChanges() {
        this.indices = Lists.newArrayList();
        this.stacks = Lists.newArrayList();
    }

    public SendSlotChanges(int windowId, int slotCount, List<Integer> indices, List<ItemStack> stacks) {
        this.windowId = windowId;
        this.slotCount = slotCount;
        this.indices = indices;
        this.stacks = stacks;
    }

    public void fromBytes(ByteBuf buf) {
        this.windowId = buf.readInt();
        this.slotCount = buf.readInt();
        int count = buf.readInt();
        while (count-- > 0) {
            this.indices.add(buf.readInt());
            this.stacks.add(this.readItemStackFromBuffer(buf));
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.windowId);
        buf.writeInt(this.slotCount);
        buf.writeInt(this.indices.size());
        for (int i = 0; i < this.indices.size(); ++i) {
            buf.writeInt(this.indices.get(i).intValue());
            this.writeItemStackToBuffer(buf, this.stacks.get(i));
        }
    }

    private ItemStack readItemStackFromBuffer(ByteBuf buf) {
        ItemStack itemstack = null;
        short i = buf.readShort();
        if (i >= 0) {
            int j = buf.readInt();
            short k = buf.readShort();
            itemstack = new ItemStack(Item.func_150899_d((int)i), j, (int)k);
            itemstack.func_77982_d(ByteBufUtils.readTag((ByteBuf)buf));
        }
        return itemstack;
    }

    private void writeItemStackToBuffer(ByteBuf buf, ItemStack stack) {
        if (stack == null) {
            buf.writeShort(-1);
        } else {
            buf.writeShort(Item.func_150891_b((Item)stack.func_77973_b()));
            buf.writeInt(stack.field_77994_a);
            buf.writeShort(stack.func_77960_j());
            NBTTagCompound nbttagcompound = null;
            if (stack.func_77973_b().func_77645_m() || stack.func_77973_b().func_77651_p()) {
                nbttagcompound = stack.func_77978_p();
            }
            ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)nbttagcompound);
        }
    }

    public static class Handler
    implements IMessageHandler<SendSlotChanges, IMessage> {
        public IMessage onMessage(SendSlotChanges message, MessageContext ctx) {
            EnderRiftMod.proxy.handleSendSlotChanges(message);
            return null;
        }
    }
}

