/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.enderRift.rift;

import com.google.common.collect.Lists;
import gigaherz.enderRift.blocks.BlockRegistered;
import gigaherz.enderRift.rift.RiftStructure;
import gigaherz.enderRift.rift.TileEnderRiftCorner;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockStructure
extends BlockRegistered {
    public static final PropertyEnum<Type1> TYPE1 = PropertyEnum.func_177709_a((String)"type1", Type1.class);
    public static final PropertyEnum<Type2> TYPE2 = PropertyEnum.func_177709_a((String)"type2", Type2.class);
    public static final PropertyEnum<Corner> CORNER = PropertyEnum.func_177709_a((String)"corner", Corner.class);
    public static final PropertyBool BASE = PropertyBool.func_177716_a((String)"base");

    public BlockStructure(String name) {
        super(name, Material.field_151576_e);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149663_c("enderrift.blockStructure");
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(TYPE1, (Comparable)((Object)Type1.NORMAL)).func_177226_a(TYPE2, (Comparable)((Object)Type2.NONE)).func_177226_a(CORNER, (Comparable)((Object)Corner.values[0])).func_177226_a((IProperty)BASE, (Comparable)Boolean.valueOf(false)));
        this.func_149711_c(3.0f);
        this.func_149713_g(0);
    }

    public boolean hasTileEntity(IBlockState state) {
        return state.func_177229_b(TYPE1) == Type1.CORNER;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEnderRiftCorner();
    }

    @Deprecated
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Deprecated
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean canBeReplacedByLeaves(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{TYPE1, TYPE2, CORNER, BASE});
    }

    @Deprecated
    public IBlockState func_176203_a(int meta) {
        Type1 type1 = Type1.values[meta >> 3];
        IBlockState state = this.func_176223_P().func_177226_a(TYPE1, (Comparable)((Object)type1));
        int type2 = meta >> 1 & 3;
        state = type1 == Type1.CORNER ? state.func_177226_a(CORNER, (Comparable)((Object)Corner.values[type2])) : state.func_177226_a(TYPE2, (Comparable)((Object)Type2.values[type2]));
        return state.func_177226_a((IProperty)BASE, (Comparable)Boolean.valueOf((meta & 1) == 1));
    }

    public int func_176201_c(IBlockState state) {
        Type1 type1 = (Type1)((Object)state.func_177229_b(TYPE1));
        int type1i = type1.ordinal();
        int type2 = type1 == Type1.CORNER ? ((Corner)((Object)state.func_177229_b(CORNER))).ordinal() : ((Type2)((Object)state.func_177229_b(TYPE2))).ordinal();
        int base = (Boolean)state.func_177229_b((IProperty)BASE) != false ? 1 : 0;
        return type1i << 3 | type2 << 1 | base;
    }

    @Deprecated
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        if (state.func_177229_b(TYPE1) == Type1.NORMAL) {
            Type2 d = (Type2)((Object)state.func_177229_b(TYPE2));
            switch (d) {
                case NONE: {
                    return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.25, 1.0);
                }
                case SIDE_EW: {
                    if (!((Boolean)state.func_177229_b((IProperty)BASE)).booleanValue()) {
                        return new AxisAlignedBB(0.0, 0.25, 0.25, 1.0, 0.75, 0.75);
                    }
                    return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.75, 1.0);
                }
                case VERTICAL: {
                    return new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 1.0, 0.75);
                }
                case SIDE_NS: {
                    if (!((Boolean)state.func_177229_b((IProperty)BASE)).booleanValue()) {
                        return new AxisAlignedBB(0.25, 0.25, 0.0, 0.75, 0.75, 1.0);
                    }
                    return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.75, 1.0);
                }
            }
        }
        return field_185505_j;
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        super.func_180663_b(worldIn, pos, state);
        RiftStructure.breakStructure(worldIn, pos);
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList ret = Lists.newArrayList();
        ret.add(new ItemStack(RiftStructure.getOriginalBlock((World)world, pos)));
        return ret;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack(RiftStructure.getOriginalBlock(world, pos));
    }

    public IBlockState cornerState(Corner corner, boolean base) {
        return this.func_176223_P().func_177226_a(TYPE1, (Comparable)((Object)Type1.CORNER)).func_177226_a(CORNER, (Comparable)((Object)corner)).func_177226_a((IProperty)BASE, (Comparable)Boolean.valueOf(base));
    }

    public IBlockState edgeState(Type2 type2, boolean base) {
        return this.func_176223_P().func_177226_a(TYPE1, (Comparable)((Object)Type1.NORMAL)).func_177226_a(TYPE2, (Comparable)((Object)type2)).func_177226_a((IProperty)BASE, (Comparable)Boolean.valueOf(base));
    }

    public static enum Corner implements IStringSerializable
    {
        NE("ne"),
        NW("nw"),
        SE("se"),
        SW("sw");

        private final String name;
        public static Corner[] values;

        private Corner(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public String func_176610_l() {
            return this.name;
        }

        static {
            values = Corner.values();
        }
    }

    public static enum Type2 implements IStringSerializable
    {
        NONE("none"),
        VERTICAL("vertical"),
        SIDE_EW("side_ew"),
        SIDE_NS("side_ns");

        private final String name;
        public static Type2[] values;

        private Type2(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public String func_176610_l() {
            return this.name;
        }

        static {
            values = Type2.values();
        }
    }

    public static enum Type1 implements IStringSerializable
    {
        NORMAL("normal"),
        CORNER("corner");

        private final String name;
        public static Type1[] values;

        private Type1(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public String func_176610_l() {
            return this.name;
        }

        static {
            values = Type1.values();
        }
    }
}

