/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.enderRift.rift;

import gigaherz.capabilities.api.energy.EnergyBuffer;
import gigaherz.capabilities.api.energy.IEnergyHandler;
import gigaherz.enderRift.ConfigValues;
import gigaherz.enderRift.EnderRiftMod;
import gigaherz.enderRift.automation.CapabilityAutomation;
import gigaherz.enderRift.automation.IInventoryAutomation;
import gigaherz.enderRift.storage.RiftInventory;
import gigaherz.enderRift.storage.RiftStorageWorldData;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;

public class TileEnderRift
extends TileEntity {
    public final Random rand = new Random();
    private EnergyBuffer energyBuffer = new EnergyBuffer(10000000);
    private int riftId;
    private RiftInventory inventory;
    private AutomationEnergyWrapper automation = new AutomationEnergyWrapper();

    public void assemble(int id) {
        this.inventory = null;
        this.riftId = id;
        this.func_70296_d();
    }

    public void unassemble() {
        this.inventory = null;
        this.riftId = -1;
        this.func_70296_d();
    }

    public RiftInventory getInventory() {
        if (this.riftId < 0) {
            return null;
        }
        if (this.inventory == null) {
            this.inventory = RiftStorageWorldData.get(this.field_145850_b).getRift(this.riftId);
            this.inventory.addWeakListener(this);
        }
        return this.inventory;
    }

    public IEnergyHandler getEnergyBuffer() {
        return this.energyBuffer;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 1;
    }

    public double getEnergyInsert() {
        if (this.getInventory() == null) {
            return 0.0;
        }
        int sizeInventory = this.getInventory().getSlots();
        int sizeInventory2 = sizeInventory * sizeInventory;
        return ConfigValues.PowerPerInsertionConstant + (float)sizeInventory * ConfigValues.PowerPerInsertionLinear + (float)sizeInventory2 * ConfigValues.PowerPerInsertionGeometric;
    }

    public double getEnergyExtract() {
        if (this.getInventory() == null) {
            return 0.0;
        }
        int sizeInventory = this.getInventory().getSlots();
        int sizeInventory2 = sizeInventory * sizeInventory;
        return ConfigValues.PowerPerExtractionConstant + (float)sizeInventory * ConfigValues.PowerPerExtractionLinear + (float)sizeInventory2 * ConfigValues.PowerPerExtractionGeometric;
    }

    public int countInventoryStacks() {
        return this.getInventory().getSlots();
    }

    private int getEffectivePowerUsageToInsert(int stackSize) {
        return this.field_145850_b.field_72995_K ? 0 : (int)Math.ceil(this.getEnergyInsert() * (double)stackSize);
    }

    private int getEffectivePowerUsageToExtract(int limit) {
        return this.field_145850_b.field_72995_K ? 0 : (int)Math.ceil(this.getEnergyExtract() * (double)limit);
    }

    public ItemStack getRiftItem() {
        ItemStack stack = new ItemStack(EnderRiftMod.riftOrb);
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("RiftId", this.riftId);
        stack.func_77982_d(tag);
        return stack;
    }

    public void func_145839_a(NBTTagCompound nbtTagCompound) {
        super.func_145839_a(nbtTagCompound);
        this.energyBuffer.setEnergy(nbtTagCompound.func_74762_e("Energy"));
        this.riftId = nbtTagCompound.func_74762_e("RiftId");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbtTagCompound) {
        nbtTagCompound = super.func_189515_b(nbtTagCompound);
        nbtTagCompound.func_74768_a("Energy", this.energyBuffer.getEnergy());
        nbtTagCompound.func_74768_a("RiftId", this.riftId);
        return nbtTagCompound;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityAutomation.INSTANCE) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityAutomation.INSTANCE) {
            return (T)CapabilityAutomation.INSTANCE.cast((Object)this.automation);
        }
        return (T)super.getCapability(capability, facing);
    }

    public ItemStack chooseRandomStack() {
        if (this.getInventory() == null) {
            return null;
        }
        int max = this.getInventory().getSlots();
        if (max <= 0) {
            return null;
        }
        int slot = this.rand.nextInt(max);
        return this.automation.getStackInSlot(slot);
    }

    public int getRiftId() {
        return this.riftId;
    }

    class AutomationEnergyWrapper
    implements IInventoryAutomation {
        AutomationEnergyWrapper() {
        }

        @Override
        public ItemStack insertItems(@Nonnull ItemStack stack) {
            ItemStack remaining;
            int stackSize;
            if (TileEnderRift.this.getInventory() == null) {
                return stack;
            }
            int cost = TileEnderRift.this.getEffectivePowerUsageToInsert(stackSize);
            for (stackSize = stack.field_77994_a; cost > TileEnderRift.this.energyBuffer.getEnergy() && stackSize > 0; --stackSize) {
            }
            if (stackSize <= 0) {
                return stack;
            }
            ItemStack temp = stack;
            if (stackSize != stack.field_77994_a) {
                temp = stack.func_77946_l();
                temp.field_77994_a = stackSize;
            }
            if ((remaining = TileEnderRift.this.getInventory().insertItems(temp)) != null) {
                stackSize -= remaining.field_77994_a;
            }
            int actualCost = TileEnderRift.this.getEffectivePowerUsageToInsert(stackSize);
            TileEnderRift.this.energyBuffer.extractEnergy(actualCost, false);
            TileEnderRift.this.func_70296_d();
            return remaining;
        }

        @Override
        public ItemStack extractItems(@Nonnull ItemStack stack, int wanted, boolean simulate) {
            if (TileEnderRift.this.getInventory() == null) {
                return null;
            }
            int cost = TileEnderRift.this.getEffectivePowerUsageToExtract(wanted);
            while (cost > TileEnderRift.this.energyBuffer.getEnergy() && wanted > 0) {
                --wanted;
            }
            if (wanted <= 0) {
                return null;
            }
            ItemStack extracted = TileEnderRift.this.getInventory().extractItems(stack, wanted, simulate);
            if (extracted == null) {
                return null;
            }
            if (!simulate) {
                int actualCost = TileEnderRift.this.getEffectivePowerUsageToExtract(extracted.field_77994_a);
                TileEnderRift.this.energyBuffer.extractEnergy(actualCost, false);
            }
            TileEnderRift.this.func_70296_d();
            return extracted;
        }

        @Override
        public int getSlots() {
            if (TileEnderRift.this.getInventory() == null) {
                return 0;
            }
            return TileEnderRift.this.getInventory().getSlots();
        }

        @Override
        public ItemStack getStackInSlot(int index) {
            if (TileEnderRift.this.getInventory() == null) {
                return null;
            }
            return TileEnderRift.this.getInventory().getStackInSlot(index);
        }
    }
}

