/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.enderRift.rift;

import gigaherz.capabilities.api.energy.CapabilityEnergy;
import gigaherz.capabilities.api.energy.IEnergyHandler;
import gigaherz.enderRift.EnderRiftMod;
import gigaherz.enderRift.compatibility.tesla.TeslaControllerBase;
import gigaherz.enderRift.rift.BlockStructure;
import gigaherz.enderRift.rift.TileEnderRift;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;

public class TileEnderRiftCorner
extends TileEntity {
    TileEnderRift energyParent;
    private Capability teslaConsumerCap = TeslaControllerBase.CONSUMER.getCapability();
    private Object teslaConsumerInstance;
    private Capability teslaHolderCap = TeslaControllerBase.HOLDER.getCapability();
    private Object teslaHolderInstance;

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY_HANDLER_CAPABILITY) {
            return this.getParent() != null;
        }
        if (this.teslaConsumerCap != null && capability == this.teslaConsumerCap) {
            return this.getParent() != null;
        }
        if (this.teslaHolderCap != null && capability == this.teslaHolderCap) {
            return this.getParent() != null;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY_HANDLER_CAPABILITY) {
            return (T)this.getParent();
        }
        if (this.teslaConsumerCap != null && capability == this.teslaConsumerCap) {
            if (this.teslaConsumerInstance == null && this.getParent() != null) {
                this.teslaConsumerInstance = TeslaControllerBase.CONSUMER.createInstance(this.getParent());
            }
            return (T)this.teslaConsumerInstance;
        }
        if (this.teslaHolderCap != null && capability == this.teslaHolderCap) {
            if (this.teslaHolderInstance == null && this.getParent() != null) {
                this.teslaHolderInstance = TeslaControllerBase.HOLDER.createInstance(this.getParent());
            }
            return (T)this.teslaHolderInstance;
        }
        return (T)super.getCapability(capability, facing);
    }

    public IEnergyHandler getParent() {
        if (this.energyParent == null) {
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            if (state.func_177230_c() != EnderRiftMod.structure) {
                return null;
            }
            TileEntity te = this.field_145850_b.func_175625_s(TileEnderRiftCorner.getRiftFromCorner(state, this.field_174879_c));
            if (te instanceof TileEnderRift) {
                this.energyParent = (TileEnderRift)te;
            } else {
                return null;
            }
        }
        return this.energyParent.getEnergyBuffer();
    }

    private static BlockPos getRiftFromCorner(IBlockState state, BlockPos pos) {
        boolean base = (Boolean)state.func_177229_b((IProperty)BlockStructure.BASE);
        BlockStructure.Corner corner = (BlockStructure.Corner)((Object)state.func_177229_b(BlockStructure.CORNER));
        int xParent = pos.func_177958_n();
        int yParent = pos.func_177956_o() + (base ? 1 : -1);
        int zParent = pos.func_177952_p();
        switch (corner) {
            case NE: {
                --xParent;
                ++zParent;
                break;
            }
            case NW: {
                ++xParent;
                ++zParent;
                break;
            }
            case SE: {
                --xParent;
                --zParent;
                break;
            }
            case SW: {
                ++xParent;
                --zParent;
            }
        }
        return new BlockPos(xParent, yParent, zParent);
    }
}

