/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.enderRift.storage;

import com.google.common.collect.Lists;
import gigaherz.enderRift.automation.IInventoryAutomation;
import gigaherz.enderRift.rift.TileEnderRift;
import gigaherz.enderRift.storage.RiftStorageWorldData;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class RiftInventory
implements IInventoryAutomation {
    private final RiftStorageWorldData manager;
    final List<Reference<? extends TileEnderRift>> listeners = Lists.newArrayList();
    final ReferenceQueue<TileEnderRift> deadListeners = new ReferenceQueue();
    private final List<ItemStack> inventorySlots = Lists.newArrayList();

    RiftInventory(RiftStorageWorldData manager) {
        this.manager = manager;
    }

    public void addWeakListener(TileEnderRift e) {
        this.listeners.add(new WeakReference<TileEnderRift>(e, this.deadListeners));
    }

    private void onContentsChanged() {
        Reference<TileEnderRift> ref = this.deadListeners.poll();
        while (ref != null) {
            this.listeners.remove(ref);
            ref = this.deadListeners.poll();
        }
        Iterator<Reference<? extends TileEnderRift>> it = this.listeners.iterator();
        while (it.hasNext()) {
            TileEnderRift rift = it.next().get();
            if (rift == null || rift.func_145837_r()) {
                it.remove();
                continue;
            }
            rift.func_70296_d();
        }
        this.manager.func_76185_a();
    }

    public void readFromNBT(NBTTagCompound nbtTagCompound) {
        NBTTagList itemList = nbtTagCompound.func_150295_c("Items", 10);
        this.inventorySlots.clear();
        for (int i = 0; i < itemList.func_74745_c(); ++i) {
            NBTTagCompound slot = itemList.func_150305_b(i);
            this.inventorySlots.add(ItemStack.func_77949_a((NBTTagCompound)slot));
        }
    }

    public void writeToNBT(NBTTagCompound nbtTagCompound) {
        NBTTagList itemList = new NBTTagList();
        for (ItemStack stack : this.inventorySlots) {
            if (stack == null) continue;
            NBTTagCompound slot = new NBTTagCompound();
            stack.func_77955_b(slot);
            itemList.func_74742_a((NBTBase)slot);
        }
        nbtTagCompound.func_74782_a("Items", (NBTBase)itemList);
    }

    @Override
    public int getSlots() {
        return this.inventorySlots.size();
    }

    @Override
    public ItemStack getStackInSlot(int index) {
        return this.inventorySlots.get(index);
    }

    @Override
    public ItemStack insertItems(@Nonnull ItemStack stack) {
        ItemStack remaining = stack.func_77946_l();
        for (ItemStack slot : this.inventorySlots) {
            int max;
            int transfer;
            if (slot == null || (transfer = Math.min(remaining.field_77994_a, (max = Math.min(remaining.func_77976_d(), 64)) - slot.field_77994_a)) <= 0 || !ItemStack.func_179545_c((ItemStack)slot, (ItemStack)remaining) || !ItemStack.func_77970_a((ItemStack)slot, (ItemStack)remaining)) continue;
            slot.field_77994_a += transfer;
            remaining.field_77994_a -= transfer;
            if (remaining.field_77994_a > 0) continue;
            break;
        }
        if (remaining.field_77994_a > 0) {
            this.inventorySlots.add(remaining);
        }
        this.onContentsChanged();
        return null;
    }

    @Override
    public ItemStack extractItems(@Nonnull ItemStack stack, int wanted, boolean simulate) {
        ItemStack extracted = stack.func_77946_l();
        extracted.field_77994_a = 0;
        if (stack.field_77994_a <= 0) {
            return null;
        }
        for (int i = 0; i < this.inventorySlots.size(); ++i) {
            int available;
            ItemStack slot = this.inventorySlots.get(i);
            if (slot == null || (available = Math.min(wanted, slot.field_77994_a)) <= 0 || !ItemStack.func_179545_c((ItemStack)slot, (ItemStack)stack) || !ItemStack.func_77970_a((ItemStack)slot, (ItemStack)stack)) continue;
            extracted.field_77994_a += available;
            if (!simulate) {
                slot.field_77994_a -= available;
                if (slot.field_77994_a <= 0) {
                    this.inventorySlots.remove(i);
                }
            }
            if ((wanted -= available) <= 0) break;
        }
        if (extracted.field_77994_a <= 0) {
            return null;
        }
        this.onContentsChanged();
        return extracted;
    }
}

