/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.mirror;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Optional;
import net.shadowfacts.mirror.Mirror;
import net.shadowfacts.mirror.MirrorConstructor;
import net.shadowfacts.mirror.MirrorField;
import net.shadowfacts.mirror.MirrorMethod;
import net.shadowfacts.mirror.stream.FieldStream;
import net.shadowfacts.mirror.stream.MethodStream;

public class MirrorClass<T> {
    protected final Class<T> clazz;

    MirrorClass(Class<T> clazz) {
        this.clazz = clazz;
    }

    public Class<T> unwrap() {
        return this.clazz;
    }

    public String simpleName() {
        return this.clazz.getSimpleName();
    }

    public String fullName() {
        return this.clazz.getName();
    }

    public MirrorConstructor<T> constructor(Class<?> ... types) {
        try {
            return Mirror.of(this.clazz.getConstructor(types));
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean hasAnnotation(Class<? extends Annotation> clazz) {
        return this.clazz.isAnnotationPresent(clazz);
    }

    public <A extends Annotation> A getAnnotation(Class<A> clazz) {
        return this.clazz.getAnnotation(clazz);
    }

    public boolean isInner() {
        return this.clazz.getEnclosingClass() != null;
    }

    public boolean isNotInner() {
        return !this.isInner();
    }

    public boolean isSubClassOf(Class<?> clazz) {
        return clazz.isAssignableFrom(this.clazz);
    }

    public boolean isSubClassOf(MirrorClass<?> clazz) {
        return this.isSubClassOf(clazz.unwrap());
    }

    public boolean isSuperClassOf(Class<?> clazz) {
        return this.clazz.isAssignableFrom(clazz);
    }

    public boolean isSuperClassOf(MirrorClass<?> clazz) {
        return this.isSuperClassOf(clazz.unwrap());
    }

    public boolean isInterface() {
        return this.clazz.isInterface();
    }

    public boolean isNotInterface() {
        return !this.isInterface();
    }

    public MirrorClass<? super T> getSuperClass() {
        return Mirror.of(this.clazz.getSuperclass());
    }

    public MirrorClass<?>[] getInterfaces() {
        Class<?>[] interfaces = this.clazz.getInterfaces();
        MirrorClass[] mirrors = new MirrorClass[interfaces.length];
        for (int i = 0; i < interfaces.length; ++i) {
            mirrors[i] = Mirror.of(interfaces[i]);
        }
        return mirrors;
    }

    public FieldStream fields() {
        return new FieldStream(Arrays.stream(this.clazz.getFields()).map(MirrorField::new));
    }

    public FieldStream declaredFields() {
        return new FieldStream(Arrays.stream(this.clazz.getDeclaredFields()).map(MirrorField::new));
    }

    public Optional<MirrorField> field(String ... names) {
        for (String s : names) {
            try {
                Field f = this.clazz.getField(s);
                return Optional.of(Mirror.of(f));
            }
            catch (NoSuchFieldException noSuchFieldException) {
            }
        }
        return Optional.empty();
    }

    public Optional<MirrorField> declaredField(String ... names) {
        for (String s : names) {
            try {
                Field f = this.clazz.getDeclaredField(s);
                return Optional.of(Mirror.of(f));
            }
            catch (NoSuchFieldException noSuchFieldException) {
            }
        }
        return Optional.empty();
    }

    public MethodStream methods() {
        return new MethodStream(Arrays.stream(this.clazz.getMethods()).map(MirrorMethod::new));
    }

    public MethodStream declaredMethods() {
        return new MethodStream(Arrays.stream(this.clazz.getDeclaredMethods()).map(MirrorMethod::new));
    }

    public Optional<MirrorMethod> method(String[] names, Class<?> ... args) {
        for (String s : names) {
            try {
                Method m = this.clazz.getMethod(s, args);
                return Optional.of(Mirror.of(m));
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
        }
        return Optional.empty();
    }

    public Optional<MirrorMethod> method(String name, Class<?> ... args) {
        return this.method(new String[]{name}, args);
    }

    public Optional<MirrorMethod> declaredMethod(String[] names, Class<?> ... args) {
        return ((MethodStream)((MethodStream)this.declaredMethods().filter(m -> Arrays.equals(args, m.parameterTypes()))).filter(f -> {
            for (String s : names) {
                if (!f.name().equals(s)) continue;
                return true;
            }
            return false;
        })).findFirst();
    }

    public Optional<MirrorMethod> declaredMethod(String name, Class<?> ... args) {
        return this.declaredMethod(new String[]{name}, args);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MirrorClass that = (MirrorClass)o;
        return this.clazz.equals(that.clazz);
    }

    public int hashCode() {
        return this.clazz.hashCode();
    }
}

