/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.shadowmc.block;

import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public interface TileEntityProvider<TE extends TileEntity> {
    public Class<TE> getTileEntityClass();

    default public TE createTileEntity() {
        try {
            return (TE)((TileEntity)this.getTileEntityClass().newInstance());
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    default public TE getTileEntity(IBlockAccess world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te != null) {
            if (this.getTileEntityClass().isAssignableFrom(te.getClass())) {
                return (TE)te;
            }
            throw new IllegalArgumentException(String.format("Invalid TileEntity type at %s, expected %s got %s", pos, this.getTileEntityClass().getName(), te.getClass().getName()));
        }
        throw new IllegalArgumentException(String.format("No TileEntity at position %s", pos));
    }
}

