/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.shadowmc.gui.component;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.function.Supplier;
import net.shadowfacts.shadowmc.gui.component.GUIVerticalBarIndicator;
import net.shadowfacts.shadowmc.util.Color;

public class GUITexturedVerticalBarIndicator
extends GUIVerticalBarIndicator {
    public GUITexturedVerticalBarIndicator(int x, int y, int width, int height, Supplier<Float> levelSupplier, Supplier<List<String>> tooltip) {
        super(x, y, width, height, levelSupplier, tooltip);
        this.primaryColor = new Color(0x77FF0000);
        this.secondaryColor = new Color(-1154285568);
    }

    public GUITexturedVerticalBarIndicator(int x, int y, int width, int height, Supplier<Float> levelSupplier) {
        this(x, y, width, height, levelSupplier, ImmutableList::of);
    }

    @Override
    public void draw(int mouseX, int mouseY) {
        float level = ((Float)this.levelSupplier.get()).floatValue();
        int filled = Math.min((int)(level * (float)this.height), this.height);
        this.bindTexture(widgetTextures);
        for (int i = 0; i < this.height / 50; ++i) {
            this.drawTexturedRect(this.x, this.y + i * 50, 0, 20, this.width, this.height);
        }
        if (this.height % 50 != 0) {
            this.drawTexturedRect(this.x, this.y + this.height - this.height % 50, 0, 20, this.width, this.height % 50);
        }
        this.drawRect(this.x, this.y + (this.height - filled), this.width, filled, this.primaryColor, this.zLevel + 0.005f);
        this.drawRect(this.x, this.y, this.width, this.height - filled, this.secondaryColor, this.zLevel + 0.005f);
    }
}

