/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.shadowmc.ui.element;

import com.google.common.collect.ImmutableList;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.shadowfacts.shadowmc.ui.UIDimensions;
import net.shadowfacts.shadowmc.ui.element.UIElementBase;
import net.shadowfacts.shadowmc.ui.style.UIAttribute;
import net.shadowfacts.shadowmc.ui.style.UIOrientation;
import net.shadowfacts.shadowmc.ui.util.UIHelper;

public class UIBarIndicator
extends UIElementBase {
    protected final Supplier<Float> levelSupplier;
    protected Consumer<List<String>> tooltip;

    public UIBarIndicator(Supplier<Float> levelSupplier, Consumer<List<String>> tooltip, String id, String ... classes) {
        super("bar-indicator", id, classes);
        this.levelSupplier = levelSupplier;
        this.tooltip = tooltip;
    }

    public UIBarIndicator(Supplier<Float> levelSupplier, String id, String ... classes) {
        this(levelSupplier, ImmutableList::of, id, classes);
    }

    @Override
    public UIDimensions getMinDimensions() {
        return this.getPreferredDimensions();
    }

    @Override
    public UIDimensions getPreferredDimensions() {
        UIOrientation orientation = this.getStyle(UIAttribute.ORIENTATION);
        switch (orientation) {
            default: {
                return new UIDimensions(20, 100);
            }
            case HORIZONTAL: 
        }
        return new UIDimensions(100, 20);
    }

    @Override
    public void draw(int mouseX, int mouseY) {
        float level = this.levelSupplier.get().floatValue();
        Color primaryColor = this.getStyle(UIAttribute.PRIMARY_COLOR);
        Color secondaryColor = this.getStyle(UIAttribute.SECONDARY_COLOR);
        UIOrientation orientation = this.getStyle(UIAttribute.ORIENTATION);
        if (orientation == UIOrientation.VERTICAL) {
            int filled = Math.min((int)(level * (float)this.dimensions.height), this.dimensions.height);
            UIHelper.drawRect(this.x, this.y + (this.dimensions.height - filled), this.dimensions.width, filled, primaryColor);
            UIHelper.drawRect(this.x, this.y, this.dimensions.width, this.dimensions.height - filled, secondaryColor);
        } else {
            int filled = Math.min((int)(level * (float)this.dimensions.width), this.dimensions.width);
            UIHelper.drawRect(this.x + this.dimensions.width - filled, this.y, filled, this.dimensions.height, primaryColor);
            UIHelper.drawRect(this.x, this.y, this.dimensions.width - filled, this.dimensions.height, secondaryColor);
        }
    }

    @Override
    public void drawTooltip(int mouseX, int mouseY) {
        if (UIHelper.isWithinBounds(mouseX, mouseY, this.x, this.y, this.dimensions)) {
            ArrayList<String> tooltip = new ArrayList<String>();
            this.tooltip.accept(tooltip);
            if (!tooltip.isEmpty()) {
                UIHelper.drawHoveringText(tooltip, mouseX, mouseY);
            }
        }
    }

    public void setTooltip(Consumer<List<String>> tooltip) {
        this.tooltip = tooltip;
    }
}

