/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.shadowmc.ui.element;

import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.shadowfacts.shadowmc.ui.UIDimensions;
import net.shadowfacts.shadowmc.ui.element.UIElementBase;
import net.shadowfacts.shadowmc.ui.util.UIHelper;
import org.lwjgl.opengl.GL11;

public class UIItemStack
extends UIElementBase {
    private ItemStack stack;
    private int preferredWidth;
    private int preferredHeight;
    private boolean tooltip;

    public UIItemStack(ItemStack stack, int width, int height, String id, String ... classes) {
        super("item-stack", id, classes);
        this.stack = stack;
        this.preferredWidth = width;
        this.preferredHeight = height;
    }

    public UIItemStack(ItemStack stack, String id, String ... classes) {
        this(stack, 16, 16, id, classes);
    }

    public UIItemStack(Item item, int width, int height, String id, String ... classes) {
        this(new ItemStack(item), width, height, id, classes);
    }

    public UIItemStack(Item item, String id, String ... classes) {
        this(item, 16, 16, id, classes);
    }

    public UIItemStack(Block block, int width, int height, String id, String ... classes) {
        this(new ItemStack(block), width, height, id, classes);
    }

    public UIItemStack(Block block, String id, String ... classes) {
        this(block, 16, 16, id, classes);
    }

    @Override
    public UIDimensions getMinDimensions() {
        return this.getPreferredDimensions();
    }

    @Override
    public UIDimensions getPreferredDimensions() {
        return new UIDimensions(this.preferredWidth, this.preferredHeight);
    }

    @Override
    public void draw(int mouseX, int mouseY) {
        GL11.glPushMatrix();
        RenderHelper.func_74520_c();
        float horizontalScale = (float)this.preferredWidth / 16.0f;
        float verticalScale = (float)this.preferredHeight / 16.0f;
        GL11.glScalef((float)horizontalScale, (float)verticalScale, (float)0.0f);
        this.mc.func_175599_af().func_180450_b(this.stack, (int)((float)this.x / horizontalScale), (int)((float)this.y / horizontalScale));
        GL11.glPopMatrix();
    }

    @Override
    public void drawTooltip(int mouseX, int mouseY) {
        if (this.tooltip && UIHelper.isWithinBounds(mouseX, mouseY, this)) {
            UIHelper.drawHoveringText(this.stack.func_82840_a((EntityPlayer)this.mc.field_71439_g, this.mc.field_71474_y.field_82882_x), mouseX, mouseY);
        }
    }

    public void setStack(ItemStack stack) {
        this.stack = stack;
    }

    public void setTooltip(boolean tooltip) {
        this.tooltip = tooltip;
    }
}

