/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.shadowmc.ui.element.button;

import java.awt.Color;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.function.BiFunction;
import net.shadowfacts.shadowlib.util.DesktopUtils;
import net.shadowfacts.shadowmc.ShadowMC;
import net.shadowfacts.shadowmc.ui.element.button.UIButtonText;
import net.shadowfacts.shadowmc.ui.style.UIAttribute;
import net.shadowfacts.shadowmc.util.MouseButton;

public class UIButtonLink
extends UIButtonText {
    protected URI link;

    public UIButtonLink(String text, URI link, String id, String ... classes) {
        super(text, (BiFunction<UIButtonText, MouseButton, Boolean>)null, id, classes);
        this.link = link;
        this.callback = this::openLink;
        this.setStyle(UIAttribute.TEXT_COLOR, Color.BLUE);
        this.setStyle(UIAttribute.TEXT_UNDERLINE, true);
    }

    public UIButtonLink(String text, String link, String id, String ... classes) {
        this(text, (URI)null, id, classes);
        try {
            this.link = new URI(link);
        }
        catch (URISyntaxException e) {
            ShadowMC.log.error("Couldn't create URI for UIButtonLink, disabling button", (Throwable)e);
            this.enabled = false;
        }
    }

    private boolean openLink(UIButtonText button, MouseButton mouseButton) {
        DesktopUtils.openWebpage(this.link);
        return true;
    }
}

