/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.shadowmc.ui.element.textfield;

import java.awt.Color;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ChatAllowedCharacters;
import net.minecraft.util.math.MathHelper;
import net.shadowfacts.shadowmc.ui.UIDimensions;
import net.shadowfacts.shadowmc.ui.UIKeyInteractable;
import net.shadowfacts.shadowmc.ui.UIMouseInteractable;
import net.shadowfacts.shadowmc.ui.element.UIElementBase;
import net.shadowfacts.shadowmc.ui.style.UIAttribute;
import net.shadowfacts.shadowmc.ui.util.UIHelper;
import net.shadowfacts.shadowmc.util.MouseButton;

public class UITextField
extends UIElementBase
implements UIMouseInteractable,
UIKeyInteractable {
    protected String text;
    protected Pattern validator;
    protected Consumer<String> textChangeHandler;
    protected boolean focused;
    protected boolean enabled = true;
    protected int cursorPos;
    protected int cursorCounter;
    protected int selectionEnd;
    protected int lineScrollOffset;
    protected int maxStringLength = 32;
    protected boolean drawBackground = true;
    protected int preferredWidth = 200;

    public UITextField(String text, Pattern validator, Consumer<String> textChangeHandler, String id, String ... classes) {
        super("text-field", id, classes);
        this.text = text;
        this.validator = validator;
        this.textChangeHandler = textChangeHandler;
    }

    public UITextField(Consumer<String> textChangeHandler, String id, String ... classes) {
        this("", Pattern.compile(".+"), textChangeHandler, id, classes);
    }

    protected void handleChange() {
        this.textChangeHandler.accept(this.text);
    }

    @Override
    public UIDimensions getMinDimensions() {
        return this.getPreferredDimensions();
    }

    @Override
    public UIDimensions getPreferredDimensions() {
        return new UIDimensions(this.preferredWidth, 20);
    }

    @Override
    public void draw(int mouseX, int mouseY) {
        GlStateManager.func_179097_i();
        if (this.drawBackground) {
            int borderWidth = this.getStyle(UIAttribute.TEXTFIELD_BORDER_WIDTH);
            UIHelper.drawRect(this.x - borderWidth, this.y - borderWidth, this.dimensions.width + borderWidth * 2, this.dimensions.height + borderWidth * 2, this.getStyle(UIAttribute.TEXTFIELD_CURSOR_COLOR), -1.0f);
            UIHelper.drawRect(this.x, this.y, this.dimensions.width, this.dimensions.height, this.getStyle(UIAttribute.TEXTFIELD_BACKGROUND_COLOR), -1.0f);
        }
        Color color = this.enabled ? this.getStyle(UIAttribute.TEXTFIELD_ENABLED_COLOR) : this.getStyle(UIAttribute.TEXTFIELD_DISABLED_COLOR);
        int j = this.cursorPos - this.lineScrollOffset;
        int k = this.selectionEnd - this.lineScrollOffset;
        String s = this.mc.field_71466_p.func_78269_a(this.text.substring(this.lineScrollOffset), this.dimensions.width);
        boolean flag = j >= 0 && j <= s.length();
        boolean flag1 = this.focused && this.cursorCounter / 6 % 2 == 0 && flag;
        int l = this.drawBackground ? this.x + 4 : this.x;
        int i1 = this.drawBackground ? this.y + (this.dimensions.height - 8) / 2 : this.y;
        int j1 = l;
        k = Math.min(k, s.length());
        if (s.length() > 0) {
            String s1 = flag ? s.substring(0, j) : s;
            j1 = this.mc.field_71466_p.func_175063_a(s1, (float)l, (float)i1, UIHelper.toARGB(color));
        }
        boolean flag2 = this.cursorCounter < this.text.length() || this.text.length() >= this.maxStringLength;
        int k1 = j1;
        if (!flag) {
            k1 = j > 0 ? l + this.dimensions.width : l;
        } else if (flag2) {
            k1 = j1--;
        }
        if (s.length() > 0 && flag && j < s.length()) {
            j1 = this.mc.field_71466_p.func_175063_a(s.substring(j), (float)j1, (float)i1, UIHelper.toARGB(color));
        }
        if (flag1) {
            if (flag2) {
                Gui.func_73734_a((int)k1, (int)(i1 - 1), (int)(k1 + 1), (int)(i1 + 1 + this.mc.field_71466_p.field_78288_b), (int)UIHelper.toARGB(this.getStyle(UIAttribute.TEXTFIELD_CURSOR_COLOR)));
            } else {
                this.mc.field_71466_p.func_175063_a("_", (float)k1, (float)i1, UIHelper.toARGB(color));
            }
        }
        if (k != j) {
            int l1 = l + this.mc.field_71466_p.func_78256_a(s.substring(0, k));
            this.drawCursorVertical(k1, i1 - 1, l1 - 1, i1 + 1 + this.mc.field_71466_p.field_78288_b);
        }
        GlStateManager.func_179126_j();
    }

    @Override
    public void drawTooltip(int mouseX, int mouseY) {
    }

    private void drawCursorVertical(int p1, int p2, int p3, int p4) {
        int temp;
        if (p1 < p3) {
            temp = p1;
            p1 = p3;
            p3 = temp;
        }
        if (p2 < p4) {
            temp = p2;
            p2 = p4;
            p4 = temp;
        }
        p3 = Math.min(p3, this.x + this.dimensions.width);
        p1 = Math.min(p1, this.x + this.dimensions.width);
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer buffer = tessellator.func_178180_c();
        Color selectionColor = this.getStyle(UIAttribute.TEXTFIELD_SELECTION_COLOR);
        GlStateManager.func_179131_c((float)selectionColor.getRed(), (float)selectionColor.getGreen(), (float)selectionColor.getBlue(), (float)255.0f);
        GlStateManager.func_179090_x();
        GlStateManager.func_179115_u();
        GlStateManager.func_179116_f((int)5387);
        buffer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        buffer.func_181662_b((double)p1, (double)p4, 0.0).func_181675_d();
        buffer.func_181662_b((double)p3, (double)p4, 0.0).func_181675_d();
        buffer.func_181662_b((double)p3, (double)p2, 0.0).func_181675_d();
        buffer.func_181662_b((double)p1, (double)p2, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179134_v();
        GlStateManager.func_179098_w();
    }

    public String getSelectedText() {
        int start = this.cursorPos < this.selectionEnd ? this.cursorPos : this.selectionEnd;
        int end = this.cursorPos < this.selectionEnd ? this.selectionEnd : this.cursorPos;
        return this.text.substring(start, end);
    }

    public void writeText(String input) {
        String s = "";
        String s1 = ChatAllowedCharacters.func_71565_a((String)input);
        int i = this.cursorPos < this.selectionEnd ? this.cursorPos : this.selectionEnd;
        int j = this.cursorPos < this.selectionEnd ? this.selectionEnd : this.cursorPos;
        int k = this.maxStringLength - this.text.length() - (i - j);
        int l = 0;
        if (this.text.length() > 0) {
            s = s + this.text.substring(0, i);
        }
        if (k < s1.length()) {
            s = s + s1.substring(0, k);
            l = k;
        } else {
            s = s + s1;
            l = s1.length();
        }
        if (this.text.length() > 0 && j < this.text.length()) {
            s = s + this.text.substring(j);
        }
        if (this.validator.matcher(s).matches()) {
            this.text = s;
            this.moveCursorBy(i - this.selectionEnd + l);
            this.handleChange();
        }
    }

    protected void moveCursorBy(int amount) {
        this.setCursorPos(this.selectionEnd + amount);
    }

    protected void setCursorPos(int pos) {
        this.cursorPos = pos;
        this.cursorPos = MathHelper.func_76125_a((int)this.cursorPos, (int)0, (int)this.text.length());
        this.setSelectionPos(this.cursorPos);
    }

    protected void setSelectionPos(int pos) {
        int i = this.text.length();
        this.selectionEnd = pos = Math.max(Math.min(pos, i), 0);
        this.lineScrollOffset = Math.min(this.lineScrollOffset, i);
        String s = this.mc.field_71466_p.func_78269_a(this.text.substring(this.lineScrollOffset), this.dimensions.width);
        int k = s.length() + this.lineScrollOffset;
        if (pos == this.lineScrollOffset) {
            this.lineScrollOffset -= this.mc.field_71466_p.func_78262_a(this.text, this.dimensions.width, true).length();
        }
        if (pos > k) {
            this.lineScrollOffset += pos - k;
        } else if (pos <= this.lineScrollOffset) {
            this.lineScrollOffset -= this.lineScrollOffset - pos;
        }
        this.lineScrollOffset = MathHelper.func_76125_a((int)this.lineScrollOffset, (int)0, (int)i);
    }

    @Override
    public void mouseClickDown(int mouseX, int mouseY, MouseButton button) {
        if (button == MouseButton.LEFT) {
            this.focused = true;
        }
    }

    @Override
    public void mouseClickAnywhere(int mouseX, int mouseY, MouseButton button) {
        if (button == MouseButton.LEFT && !UIHelper.isWithinBounds(mouseX, mouseY, this)) {
            this.focused = false;
        }
    }

    @Override
    public void keyPress(int keyCode, char keyChar) {
        if (this.focused) {
            if (GuiScreen.func_175278_g((int)keyCode)) {
                this.setSelectionPos(0);
                this.cursorPos = this.text.length();
            } else if (GuiScreen.func_175280_f((int)keyCode)) {
                GuiScreen.func_146275_d((String)this.getSelectedText());
            } else if (GuiScreen.func_175279_e((int)keyCode)) {
                if (this.enabled) {
                    this.writeText(GuiScreen.func_146277_j());
                }
            } else if (GuiScreen.func_175277_d((int)keyCode)) {
                GuiScreen.func_146275_d((String)this.getSelectedText());
                if (this.enabled) {
                    this.writeText("x");
                }
            } else {
                switch (keyCode) {
                    case 14: {
                        if (!this.enabled) break;
                        if (GuiScreen.func_146271_m()) {
                            this.deleteWords(-1);
                        } else {
                            this.deleteFromCursor(-1);
                        }
                        this.handleChange();
                        break;
                    }
                    case 199: {
                        if (GuiScreen.func_146272_n()) {
                            this.setSelectionPos(0);
                            break;
                        }
                        this.cursorPos = 0;
                        break;
                    }
                    case 203: {
                        if (GuiScreen.func_146272_n()) {
                            if (GuiScreen.func_146271_m()) {
                                this.setSelectionPos(this.getNthWordFromPos(-1, this.selectionEnd));
                            } else {
                                this.setSelectionPos(this.selectionEnd - 1);
                            }
                        } else if (GuiScreen.func_146271_m()) {
                            this.setCursorPos(this.getNthWordFromCursor(-1));
                        } else {
                            this.moveCursorBy(-1);
                        }
                        this.handleChange();
                        break;
                    }
                    case 205: {
                        if (GuiScreen.func_146272_n()) {
                            if (GuiScreen.func_146271_m()) {
                                this.setSelectionPos(this.getNthWordFromPos(1, this.selectionEnd));
                                break;
                            }
                            this.setSelectionPos(this.selectionEnd);
                            break;
                        }
                        if (GuiScreen.func_146271_m()) {
                            this.setCursorPos(this.getNthWordFromCursor(1));
                            break;
                        }
                        this.moveCursorBy(1);
                        break;
                    }
                    case 207: {
                        if (GuiScreen.func_146272_n()) {
                            this.setSelectionPos(this.text.length());
                            break;
                        }
                        this.setCursorPos(this.text.length());
                        break;
                    }
                    case 211: {
                        if (!this.enabled) break;
                        if (GuiScreen.func_146271_m()) {
                            this.deleteWords(1);
                            break;
                        }
                        this.deleteFromCursor(1);
                        break;
                    }
                    default: {
                        if (!ChatAllowedCharacters.func_71566_a((char)keyChar) || !this.enabled) break;
                        this.writeText(Character.toString(keyChar));
                    }
                }
            }
        }
    }

    private void deleteWords(int words) {
        if (this.text.length() != 0) {
            if (this.selectionEnd != this.cursorPos) {
                this.writeText("");
            } else {
                this.deleteFromCursor(this.getNthWordFromCursor(words) - this.cursorPos);
            }
        }
    }

    private void deleteFromCursor(int amount) {
        if (this.text.length() != 0) {
            if (this.selectionEnd != this.cursorPos) {
                this.writeText("");
            } else {
                boolean flag = amount < 0;
                int i = flag ? this.cursorPos + amount : this.cursorPos;
                int j = flag ? this.cursorPos : this.cursorPos + amount;
                String s = "";
                if (i >= 0) {
                    s = this.text.substring(0, i);
                }
                if (j < this.text.length()) {
                    s = s + this.text.substring(j);
                }
                this.text = s;
                if (flag) {
                    this.moveCursorBy(amount);
                }
            }
        }
    }

    private int getNthWordFromCursor(int words) {
        return this.getNthWordFromPos(words, this.cursorPos);
    }

    private int getNthWordFromPos(int words, int position) {
        return this.getNthWordFromPos(words, position, true);
    }

    private int getNthWordFromPos(int words, int position, boolean flag) {
        int i = position;
        boolean flag2 = words < 0;
        int j = Math.abs(words);
        for (int k = 0; k < j; ++k) {
            if (!flag2) {
                int l = this.text.length();
                if ((i = this.text.indexOf(32, i)) == -1) {
                    i = l;
                    continue;
                }
                while (flag && this.text.charAt(i) == ' ') {
                    ++i;
                }
                continue;
            }
            while (flag && i > 0 && this.text.charAt(i - 1) == ' ') {
                --i;
            }
            while (i > 0 && this.text.charAt(i - 1) != ' ') {
                --i;
            }
        }
        return i;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setPreferredWidth(int preferredWidth) {
        this.preferredWidth = preferredWidth;
    }
}

