/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.shadowmc.ui.mcwrapper;

import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.inventory.Container;
import net.minecraft.util.ITickable;
import net.shadowfacts.shadowmc.ui.UIElement;
import net.shadowfacts.shadowmc.ui.UIKeyInteractable;
import net.shadowfacts.shadowmc.ui.UIMouseInteractable;
import net.shadowfacts.shadowmc.ui.style.UIAttribute;
import net.shadowfacts.shadowmc.ui.util.UIHelper;
import net.shadowfacts.shadowmc.util.MouseButton;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class UIContainerWrapper
extends GuiContainer {
    private Set<UIKeyInteractable> keyHandlers = new LinkedHashSet<UIKeyInteractable>();
    private Set<UIElement> children = new LinkedHashSet<UIElement>();

    public UIContainerWrapper(Container container) {
        super(container);
    }

    public UIContainerWrapper add(UIElement element) {
        element.setInvalidationHandler(this::layout);
        this.children.add(element);
        return this;
    }

    public UIContainerWrapper layout() {
        ScaledResolution res = new ScaledResolution(Minecraft.func_71410_x());
        int screenWidth = res.func_78326_a();
        int screenHeight = res.func_78328_b();
        for (UIElement e : this.children) {
            int marginLeft = e.getStyle(UIAttribute.MARGIN_LEFT);
            int marginRight = e.getStyle(UIAttribute.MARGIN_RIGHT);
            int marginTop = e.getStyle(UIAttribute.MARGIN_TOP);
            int marginBottom = e.getStyle(UIAttribute.MARGIN_BOTTOM);
            e.layout(marginLeft, screenWidth - marginRight, marginTop, screenHeight - marginBottom);
        }
        return this;
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.children.forEach(e -> e.draw(mouseX, mouseY));
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(-this.field_147003_i), (float)(-this.field_147009_r), (float)0.0f);
        this.children.forEach(e -> e.drawTooltip(mouseX, mouseY));
        GL11.glPopMatrix();
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.children.stream().filter(e -> e instanceof ITickable).map(e -> (ITickable)e).forEach(ITickable::func_73660_a);
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        MouseButton button = MouseButton.get(mouseButton);
        this.children.stream().filter(e -> e instanceof UIMouseInteractable).peek(e -> ((UIMouseInteractable)((Object)e)).mouseClickAnywhere(mouseX, mouseY, button)).filter(e -> UIHelper.isWithinBounds(mouseX, mouseY, e)).map(e -> (UIMouseInteractable)((Object)e)).forEach(e -> e.mouseClickDown(mouseX, mouseY, button));
    }

    protected void func_146273_a(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        super.func_146273_a(mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
        MouseButton button = MouseButton.get(clickedMouseButton);
        this.children.stream().filter(e -> e instanceof UIMouseInteractable).filter(e -> UIHelper.isWithinBounds(mouseX, mouseY, e)).map(e -> (UIMouseInteractable)((Object)e)).forEach(e -> e.mouseMove(mouseX, mouseY, button, timeSinceLastClick));
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int mouseX = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
        int mouseY = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
        int delta = Mouse.getDWheel();
        if (delta != 0) {
            this.children.stream().filter(e -> e instanceof UIMouseInteractable).map(e -> (UIMouseInteractable)((Object)e)).forEach(e -> e.mouseScroll(mouseX, mouseY, delta));
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        super.func_73869_a(typedChar, keyCode);
        this.keyHandlers.forEach(handler -> handler.keyPress(keyCode, typedChar));
        this.children.stream().filter(e -> e instanceof UIKeyInteractable).map(e -> (UIKeyInteractable)((Object)e)).forEach(e -> e.keyPress(keyCode, typedChar));
    }

    public void setKeyHandlers(Set<UIKeyInteractable> keyHandlers) {
        this.keyHandlers = keyHandlers;
    }
}

