/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.shadowmc.ui.style;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.shadowfacts.shadowmc.ui.style.UIHorizontalLayoutMode;
import net.shadowfacts.shadowmc.ui.style.UILayoutMode;
import net.shadowfacts.shadowmc.ui.style.UIOrientation;
import net.shadowfacts.shadowmc.ui.style.UIVerticalLayoutMode;
import net.shadowfacts.shadowmc.ui.util.factory.BooleanFactory;
import net.shadowfacts.shadowmc.ui.util.factory.ColorFactory;
import net.shadowfacts.shadowmc.ui.util.factory.IntegerFactory;
import net.shadowfacts.shadowmc.ui.util.factory.ValueFactory;

public class UIAttribute<T> {
    private static final Map<String, UIAttribute<?>> attributes = new HashMap();
    private static final Map<UIAttribute<?>, ValueFactory<?>> valueFactories = new HashMap();
    public static final UIAttribute<UILayoutMode> LAYOUT = new UIAttribute<UILayoutMode>("layout", UILayoutMode.PREFERRED, UILayoutMode.FACTORY);
    public static final UIAttribute<UIHorizontalLayoutMode> HORIZONTAL_LAYOUT = new UIAttribute<UIHorizontalLayoutMode>("horizontal-layout", UIHorizontalLayoutMode.CENTER, UIHorizontalLayoutMode.FACTORY);
    public static final UIAttribute<UIVerticalLayoutMode> VERTICAL_LAYOUT = new UIAttribute<UIVerticalLayoutMode>("vertical-layout", UIVerticalLayoutMode.CENTER, UIVerticalLayoutMode.FACTORY);
    public static final UIAttribute<Integer> MARGIN_TOP = new UIAttribute<Integer>("margin-top", 0, IntegerFactory.INSTANCE);
    public static final UIAttribute<Integer> MARGIN_BOTTOM = new UIAttribute<Integer>("margin-bottom", 0, IntegerFactory.INSTANCE);
    public static final UIAttribute<Integer> MARGIN_LEFT = new UIAttribute<Integer>("margin-left", 0, IntegerFactory.INSTANCE);
    public static final UIAttribute<Integer> MARGIN_RIGHT = new UIAttribute<Integer>("margin-right", 0, IntegerFactory.INSTANCE);
    public static final UIAttribute<UIHorizontalLayoutMode> TEXT_HORIZONTAL_LAYOUT = new UIAttribute<UIHorizontalLayoutMode>("text-horizontal-layout", UIHorizontalLayoutMode.LEFT, UIHorizontalLayoutMode.FACTORY);
    public static final UIAttribute<UIVerticalLayoutMode> TEXT_VERTICAL_LAYOUT = new UIAttribute<UIVerticalLayoutMode>("text-vertical-layout", UIVerticalLayoutMode.TOP, UIVerticalLayoutMode.FACTORY);
    public static final UIAttribute<Color> TEXT_COLOR = new UIAttribute<Color>("text-color", Color.WHITE, ColorFactory.INSTANCE);
    public static final UIAttribute<Boolean> TEXT_UNDERLINE = new UIAttribute<Boolean>("text-underline", false, BooleanFactory.INSTANCE);
    public static final UIAttribute<Boolean> TEXT_ITALIC = new UIAttribute<Boolean>("text-italic", false, BooleanFactory.INSTANCE);
    public static final UIAttribute<Boolean> TEXT_BOLD = new UIAttribute<Boolean>("text-bold", false, BooleanFactory.INSTANCE);
    public static final UIAttribute<Boolean> TEXT_SHADOW = new UIAttribute<Boolean>("text-shadow", false, BooleanFactory.INSTANCE);
    public static final UIAttribute<UIOrientation> ORIENTATION = new UIAttribute<UIOrientation>("orientation", UIOrientation.VERTICAL, UIOrientation.FACTORY);
    public static final UIAttribute<Integer> STACK_SPACING = new UIAttribute<Integer>("stack-spacing", 0, IntegerFactory.INSTANCE);
    public static final UIAttribute<Boolean> BACKGROUND_ENABLED = new UIAttribute<Boolean>("background-enabled", true, BooleanFactory.INSTANCE);
    public static final UIAttribute<Color> PRIMARY_COLOR = new UIAttribute<Color>("primary-color", Color.RED, ColorFactory.INSTANCE);
    public static final UIAttribute<Color> SECONDARY_COLOR = new UIAttribute<Color>("secondary-color", new Color(0xAA0000), ColorFactory.INSTANCE);
    public static final UIAttribute<Color> BORDER_COLOR = new UIAttribute<Color>("border-color", new Color(0x373737), ColorFactory.INSTANCE);
    public static final UIAttribute<Integer> SCROLLBAR_WIDTH = new UIAttribute<Integer>("scrollbar-width", 6, IntegerFactory.INSTANCE);
    public static final UIAttribute<Color> SCROLLBAR_BACKGROUND_COLOR = new UIAttribute<Color>("scrollbar-background-color", Color.BLACK, ColorFactory.INSTANCE);
    public static final UIAttribute<Color> SCROLLBAR_PRIMARY_COLOR = new UIAttribute<Color>("scrollbar-primary-color", new Color(0xC0C0C0), ColorFactory.INSTANCE);
    public static final UIAttribute<Color> SCROLLBAR_SCEONDARY_COLOR = new UIAttribute<Color>("scrollbar-secondary-color", new Color(0x808080), ColorFactory.INSTANCE);
    public static final UIAttribute<Color> TEXTFIELD_ENABLED_COLOR = new UIAttribute<Color>("textfield-enabled-color", new Color(0xE0E0E0), ColorFactory.INSTANCE);
    public static final UIAttribute<Color> TEXTFIELD_DISABLED_COLOR = new UIAttribute<Color>("textfield-disabled-color", new Color(0x707070), ColorFactory.INSTANCE);
    public static final UIAttribute<Color> TEXTFIELD_BACKGROUND_COLOR = new UIAttribute<Color>("textfield-background-color", Color.BLACK, ColorFactory.INSTANCE);
    public static final UIAttribute<Color> TEXTFIELD_BORDER_COLOR = new UIAttribute<Color>("textfield-border-color", new Color(-6250336), ColorFactory.INSTANCE);
    public static final UIAttribute<Integer> TEXTFIELD_BORDER_WIDTH = new UIAttribute<Integer>("textfield-border-width", 1, IntegerFactory.INSTANCE);
    public static final UIAttribute<Color> TEXTFIELD_CURSOR_COLOR = new UIAttribute<Color>("textfield-cursor-color", new Color(-3092272), ColorFactory.INSTANCE);
    public static final UIAttribute<Color> TEXTFIELD_SELECTION_COLOR = new UIAttribute<Color>("textfield-selection-color", Color.BLUE, ColorFactory.INSTANCE);
    private final T defaultVal;

    public UIAttribute(String name, T defaultVal, ValueFactory<T> valueFactory) {
        this.defaultVal = defaultVal;
        attributes.put(name, this);
        valueFactories.put(this, valueFactory);
    }

    public static <T> UIAttribute<T> get(String name) {
        return attributes.get(name);
    }

    public static <T> Function<String, T> getValueFactory(UIAttribute<T> attr) {
        ValueFactory<?> factory = valueFactories.get(attr);
        return s -> factory.create((String)s, attr.defaultVal);
    }

    public T getDefaultVal() {
        return this.defaultVal;
    }
}

