/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.shadowmc.ui.util;

import java.util.LinkedHashSet;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.inventory.Container;
import net.shadowfacts.shadowmc.ui.UIElement;
import net.shadowfacts.shadowmc.ui.UIKeyInteractable;
import net.shadowfacts.shadowmc.ui.mcwrapper.UIContainerWrapper;
import net.shadowfacts.shadowmc.ui.mcwrapper.UIScreenWrapper;
import net.shadowfacts.shadowmc.ui.style.stylesheet.Stylesheet;
import net.shadowfacts.shadowmc.ui.style.stylesheet.StylesheetParser;

public class UIBuilder {
    private final Set<UIElement> children = new LinkedHashSet<UIElement>();
    private final Set<UIKeyInteractable> keyHandlers = new LinkedHashSet<UIKeyInteractable>();

    public UIBuilder() {
        this.keyHandlers.add((keyCode, keyChar) -> {
            if (keyCode == 18) {
                Minecraft.func_71410_x().func_147108_a(null);
            }
        });
        this.keyHandlers.add((keyCode, keyChar) -> {
            if (keyCode == 1) {
                Minecraft.func_71410_x().func_147108_a(null);
            }
        });
    }

    public UIBuilder add(UIElement e) {
        this.children.add(e);
        return this;
    }

    public UIBuilder style(Stylesheet stylesheet) {
        this.children.forEach(stylesheet::style);
        return this;
    }

    public UIBuilder style(String id) {
        return this.style(StylesheetParser.parse(StylesheetParser.load(id)));
    }

    public UIBuilder clearKeyHandlers() {
        this.keyHandlers.clear();
        return this;
    }

    public UIBuilder addKeyHandler(UIKeyInteractable handler) {
        this.keyHandlers.add(handler);
        return this;
    }

    public GuiScreen createScreen() {
        UIScreenWrapper wrapper = new UIScreenWrapper();
        this.children.forEach(wrapper::add);
        wrapper.layout();
        wrapper.setKeyHandlers(this.keyHandlers);
        return wrapper;
    }

    public GuiContainer createContainer(Container container) {
        UIContainerWrapper wrapper = new UIContainerWrapper(container);
        this.children.forEach(wrapper::add);
        wrapper.layout();
        wrapper.setKeyHandlers(this.keyHandlers);
        return wrapper;
    }
}

