/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.deathcounter.common.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import me.ichun.mods.deathcounter.common.core.DeathCounter;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class CommandDeathCounter
extends CommandBase {
    public String func_71517_b() {
        return "dc";
    }

    public String func_71518_a(ICommandSender par1ICommandSender) {
        return "/" + this.func_71517_b() + " (leaderboard/reset) [all/user]";
    }

    public List<String> func_71514_a() {
        return Collections.singletonList("deathcounter");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void func_184881_a(MinecraftServer server, ICommandSender commandSender, String[] args) throws CommandException {
        if (args.length <= 0) throw new WrongUsageException("/" + this.func_71517_b() + " (leaderboard/reset) [all/user]", new Object[0]);
        if ("leaderboard".toLowerCase().startsWith(args[0])) {
            if (args.length >= 2) {
                if (args[1].equalsIgnoreCase("all")) {
                    CommandDeathCounter.broadcastLeaderboard(null);
                    return;
                } else {
                    CommandDeathCounter.broadcastLeaderboard(args[1]);
                }
                return;
            } else {
                CommandDeathCounter.broadcastLeaderboard(commandSender.func_70005_c_());
            }
            return;
        } else {
            if (!"reset".toLowerCase().startsWith(args[0])) throw new WrongUsageException("/" + this.func_71517_b() + " (leaderboard/reset) [all/user]", new Object[0]);
            if (args.length < 2) throw new WrongUsageException("/" + this.func_71517_b() + " reset [all/user]", new Object[0]);
            if (args[1].equalsIgnoreCase("all")) {
                CommandDeathCounter.func_152373_a((ICommandSender)commandSender, (ICommand)this, (String)"dc.command.resetAll", (Object[])new Object[0]);
                DeathCounter.console(commandSender.func_70005_c_() + ": Resetting deaths for all players");
                return;
            } else if (DeathCounter.instance.clearDeath(args[1])) {
                CommandDeathCounter.func_152373_a((ICommandSender)commandSender, (ICommand)this, (String)"dc.command.resetPlayer", (Object[])new Object[0]);
                DeathCounter.console(commandSender.func_70005_c_() + ": Resetting deaths for " + args[1]);
                return;
            } else {
                commandSender.func_145747_a((ITextComponent)new TextComponentTranslation("dc.command.noDeathsPlayer", new Object[]{args[1]}));
            }
        }
    }

    public static void broadcastLeaderboard(String s) {
        ArrayList<Object> playersToNotify = new ArrayList<Object>();
        if (s != null) {
            if (!s.equals("Server")) {
                if (FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_152612_a(s) == null) {
                    return;
                }
                playersToNotify.add(FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_152612_a(s));
            }
        } else {
            List players = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_181057_v();
            for (Object o : players) {
                EntityPlayer player = (EntityPlayer)o;
                playersToNotify.add(player);
            }
        }
        if (s != null && s.equals("Server")) {
            if (DeathCounter.ranking.isEmpty()) {
                DeathCounter.console("No deaths have occured on this server yet.");
            } else {
                DeathCounter.console("Death Leaderboard:");
                for (int i = 1; i <= DeathCounter.leaderboardCount && i - 1 < DeathCounter.ranking.size(); ++i) {
                    DeathCounter.console("   " + DeathCounter.instance.getDisplayedRank(DeathCounter.ranking.get(i - 1)) + "  " + DeathCounter.ranking.get(i - 1) + " (" + DeathCounter.instance.getDeathCount(DeathCounter.ranking.get(i - 1)) + (DeathCounter.instance.getDeathCount(DeathCounter.ranking.get(i - 1)) == 1 ? " Death)" : " Deaths)"));
                }
            }
        } else {
            for (EntityPlayer entityPlayer : playersToNotify) {
                if (DeathCounter.ranking.isEmpty()) {
                    entityPlayer.func_145747_a((ITextComponent)new TextComponentTranslation("dc.command.noDeaths", new Object[0]));
                    continue;
                }
                boolean isPlayer = false;
                entityPlayer.func_145747_a((ITextComponent)new TextComponentTranslation("dc.command.leaderboard", new Object[0]));
                for (int i = 1; i <= DeathCounter.leaderboardCount && i - 1 < DeathCounter.ranking.size(); ++i) {
                    String playerName = DeathCounter.ranking.get(i - 1);
                    if (playerName.equals(entityPlayer.func_70005_c_())) {
                        isPlayer = true;
                    }
                    int rank = DeathCounter.instance.getDisplayedRank(playerName);
                    entityPlayer.func_145747_a((ITextComponent)new TextComponentString((rank == 1 ? "\u00a7e" : (rank == 2 ? "\u00a77" : (rank == 3 ? "\u00a74" : ""))) + (playerName.equals(entityPlayer.func_70005_c_()) ? " ->" : "    ") + rank + "  " + DeathCounter.ranking.get(i - 1) + " (" + DeathCounter.instance.getDeathCount(DeathCounter.ranking.get(i - 1)) + (DeathCounter.instance.getDeathCount(DeathCounter.ranking.get(i - 1)) == 1 ? " Death)" : " Deaths)")));
                }
                if (isPlayer) continue;
                int rank = DeathCounter.instance.getDisplayedRank(entityPlayer.func_70005_c_());
                entityPlayer.func_145747_a((ITextComponent)new TextComponentString(" ->" + rank + (rank >= 10 ? " " : "  ") + entityPlayer.func_70005_c_() + " (" + DeathCounter.instance.getDeathCount(entityPlayer.func_70005_c_()) + (DeathCounter.instance.getDeathCount(entityPlayer.func_70005_c_()) == 1 ? " Death)" : " Deaths)")));
            }
        }
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
        if (args.length == 1) {
            return CommandDeathCounter.func_71530_a((String[])args, (String[])new String[]{"reset", "leaderboard"});
        }
        if (args.length == 2) {
            return CommandDeathCounter.func_71530_a((String[])args, (String[])FMLCommonHandler.instance().getMinecraftServerInstance().func_71213_z());
        }
        return null;
    }
}

