/*
 * Decompiled with CFR 0.152.
 */
package com.mcupdater.mods.igirftools;

import com.github.lunatrius.ingameinfo.tag.Tag;
import com.github.lunatrius.ingameinfo.tag.registry.TagRegistry;
import com.mcupdater.mods.igirftools.IGIRFTools;
import mcjty.rftoolsdim.dimensions.DimensionInformation;
import mcjty.rftoolsdim.dimensions.DimensionStorage;
import mcjty.rftoolsdim.dimensions.RfToolsDimensionManager;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;

public abstract class TagRFTools
extends Tag {
    public String getCategory() {
        return "rftools";
    }

    public static void register() {
        TagRegistry.INSTANCE.register(new RFToolsDimension().setName("rftdimension"));
        TagRegistry.INSTANCE.register(new RFToolsDimName().setName("rftdimensionname"));
        TagRegistry.INSTANCE.register(new RFToolsDimPower().setName("rftdimensionpower"));
        TagRegistry.INSTANCE.register(new RFToolsDimCost().setName("rftdimensioncost"));
    }

    public void log(Tag tag, Throwable ex) {
        FMLCommonHandler.instance().getFMLLogger().warn(IGIRFTools.metadata.modId + ":" + tag.getName(), ex);
    }

    public static class RFToolsDimCost
    extends TagRFTools {
        public String getValue() {
            try {
                int id = RFToolsDimCost.player.field_70170_p.field_73011_w.getDimension();
                RfToolsDimensionManager dimensionManager = RfToolsDimensionManager.getDimensionManager((World)RFToolsDimCost.player.field_70170_p);
                DimensionInformation dimensionInformation = dimensionManager.getDimensionInformation(id);
                if (dimensionInformation == null) {
                    return "N/A";
                }
                return String.valueOf(dimensionInformation.getActualRfCost());
            }
            catch (Throwable e) {
                this.log(this, e);
                return String.valueOf(false);
            }
        }
    }

    public static class RFToolsDimName
    extends TagRFTools {
        public String getValue() {
            try {
                int id = RFToolsDimName.player.field_70170_p.field_73011_w.getDimension();
                RfToolsDimensionManager dimensionManager = RfToolsDimensionManager.getDimensionManager((World)RFToolsDimName.player.field_70170_p);
                DimensionInformation dimensionInformation = dimensionManager.getDimensionInformation(id);
                if (dimensionInformation == null) {
                    return "N/A";
                }
                return dimensionInformation.getName();
            }
            catch (Throwable e) {
                this.log(this, e);
                return String.valueOf(false);
            }
        }
    }

    public static class RFToolsDimPower
    extends TagRFTools {
        public String getValue() {
            try {
                int id = RFToolsDimPower.player.field_70170_p.field_73011_w.getDimension();
                RfToolsDimensionManager dimensionManager = RfToolsDimensionManager.getDimensionManager((World)RFToolsDimPower.player.field_70170_p);
                DimensionInformation dimensionInformation = dimensionManager.getDimensionInformation(id);
                if (dimensionInformation == null) {
                    return "N/A";
                }
                DimensionStorage storage = DimensionStorage.getDimensionStorage((World)player.func_130014_f_());
                int power = storage != null ? storage.getEnergyLevel(id) : 0;
                return String.valueOf(power);
            }
            catch (Throwable e) {
                this.log(this, e);
                return String.valueOf(false);
            }
        }
    }

    public static class RFToolsDimension
    extends TagRFTools {
        public String getValue() {
            try {
                int id = RFToolsDimension.player.field_70170_p.field_73011_w.getDimension();
                RfToolsDimensionManager dimensionManager = RfToolsDimensionManager.getDimensionManager((World)RFToolsDimension.player.field_70170_p);
                DimensionInformation dimensionInformation = dimensionManager.getDimensionInformation(id);
                return String.valueOf(dimensionInformation != null);
            }
            catch (Throwable e) {
                this.log(this, e);
                return String.valueOf(false);
            }
        }
    }
}

