/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cxlibrary.gui.control;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import cubex2.cxlibrary.gui.GuiTexture;
import cubex2.cxlibrary.gui.control.Anchor;
import cubex2.cxlibrary.gui.control.Button;
import cubex2.cxlibrary.gui.control.Control;
import cubex2.cxlibrary.gui.control.ControlBuilder;
import cubex2.cxlibrary.gui.control.HorizontalProgressBar;
import cubex2.cxlibrary.gui.control.Label;
import cubex2.cxlibrary.gui.control.PictureBox;
import cubex2.cxlibrary.gui.control.VerticalProgressBar;
import cubex2.cxlibrary.gui.data.GuiData;
import cubex2.cxlibrary.gui.data.IControlProvider;
import cubex2.cxlibrary.util.ClientUtil;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.util.ResourceLocation;

public class ControlContainer<T extends Control>
extends Control
implements IControlProvider {
    protected GuiData data;
    private final List<T> children = Lists.newLinkedList();
    private final Map<String, T> childrenMap = Maps.newHashMap();

    public ControlContainer(ResourceLocation location, Anchor anchor, ControlContainer parent) {
        super(anchor, parent);
        this.data = ClientUtil.loadGuiData(location, true);
    }

    public void addChild(T child, String name) {
        this.children.add(child);
        if (name != null) {
            this.childrenMap.put(name, child);
        }
    }

    @Override
    public Control getControl(String name) {
        if (this.childrenMap.containsKey(name)) {
            return (Control)((Object)this.childrenMap.get(name));
        }
        return null;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.children.forEach(c -> c.setEnabled(enabled));
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.children.forEach(c -> c.setVisible(visible));
    }

    @Override
    public void updateBounds() {
        super.updateBounds();
        this.children.forEach(Control::updateBounds);
    }

    @Override
    public void draw(int mouseX, int mouseY, float partialTicks) {
        super.draw(mouseX, mouseY, partialTicks);
        this.children.stream().filter(Control::isVisible).forEach(c -> c.draw(mouseX, mouseY, partialTicks));
    }

    @Override
    public void drawForeground(int mouseX, int mouseY, float partialTicks) {
        super.drawForeground(mouseX, mouseY, partialTicks);
        this.children.stream().filter(Control::isVisible).forEach(c -> c.drawForeground(mouseX, mouseY, partialTicks));
    }

    @Override
    public void update(int mouseX, int mouseY) {
        super.update(mouseX, mouseY);
        this.children.forEach(c -> c.update(mouseX, mouseY));
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY, int button, boolean intoControl) {
        super.mouseClicked(mouseX, mouseY, button, intoControl);
        Iterator it = this.children.stream().filter(Control::isEnabled).iterator();
        while (it.hasNext()) {
            Control c = (Control)((Object)it.next());
            boolean inControl = c.isMouseOverControl(mouseX, mouseY);
            c.mouseClicked(mouseX, mouseY, button, inControl);
            if (!inControl) continue;
            this.controlClicked(c, mouseX, mouseY, button);
        }
    }

    protected void controlClicked(T c, int mouseX, int mouseY, int button) {
        if (this.parent instanceof ControlContainer) {
            this.parent.controlClicked(c, mouseX, mouseY, button);
        }
    }

    @Override
    public void mouseReleased(int mouseX, int mouseY, int button) {
        super.mouseReleased(mouseX, mouseY, button);
        this.children.stream().filter(Control::isEnabled).forEach(c -> c.mouseReleased(mouseX, mouseY, button));
    }

    @Override
    public void mouseClickMove(int mouseX, int mouseY, int button, long timeSinceLastClick) {
        super.mouseClickMove(mouseX, mouseY, button, timeSinceLastClick);
        this.children.stream().filter(Control::isEnabled).forEach(c -> c.mouseClickMove(mouseX, mouseY, button, timeSinceLastClick));
    }

    @Override
    public void keyTyped(char typedChar, int keyCode) {
        super.keyTyped(typedChar, keyCode);
        this.children.stream().filter(Control::isEnabled).forEach(c -> c.keyTyped(typedChar, keyCode));
    }

    @Override
    public void onClosed() {
        super.onClosed();
        this.children.forEach(Control::onClosed);
    }

    public <S extends Control> Builder<S> container(String name, ResourceLocation dataLocation) {
        return new Builder(dataLocation, this.data, name, this);
    }

    public PictureBox.Builder pictureBox(String name, GuiTexture texture, String part) {
        return new PictureBox.Builder(texture, part, this.data, name, this);
    }

    public HorizontalProgressBar.Builder horizontalBar(String name, GuiTexture texture, String part) {
        return new HorizontalProgressBar.Builder(texture, part, this.data, name, this);
    }

    public VerticalProgressBar.Builder verticalBar(String name, GuiTexture texture, String part) {
        return new VerticalProgressBar.Builder(texture, part, this.data, name, this);
    }

    public Button.Builder button(String name, String text) {
        return new Button.Builder(text, this.data, name, this);
    }

    public Label.Builder label(String name, String text) {
        return new Label.Builder(text, this.data, name, this);
    }

    public static class Builder<S extends Control>
    extends ControlBuilder<ControlContainer<S>> {
        private final ResourceLocation dataLocation;

        public Builder(ResourceLocation dataLocation, GuiData data, String name, ControlContainer parent) {
            super(data, name, parent);
            this.dataLocation = dataLocation;
        }

        @Override
        protected ControlContainer<S> createInstance() {
            return new ControlContainer(this.dataLocation, this.anchor, this.parent);
        }
    }
}

