/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cxlibrary.gui.control;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import cubex2.cxlibrary.gui.control.ScreenCenter;
import cubex2.cxlibrary.gui.control.SlotControl;
import cubex2.cxlibrary.inventory.ISlotCX;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import org.lwjgl.input.Keyboard;

public class ScreenContainer
extends ScreenCenter {
    protected RenderItem itemRender;
    protected FontRenderer fontRendererObj;
    private final Container container;
    private Slot theSlot;
    private Slot clickedSlot;
    private boolean isRightMouseClick;
    private ItemStack draggedStack;
    private int touchUpX;
    private int touchUpY;
    private Slot returningStackDestSlot;
    private long returningStackTime;
    private ItemStack returningStack;
    private Slot currentDragTargetSlot;
    private long dragItemDropDelay;
    protected final Set<Slot> dragSplittingSlots = Sets.newHashSet();
    protected boolean dragSplitting;
    private int dragSplittingLimit;
    private int dragSplittingButton;
    private boolean ignoreMouseUp = true;
    private int dragSplittingRemnant;
    private long lastClickTime;
    private Slot lastClickSlot;
    private int lastClickButton;
    private boolean doubleClick;
    private ItemStack shiftClickedSlot;
    private List<SlotControl> slots = Lists.newLinkedList();
    private SlotControl[] hotbarSlots = new SlotControl[9];

    public ScreenContainer(Container container, ResourceLocation location) {
        super(location);
        this.container = container;
        for (Slot slot : container.field_75151_b) {
            SlotControl slotControl = slot instanceof ISlotCX ? (SlotControl)((Object)this.data.apply(this.slot(null, slot)).add()) : (SlotControl)((Object)this.slot(null, slot).left(slot.field_75223_e).top(slot.field_75221_f).add());
            this.slots.add(slotControl);
            if (!(slot.field_75224_c instanceof InventoryPlayer) || slot.getSlotIndex() < 0 || slot.getSlotIndex() >= 9 || ((InventoryPlayer)slot.field_75224_c).field_70458_d != this.mc.field_71439_g) continue;
            this.hotbarSlots[slot.getSlotIndex()] = slotControl;
        }
    }

    public SlotControl getSlot(String name, int index) {
        for (SlotControl slotControl : this.slots) {
            Slot slot = slotControl.getSlot();
            if (!(slot instanceof ISlotCX) || !name.equals(((ISlotCX)slot).getName()) || slot.getSlotIndex() != index) continue;
            return slotControl;
        }
        return null;
    }

    public SlotControl.Builder slot(String name, Slot slot) {
        return new SlotControl.Builder(slot, this.data, name, this.window);
    }

    @Override
    public void updateBounds() {
        this.itemRender = this.mc.func_175599_af();
        this.fontRendererObj = this.mc.field_71466_p;
        super.updateBounds();
        this.mc.field_71439_g.field_71070_bA = this.container;
    }

    @Override
    public void draw(int mouseX, int mouseY, float partialTicks) {
        this.gui.func_146276_q_();
        super.draw(mouseX, mouseY, partialTicks);
        GlStateManager.func_179101_C();
        RenderHelper.func_74518_a();
        GlStateManager.func_179140_f();
        GlStateManager.func_179097_i();
        RenderHelper.func_74520_c();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179091_B();
        this.theSlot = null;
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (SlotControl slot : this.slots) {
            if (slot.isVisible()) {
                this.drawSlotAt(slot.getSlot(), slot.getX(), slot.getY());
            }
            if (!slot.isMouseOverControl(mouseX, mouseY) || !slot.getSlot().func_111238_b()) continue;
            if (slot.isEnabled()) {
                this.theSlot = slot.getSlot();
            }
            if (!slot.isVisible()) continue;
            this.drawSlotMouseOver(slot.getX(), slot.getY());
        }
    }

    @Override
    public void drawForeground(int mouseX, int mouseY, float partialTicks) {
        super.drawForeground(mouseX, mouseY, partialTicks);
        RenderHelper.func_74520_c();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)this.window.getX(), (float)this.window.getY(), (float)0.0f);
        this.drawDraggedStack(mouseX, mouseY);
        this.drawReturningStack();
        GlStateManager.func_179121_F();
        GlStateManager.func_179145_e();
        GlStateManager.func_179126_j();
        RenderHelper.func_74519_b();
    }

    private void drawSlotMouseOver(int x, int y) {
        GlStateManager.func_179140_f();
        GlStateManager.func_179097_i();
        GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        this.func_73733_a(x, y, x + 16, y + 16, -2130706433, -2130706433);
        GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        GlStateManager.func_179145_e();
        GlStateManager.func_179126_j();
    }

    private void drawReturningStack() {
        if (this.returningStack != null) {
            float f = (float)(Minecraft.func_71386_F() - this.returningStackTime) / 100.0f;
            if (f >= 1.0f) {
                f = 1.0f;
                this.returningStack = null;
            }
            int l2 = this.returningStackDestSlot.field_75223_e - this.touchUpX;
            int i3 = this.returningStackDestSlot.field_75221_f - this.touchUpY;
            int l1 = this.touchUpX + (int)((float)l2 * f);
            int i2 = this.touchUpY + (int)((float)i3 * f);
            this.drawItemStack(this.returningStack, l1, i2, null);
        }
    }

    private void drawDraggedStack(int mouseX, int mouseY) {
        ItemStack itemstack;
        InventoryPlayer inventoryplayer = this.mc.field_71439_g.field_71071_by;
        ItemStack itemStack = itemstack = this.draggedStack == null ? inventoryplayer.func_70445_o() : this.draggedStack;
        if (itemstack != null) {
            int j2 = 8;
            int k2 = this.draggedStack == null ? 8 : 16;
            String s = null;
            if (this.draggedStack != null && this.isRightMouseClick) {
                itemstack = itemstack.func_77946_l();
                itemstack.field_77994_a = MathHelper.func_76123_f((float)((float)itemstack.field_77994_a / 2.0f));
            } else if (this.dragSplitting && this.dragSplittingSlots.size() > 1) {
                itemstack = itemstack.func_77946_l();
                itemstack.field_77994_a = this.dragSplittingRemnant;
                if (itemstack.field_77994_a == 0) {
                    s = "" + TextFormatting.YELLOW + "0";
                }
            }
            this.drawItemStack(itemstack, mouseX - this.window.getX() - j2, mouseY - this.window.getY() - k2, s);
        }
    }

    private void drawItemStack(ItemStack stack, int x, int y, String altText) {
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)32.0f);
        this.field_73735_i = 200.0f;
        this.itemRender.field_77023_b = 200.0f;
        FontRenderer font = null;
        if (stack != null) {
            font = stack.func_77973_b().getFontRenderer(stack);
        }
        if (font == null) {
            font = this.fontRendererObj;
        }
        this.itemRender.func_180450_b(stack, x, y);
        this.itemRender.func_180453_a(font, stack, x, y - (this.draggedStack == null ? 0 : 8), altText);
        this.field_73735_i = 0.0f;
        this.itemRender.field_77023_b = 0.0f;
    }

    private void drawSlotAt(Slot slotIn, int x, int y) {
        TextureAtlasSprite textureatlassprite;
        ItemStack itemstack = slotIn.func_75211_c();
        boolean flag = false;
        boolean flag1 = slotIn == this.clickedSlot && this.draggedStack != null && !this.isRightMouseClick;
        ItemStack itemstack1 = this.mc.field_71439_g.field_71071_by.func_70445_o();
        String s = null;
        if (slotIn == this.clickedSlot && this.draggedStack != null && this.isRightMouseClick && itemstack != null) {
            itemstack = itemstack.func_77946_l();
            itemstack.field_77994_a /= 2;
        } else if (this.dragSplitting && this.dragSplittingSlots.contains(slotIn) && itemstack1 != null) {
            if (this.dragSplittingSlots.size() == 1) {
                return;
            }
            if (Container.func_94527_a((Slot)slotIn, (ItemStack)itemstack1, (boolean)true) && this.container.func_94531_b(slotIn)) {
                itemstack = itemstack1.func_77946_l();
                flag = true;
                Container.func_94525_a(this.dragSplittingSlots, (int)this.dragSplittingLimit, (ItemStack)itemstack, (int)(slotIn.func_75211_c() == null ? 0 : slotIn.func_75211_c().field_77994_a));
                if (itemstack.field_77994_a > itemstack.func_77976_d()) {
                    s = TextFormatting.YELLOW + "" + itemstack.func_77976_d();
                    itemstack.field_77994_a = itemstack.func_77976_d();
                }
                if (itemstack.field_77994_a > slotIn.func_178170_b(itemstack)) {
                    s = TextFormatting.YELLOW + "" + slotIn.func_178170_b(itemstack);
                    itemstack.field_77994_a = slotIn.func_178170_b(itemstack);
                }
            } else {
                this.dragSplittingSlots.remove(slotIn);
                this.updateActivePotionEffects();
            }
        }
        this.field_73735_i = 100.0f;
        this.itemRender.field_77023_b = 100.0f;
        if (itemstack == null && slotIn.func_111238_b() && (textureatlassprite = slotIn.getBackgroundSprite()) != null) {
            GlStateManager.func_179140_f();
            this.mc.func_110434_K().func_110577_a(slotIn.getBackgroundLocation());
            this.func_175175_a(x, y, textureatlassprite, 16, 16);
            GlStateManager.func_179145_e();
            flag1 = true;
        }
        if (!flag1) {
            if (flag) {
                ScreenContainer.func_73734_a((int)x, (int)y, (int)(x + 16), (int)(y + 16), (int)-2130706433);
            }
            GlStateManager.func_179126_j();
            this.itemRender.func_184391_a((EntityLivingBase)this.mc.field_71439_g, itemstack, x, y);
            this.itemRender.func_180453_a(this.fontRendererObj, itemstack, x, y, s);
        }
        this.itemRender.field_77023_b = 0.0f;
        this.field_73735_i = 0.0f;
    }

    private void updateActivePotionEffects() {
        ItemStack itemstack = this.mc.field_71439_g.field_71071_by.func_70445_o();
        if (itemstack != null && this.dragSplitting) {
            this.dragSplittingRemnant = itemstack.field_77994_a;
            for (Slot slot : this.dragSplittingSlots) {
                ItemStack itemstack1 = itemstack.func_77946_l();
                int i = slot.func_75211_c() == null ? 0 : slot.func_75211_c().field_77994_a;
                Container.func_94525_a(this.dragSplittingSlots, (int)this.dragSplittingLimit, (ItemStack)itemstack1, (int)i);
                if (itemstack1.field_77994_a > itemstack1.func_77976_d()) {
                    itemstack1.field_77994_a = itemstack1.func_77976_d();
                }
                if (itemstack1.field_77994_a > slot.func_178170_b(itemstack1)) {
                    itemstack1.field_77994_a = slot.func_178170_b(itemstack1);
                }
                this.dragSplittingRemnant -= itemstack1.field_77994_a - i;
            }
        }
    }

    private Slot getSlotAtPosition(int x, int y) {
        for (SlotControl slot : this.slots) {
            if (!slot.isEnabled() || !slot.getBounds().contains(x, y)) continue;
            return slot.getSlot();
        }
        return null;
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY, int mouseButton, boolean intoControl) {
        super.mouseClicked(mouseX, mouseY, mouseButton, intoControl);
        boolean flag = this.mc.field_71474_y.field_74322_I.isActiveAndMatches(mouseButton - 100);
        Slot slot = this.getSlotAtPosition(mouseX, mouseY);
        long i = Minecraft.func_71386_F();
        this.doubleClick = this.lastClickSlot == slot && i - this.lastClickTime < 250L && this.lastClickButton == mouseButton;
        this.ignoreMouseUp = false;
        if (mouseButton == 0 || mouseButton == 1 || flag) {
            boolean isOutsideGui = slot != null && !this.window.getBounds().contains(mouseX, mouseY);
            int l = -1;
            if (slot != null) {
                l = slot.field_75222_d;
            }
            if (isOutsideGui) {
                l = -999;
            }
            if (this.mc.field_71474_y.field_85185_A && isOutsideGui && this.mc.field_71439_g.field_71071_by.func_70445_o() == null) {
                this.mc.func_147108_a(null);
                return;
            }
            if (l != -1) {
                if (this.mc.field_71474_y.field_85185_A) {
                    if (slot.func_75216_d()) {
                        this.clickedSlot = slot;
                        this.draggedStack = null;
                        this.isRightMouseClick = mouseButton == 1;
                    } else {
                        this.clickedSlot = null;
                    }
                } else if (!this.dragSplitting) {
                    if (this.mc.field_71439_g.field_71071_by.func_70445_o() == null) {
                        if (this.mc.field_71474_y.field_74322_I.isActiveAndMatches(mouseButton - 100)) {
                            this.handleMouseClick(slot, l, mouseButton, ClickType.CLONE);
                        } else {
                            boolean flag2 = l != -999 && (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54));
                            ClickType clicktype = ClickType.PICKUP;
                            if (flag2) {
                                this.shiftClickedSlot = slot.func_75216_d() ? slot.func_75211_c() : null;
                                clicktype = ClickType.QUICK_MOVE;
                            } else if (l == -999) {
                                clicktype = ClickType.THROW;
                            }
                            this.handleMouseClick(slot, l, mouseButton, clicktype);
                        }
                        this.ignoreMouseUp = true;
                    } else {
                        this.dragSplitting = true;
                        this.dragSplittingButton = mouseButton;
                        this.dragSplittingSlots.clear();
                        if (mouseButton == 0) {
                            this.dragSplittingLimit = 0;
                        } else if (mouseButton == 1) {
                            this.dragSplittingLimit = 1;
                        } else if (this.mc.field_71474_y.field_74322_I.isActiveAndMatches(mouseButton - 100)) {
                            this.dragSplittingLimit = 2;
                        }
                    }
                }
            }
        }
        this.lastClickSlot = slot;
        this.lastClickTime = i;
        this.lastClickButton = mouseButton;
    }

    @Override
    public void mouseClickMove(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        super.mouseClickMove(mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
        Slot slot = this.getSlotAtPosition(mouseX, mouseY);
        ItemStack itemstack = this.mc.field_71439_g.field_71071_by.func_70445_o();
        if (this.clickedSlot != null && this.mc.field_71474_y.field_85185_A) {
            if (clickedMouseButton == 0 || clickedMouseButton == 1) {
                if (this.draggedStack == null) {
                    if (slot != this.clickedSlot && this.clickedSlot.func_75211_c() != null) {
                        this.draggedStack = this.clickedSlot.func_75211_c().func_77946_l();
                    }
                } else if (this.draggedStack.field_77994_a > 1 && slot != null && Container.func_94527_a((Slot)slot, (ItemStack)this.draggedStack, (boolean)false)) {
                    long i = Minecraft.func_71386_F();
                    if (this.currentDragTargetSlot == slot) {
                        if (i - this.dragItemDropDelay > 500L) {
                            this.handleMouseClick(this.clickedSlot, this.clickedSlot.field_75222_d, 0, ClickType.PICKUP);
                            this.handleMouseClick(slot, slot.field_75222_d, 1, ClickType.PICKUP);
                            this.handleMouseClick(this.clickedSlot, this.clickedSlot.field_75222_d, 0, ClickType.PICKUP);
                            this.dragItemDropDelay = i + 750L;
                            --this.draggedStack.field_77994_a;
                        }
                    } else {
                        this.currentDragTargetSlot = slot;
                        this.dragItemDropDelay = i;
                    }
                }
            }
        } else if (this.dragSplitting && slot != null && itemstack != null && itemstack.field_77994_a > this.dragSplittingSlots.size() && Container.func_94527_a((Slot)slot, (ItemStack)itemstack, (boolean)true) && slot.func_75214_a(itemstack) && this.container.func_94531_b(slot)) {
            this.dragSplittingSlots.add(slot);
            this.updateActivePotionEffects();
        }
    }

    @Override
    public void mouseReleased(int mouseX, int mouseY, int state) {
        super.mouseReleased(mouseX, mouseY, state);
        Slot slot = this.getSlotAtPosition(mouseX, mouseY);
        int i = this.window.getX();
        int j = this.window.getY();
        boolean isOutsideGui = slot != null && !this.window.getBounds().contains(mouseX, mouseY);
        int k = -1;
        if (slot != null) {
            k = slot.field_75222_d;
        }
        if (isOutsideGui) {
            k = -999;
        }
        if (this.doubleClick && slot != null && state == 0 && this.container.func_94530_a(null, slot)) {
            if (GuiScreen.func_146272_n()) {
                if (slot.field_75224_c != null && this.shiftClickedSlot != null) {
                    for (Slot slot2 : this.container.field_75151_b) {
                        if (slot2 == null || !slot2.func_82869_a((EntityPlayer)this.mc.field_71439_g) || !slot2.func_75216_d() || slot2.field_75224_c != slot.field_75224_c || !Container.func_94527_a((Slot)slot2, (ItemStack)this.shiftClickedSlot, (boolean)true)) continue;
                        this.handleMouseClick(slot2, slot2.field_75222_d, state, ClickType.QUICK_MOVE);
                    }
                }
            } else {
                this.handleMouseClick(slot, k, state, ClickType.PICKUP_ALL);
            }
            this.doubleClick = false;
            this.lastClickTime = 0L;
        } else {
            if (this.dragSplitting && this.dragSplittingButton != state) {
                this.dragSplitting = false;
                this.dragSplittingSlots.clear();
                this.ignoreMouseUp = true;
                return;
            }
            if (this.ignoreMouseUp) {
                this.ignoreMouseUp = false;
                return;
            }
            if (this.clickedSlot != null && this.mc.field_71474_y.field_85185_A) {
                if (state == 0 || state == 1) {
                    if (this.draggedStack == null && slot != this.clickedSlot) {
                        this.draggedStack = this.clickedSlot.func_75211_c();
                    }
                    boolean canAdd = Container.func_94527_a((Slot)slot, (ItemStack)this.draggedStack, (boolean)false);
                    if (k != -1 && this.draggedStack != null && canAdd) {
                        this.handleMouseClick(this.clickedSlot, this.clickedSlot.field_75222_d, state, ClickType.PICKUP);
                        this.handleMouseClick(slot, k, 0, ClickType.PICKUP);
                        if (this.mc.field_71439_g.field_71071_by.func_70445_o() != null) {
                            this.handleMouseClick(this.clickedSlot, this.clickedSlot.field_75222_d, state, ClickType.PICKUP);
                            this.touchUpX = mouseX - i;
                            this.touchUpY = mouseY - j;
                            this.returningStackDestSlot = this.clickedSlot;
                            this.returningStack = this.draggedStack;
                            this.returningStackTime = Minecraft.func_71386_F();
                        } else {
                            this.returningStack = null;
                        }
                    } else if (this.draggedStack != null) {
                        this.touchUpX = mouseX - i;
                        this.touchUpY = mouseY - j;
                        this.returningStackDestSlot = this.clickedSlot;
                        this.returningStack = this.draggedStack;
                        this.returningStackTime = Minecraft.func_71386_F();
                    }
                    this.draggedStack = null;
                    this.clickedSlot = null;
                }
            } else if (this.dragSplitting && !this.dragSplittingSlots.isEmpty()) {
                this.handleMouseClick(null, -999, Container.func_94534_d((int)0, (int)this.dragSplittingLimit), ClickType.QUICK_CRAFT);
                for (Slot slot1 : this.dragSplittingSlots) {
                    this.handleMouseClick(slot1, slot1.field_75222_d, Container.func_94534_d((int)1, (int)this.dragSplittingLimit), ClickType.QUICK_CRAFT);
                }
                this.handleMouseClick(null, -999, Container.func_94534_d((int)2, (int)this.dragSplittingLimit), ClickType.QUICK_CRAFT);
            } else if (this.mc.field_71439_g.field_71071_by.func_70445_o() != null) {
                if (this.mc.field_71474_y.field_74322_I.isActiveAndMatches(state - 100)) {
                    this.handleMouseClick(slot, k, state, ClickType.CLONE);
                } else {
                    boolean flag1;
                    boolean bl = flag1 = k != -999 && (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54));
                    if (flag1) {
                        this.shiftClickedSlot = slot != null && slot.func_75216_d() ? slot.func_75211_c() : null;
                    }
                    this.handleMouseClick(slot, k, state, flag1 ? ClickType.QUICK_MOVE : ClickType.PICKUP);
                }
            }
        }
        if (this.mc.field_71439_g.field_71071_by.func_70445_o() == null) {
            this.lastClickTime = 0L;
        }
        this.dragSplitting = false;
    }

    private void handleMouseClick(Slot slotIn, int slotId, int mouseButton, ClickType type) {
        if (slotIn != null) {
            slotId = slotIn.field_75222_d;
        }
        this.mc.field_71442_b.func_187098_a(this.container.field_75152_c, slotId, mouseButton, type, (EntityPlayer)this.mc.field_71439_g);
    }

    @Override
    public void keyTyped(char typedChar, int keyCode) {
        super.keyTyped(typedChar, keyCode);
        if (keyCode == 1 || keyCode == this.mc.field_71474_y.field_151445_Q.func_151463_i()) {
            this.mc.field_71439_g.func_71053_j();
        }
        this.checkHotbarKeys(keyCode);
        if (this.theSlot != null && this.theSlot.func_75216_d()) {
            if (keyCode == this.mc.field_71474_y.field_74322_I.func_151463_i()) {
                this.handleMouseClick(this.theSlot, this.theSlot.field_75222_d, 0, ClickType.CLONE);
            } else if (keyCode == this.mc.field_71474_y.field_74316_C.func_151463_i()) {
                this.handleMouseClick(this.theSlot, this.theSlot.field_75222_d, GuiScreen.func_146271_m() ? 1 : 0, ClickType.THROW);
            }
        }
    }

    private boolean checkHotbarKeys(int keyCode) {
        if (this.mc.field_71439_g.field_71071_by.func_70445_o() == null && this.theSlot != null) {
            for (int i = 0; i < 9; ++i) {
                if (keyCode != this.mc.field_71474_y.field_151456_ac[i].func_151463_i() || this.hotbarSlots[i] != null && !this.hotbarSlots[i].isEnabled()) continue;
                this.handleMouseClick(this.theSlot, this.theSlot.field_75222_d, i, ClickType.SWAP);
                return true;
            }
        }
        return false;
    }

    @Override
    public void onClosed() {
        super.onClosed();
        if (this.mc.field_71439_g != null) {
            this.container.func_75134_a((EntityPlayer)this.mc.field_71439_g);
        }
    }

    @Override
    public boolean doesPauseGame() {
        return false;
    }

    @Override
    public void update(int mouseX, int mouseY) {
        super.update(mouseX, mouseY);
        if (!this.mc.field_71439_g.func_70089_S() || this.mc.field_71439_g.field_70128_L) {
            this.mc.field_71439_g.func_71053_j();
        }
    }
}

