/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cxlibrary.util;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.reflect.TypeToken;
import cubex2.cxlibrary.gui.data.ControlData;
import cubex2.cxlibrary.gui.data.GuiData;
import cubex2.cxlibrary.gui.data.SlotData;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.IOUtils;

public class ClientUtil {
    private static final Map<ResourceLocation, GuiData> guiCache = Maps.newHashMap();
    private static final JsonDeserializer<Map<String, SlotData[]>> SlotDataArrayMapDeserializer = (json, typeOfT, context) -> {
        HashMap map = Maps.newHashMap();
        for (Map.Entry entry : json.getAsJsonObject().entrySet()) {
            map.put(entry.getKey(), context.deserialize((JsonElement)entry.getValue(), new TypeToken<SlotData[]>(){}.getType()));
        }
        return map;
    };
    private static final JsonDeserializer<Map<String, ControlData>> ControlDataMapDeserializer = (json, typeOfT, context) -> {
        HashMap map = Maps.newHashMap();
        for (Map.Entry entry : json.getAsJsonObject().entrySet()) {
            map.put(entry.getKey(), context.deserialize((JsonElement)entry.getValue(), new TypeToken<ControlData>(){}.getType()));
        }
        return map;
    };
    public static final Gson gson = new GsonBuilder().setPrettyPrinting().registerTypeAdapter(new TypeToken<Map<String, SlotData[]>>(){}.getType(), SlotDataArrayMapDeserializer).registerTypeAdapter(new TypeToken<Map<String, ControlData>>(){}.getType(), ControlDataMapDeserializer).create();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readResource(ResourceLocation location) {
        String ret = null;
        InputStream is = null;
        try {
            is = Minecraft.func_71410_x().func_110442_L().func_110536_a(location).func_110527_b();
            ret = IOUtils.toString((InputStream)is, (Charset)Charsets.UTF_8);
        }
        catch (IOException e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)is);
        }
        IOUtils.closeQuietly((InputStream)is);
        return ret;
    }

    public static GuiData loadGuiData(ResourceLocation location, boolean useCache) {
        if (useCache && guiCache.containsKey(location)) {
            System.out.println("Using cache for " + location);
            return guiCache.get(location);
        }
        String json = ClientUtil.readResource(location);
        GuiData data = (GuiData)gson.fromJson(json, GuiData.class);
        guiCache.put(location, data);
        return data;
    }
}

