/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.worldgen.spawners;

import com.google.gson.JsonObject;
import greymerk.roguelike.config.RogueConfig;
import greymerk.roguelike.util.JsonNBT;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.IWorldEditor;
import greymerk.roguelike.worldgen.MetaBlock;
import greymerk.roguelike.worldgen.spawners.Spawner;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.MobSpawnerBaseLogic;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.WeightedSpawnerEntity;

public class Spawnable {
    private boolean equip;
    private String name;
    private NBTTagCompound meta;

    public Spawnable(Spawner type) {
        this(Spawner.getName(type));
    }

    public Spawnable(String name) {
        this(true, name, null);
    }

    public Spawnable(String name, NBTTagCompound meta) {
        this(true, name, meta);
    }

    public Spawnable(boolean equip, String name, NBTTagCompound meta) {
        this.equip = equip;
        this.name = name;
        this.meta = meta;
    }

    public Spawnable(JsonObject data) {
        this.name = data.get("name").getAsString();
        boolean bl = this.equip = data.has("equip") ? data.get("equip").getAsBoolean() : true;
        if (data.has("meta")) {
            JsonObject metadata = data.get("meta").getAsJsonObject();
            this.meta = JsonNBT.jsonToCompound(metadata);
        }
    }

    public void generate(IWorldEditor editor, Random rand, Coord cursor, int level) {
        Coord pos = new Coord(cursor);
        editor.setBlock(pos, new MetaBlock(Blocks.field_150474_ac.func_176223_P()), true, true);
        TileEntity tileentity = editor.getTileEntity(pos);
        if (!(tileentity instanceof TileEntityMobSpawner)) {
            System.out.println("Not a mob spawner.");
            return;
        }
        TileEntityMobSpawner spawner = (TileEntityMobSpawner)tileentity;
        MobSpawnerBaseLogic spawnerLogic = spawner.func_145881_a();
        spawnerLogic.func_98272_a(this.name);
        if (this.meta != null) {
            Spawnable.setMeta(spawnerLogic, this.meta);
            return;
        }
        if (!RogueConfig.getBoolean(RogueConfig.ROGUESPAWNERS)) {
            return;
        }
        if (!this.equip) {
            return;
        }
        NBTTagCompound nbt = this.getRoguelike(level, this.name);
        Spawnable.setMeta(spawnerLogic, nbt);
    }

    private static void setMeta(MobSpawnerBaseLogic logic, NBTTagCompound nbt) {
        WeightedSpawnerEntity randomEntity = new WeightedSpawnerEntity(1, nbt);
        logic.func_184993_a(randomEntity);
        logic.func_98278_g();
    }

    private NBTTagCompound getRoguelike(int level, String type) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74778_a("id", type);
        NBTTagList activeEffects = new NBTTagList();
        nbt.func_74782_a("ActiveEffects", (NBTBase)activeEffects);
        NBTTagCompound buff = new NBTTagCompound();
        activeEffects.func_74742_a((NBTBase)buff);
        buff.func_74774_a("Id", (byte)4);
        buff.func_74774_a("Amplifier", (byte)level);
        buff.func_74768_a("Duration", 10);
        buff.func_74774_a("Ambient", (byte)0);
        return nbt;
    }
}

