/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.worldgen.spawners;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import greymerk.roguelike.util.IWeighted;
import greymerk.roguelike.util.WeightedChoice;
import greymerk.roguelike.util.WeightedRandomizer;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.IWorldEditor;
import greymerk.roguelike.worldgen.spawners.Spawnable;
import greymerk.roguelike.worldgen.spawners.Spawner;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;

public class SpawnerSettings {
    private Map<Spawner, IWeighted<Spawnable>> spawners = new HashMap<Spawner, IWeighted<Spawnable>>();

    public SpawnerSettings(JsonObject data) {
        for (Spawner type : Spawner.values()) {
            if (!data.has(type.name())) continue;
            JsonArray categoryData = data.get(type.name()).getAsJsonArray();
            WeightedRandomizer<Spawnable> spawns = new WeightedRandomizer<Spawnable>();
            this.spawners.put(type, spawns);
            for (JsonElement spawnData : categoryData) {
                JsonObject spawnObj = spawnData.getAsJsonObject();
                int weight = spawnObj.has("weight") ? spawnObj.get("weight").getAsInt() : 1;
                spawns.add(new WeightedChoice<Spawnable>(new Spawnable(spawnObj), weight));
            }
        }
    }

    public SpawnerSettings(SpawnerSettings toCopy) {
        if (toCopy == null) {
            return;
        }
        this.spawners.putAll(toCopy.spawners);
    }

    public SpawnerSettings(SpawnerSettings base, SpawnerSettings override) {
        for (Spawner type : Spawner.values()) {
            if (override != null && override.spawners.containsKey((Object)type)) {
                this.spawners.put(type, override.spawners.get((Object)type));
                continue;
            }
            if (base == null || !base.spawners.containsKey((Object)type)) continue;
            this.spawners.put(type, base.spawners.get((Object)type));
        }
    }

    public void generate(IWorldEditor editor, Random rand, Coord cursor, Spawner type, int level) {
        Spawnable toSpawn = this.spawners.containsKey((Object)type) ? this.spawners.get((Object)type).get(rand) : new Spawnable(type);
        toSpawn.generate(editor, rand, cursor, level);
    }
}

