/*
 * Decompiled with CFR 0.152.
 */
package refinedstorage.api.autocrafting.task;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import refinedstorage.api.autocrafting.ICraftingPattern;
import refinedstorage.api.autocrafting.task.ICraftingTask;
import refinedstorage.api.network.INetworkMaster;
import refinedstorage.api.network.NetworkUtils;
import refinedstorage.tile.TileController;

public abstract class CraftingTask
implements ICraftingTask {
    public static final String NBT_CHILDREN_CREATED = "ChildrenCreated";
    public static final String NBT_SATISFIED = "Satisfied";
    public static final String NBT_CHECKED = "Checked";
    public static final String NBT_TOOK = "Took";
    public static final String NBT_PATTERN_STACK = "Pattern";
    public static final String NBT_PATTERN_TYPE = "Type";
    public static final String NBT_PATTERN_CONTAINER = "Container";
    private static final String NBT_CHILD = "Child";
    protected ICraftingPattern pattern;
    protected ICraftingTask child;
    protected List<ItemStack> took = new ArrayList<ItemStack>();
    protected boolean[] childrenCreated;
    protected boolean[] satisfied;
    protected boolean[] checked;

    public CraftingTask(ICraftingPattern pattern) {
        this.pattern = pattern;
        this.childrenCreated = new boolean[pattern.getInputs().size()];
        this.satisfied = new boolean[pattern.getInputs().size()];
        this.checked = new boolean[pattern.getInputs().size()];
    }

    @Override
    public ICraftingPattern getPattern() {
        return this.pattern;
    }

    public void setTook(List<ItemStack> took) {
        this.took = took;
    }

    public List<ItemStack> getTook() {
        return this.took;
    }

    public boolean[] getChildrenCreated() {
        return this.childrenCreated;
    }

    public void setChildrenCreated(boolean[] childrenCreated) {
        this.childrenCreated = childrenCreated;
    }

    public boolean[] getSatisfied() {
        return this.satisfied;
    }

    public void setSatisfied(boolean[] satisfied) {
        this.satisfied = satisfied;
    }

    public boolean[] getChecked() {
        return this.checked;
    }

    public void setChecked(boolean[] checked) {
        this.checked = checked;
    }

    protected void tryCreateChild(INetworkMaster network, int i) {
        ICraftingPattern pattern;
        if (!this.childrenCreated[i] && (pattern = NetworkUtils.getPattern(network, this.pattern.getInputs().get(i))) != null) {
            this.child = NetworkUtils.createCraftingTask(network, pattern);
            this.childrenCreated[i] = true;
        }
    }

    @Override
    @Nullable
    public ICraftingTask getChild() {
        return this.child;
    }

    @Override
    public void setChild(@Nullable ICraftingTask child) {
        this.child = child;
    }

    @Override
    public void onCancelled(INetworkMaster network) {
        for (ItemStack stack : this.took) {
            network.insertItem(stack, stack.field_77994_a, false);
        }
        if (this.child != null) {
            this.child.onCancelled(network);
        }
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        if (this.child != null) {
            tag.func_74782_a(NBT_CHILD, (NBTBase)this.child.writeToNBT(new NBTTagCompound()));
        }
        tag.func_74778_a(NBT_PATTERN_TYPE, this.pattern.getId());
        tag.func_74782_a(NBT_PATTERN_STACK, (NBTBase)this.pattern.getStack().serializeNBT());
        tag.func_74772_a(NBT_PATTERN_CONTAINER, this.pattern.getContainer().getPosition().func_177986_g());
        CraftingTask.writeBooleanArray(tag, NBT_CHILDREN_CREATED, this.childrenCreated);
        CraftingTask.writeBooleanArray(tag, NBT_SATISFIED, this.satisfied);
        CraftingTask.writeBooleanArray(tag, NBT_CHECKED, this.checked);
        NBTTagList took = new NBTTagList();
        for (ItemStack stack : this.took) {
            took.func_74742_a((NBTBase)stack.serializeNBT());
        }
        tag.func_74782_a(NBT_TOOK, (NBTBase)took);
        return tag;
    }

    public void readChildNBT(World world, NBTTagCompound tag) {
        if (tag.func_74764_b(NBT_CHILD)) {
            this.child = TileController.readCraftingTask(world, tag.func_74775_l(NBT_CHILD));
        }
    }

    public static void writeBooleanArray(NBTTagCompound tag, String name, boolean[] array) {
        int[] intArray = new int[array.length];
        for (int i = 0; i < intArray.length; ++i) {
            intArray[i] = array[i] ? 1 : 0;
        }
        tag.func_74782_a(name, (NBTBase)new NBTTagIntArray(intArray));
    }

    public static boolean[] readBooleanArray(NBTTagCompound tag, String name) {
        int[] intArray = tag.func_74759_k(name);
        boolean[] array = new boolean[intArray.length];
        for (int i = 0; i < intArray.length; ++i) {
            array[i] = intArray[i] == 1;
        }
        return array;
    }
}

